/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dhcp4java.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetCidr
implements Serializable,
Comparable<InetCidr> {
    private static final long serialVersionUID = 1L;
    private final int addr;
    private final int mask;
    private static final String[] CIDR_MASKS = new String[]{"128.0.0.0", "192.0.0.0", "224.0.0.0", "240.0.0.0", "248.0.0.0", "252.0.0.0", "254.0.0.0", "255.0.0.0", "255.128.0.0", "255.192.0.0", "255.224.0.0", "255.240.0.0", "255.248.0.0", "255.252.0.0", "255.254.0.0", "255.255.0.0", "255.255.128.0", "255.255.192.0", "255.255.224.0", "255.255.240.0", "255.255.248.0", "255.255.252.0", "255.255.254.0", "255.255.255.0", "255.255.255.128", "255.255.255.192", "255.255.255.224", "255.255.255.240", "255.255.255.248", "255.255.255.252", "255.255.255.254", "255.255.255.255"};
    private static final Map<InetAddress, Integer> gCidr = new HashMap<InetAddress, Integer>(48);
    private static final long[] gCidrMask = new long[33];

    public InetCidr(InetAddress addr, int mask) {
        if (addr == null) {
            throw new NullPointerException("addr is null");
        }
        if (!(addr instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 addresses supported");
        }
        if (mask < 1 || mask > 32) {
            throw new IllegalArgumentException("Bad mask:" + mask + " must be between 1 and 32");
        }
        this.addr = Util.inetAddress2Int(addr) & (int)gCidrMask[mask];
        this.mask = mask;
    }

    public InetCidr(InetAddress addr, InetAddress netMask) {
        if (addr == null || netMask == null) {
            throw new NullPointerException();
        }
        if (!(addr instanceof Inet4Address) || !(netMask instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 addresses supported");
        }
        Integer intMask = gCidr.get(netMask);
        if (intMask == null) {
            throw new IllegalArgumentException("netmask: " + netMask + " is not a valid mask");
        }
        this.addr = Util.inetAddress2Int(addr) & (int)gCidrMask[intMask];
        this.mask = intMask;
    }

    public String toString() {
        return Util.int2InetAddress(this.addr).getHostAddress() + '/' + this.mask;
    }

    public InetAddress getAddr() {
        return Util.int2InetAddress(this.addr);
    }

    public long getAddrLong() {
        return (long)this.addr & 0xFFFFFFFFL;
    }

    public int getMask() {
        return this.mask;
    }

    public final long toLong() {
        return ((long)this.addr & 0xFFFFFFFFL) + ((long)this.mask << 32);
    }

    public static final InetCidr fromLong(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("l must not be negative: " + l);
        }
        long ip = l & 0xFFFFFFFFL;
        long mask = l >> 32;
        return new InetCidr(Util.long2InetAddress(ip), (int)mask);
    }

    public int hashCode() {
        return this.addr ^ this.mask;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InetCidr)) {
            return false;
        }
        InetCidr cidr = (InetCidr)obj;
        return this.addr == cidr.addr && this.mask == cidr.mask;
    }

    public static InetCidr[] addr2Cidr(InetAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("addr must not be null");
        }
        if (!(addr instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 addresses supported");
        }
        int addrInt = Util.inetAddress2Int(addr);
        InetCidr[] cidrs = new InetCidr[32];
        for (int i = cidrs.length; i >= 1; --i) {
            cidrs[32 - i] = new InetCidr(Util.int2InetAddress(addrInt & (int)gCidrMask[i]), i);
        }
        return cidrs;
    }

    @Override
    public int compareTo(InetCidr o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.equals(o)) {
            return 0;
        }
        if (InetCidr.int2UnsignedLong(this.addr) < InetCidr.int2UnsignedLong(o.addr)) {
            return -1;
        }
        if (InetCidr.int2UnsignedLong(this.addr) > InetCidr.int2UnsignedLong(o.addr)) {
            return 1;
        }
        if (this.mask < o.mask) {
            return -1;
        }
        if (this.mask > o.mask) {
            return 1;
        }
        return 0;
    }

    private static final long int2UnsignedLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static boolean isSorted(List<InetCidr> list) {
        if (list == null) {
            return true;
        }
        InetCidr pivot = null;
        for (InetCidr cidr : list) {
            if (cidr == null) {
                throw new NullPointerException();
            }
            if (pivot == null) {
                pivot = cidr;
                continue;
            }
            if (pivot.compareTo(cidr) >= 0) {
                return false;
            }
            pivot = cidr;
        }
        return true;
    }

    public static void checkNoOverlap(List<InetCidr> list) {
        if (list == null) {
            return;
        }
        assert (InetCidr.isSorted(list));
        InetCidr prev = null;
        long pivotEnd = -1L;
        for (InetCidr cidr : list) {
            if (cidr == null) {
                throw new NullPointerException();
            }
            if (prev != null && cidr.getAddrLong() <= pivotEnd) {
                throw new IllegalStateException("Overlapping cidr: " + prev + ", " + cidr);
            }
            pivotEnd = cidr.getAddrLong() + (gCidrMask[cidr.getMask()] ^ 0xFFFFFFFFL);
            prev = cidr;
        }
    }

    static {
        try {
            InetCidr.gCidrMask[0] = 0L;
            for (int i = 0; i < CIDR_MASKS.length; ++i) {
                InetAddress mask = InetAddress.getByName(CIDR_MASKS[i]);
                InetCidr.gCidrMask[i + 1] = Util.inetAddress2Long(mask);
                gCidr.put(mask, i + 1);
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unable to initialize CIDR");
        }
    }
}

