/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.util.ConfigurationUtils;
import org.jitsi.service.resources.ResourceManagementService;

public class FontChooser
extends JComponent
implements ActionListener,
ListSelectionListener {
    private InputList fontFamilyPanel;
    private InputList fontSizePanel;
    private JCheckBox boldCheckBox;
    private JCheckBox italicCheckBox;
    private JCheckBox underlineCheckBox;
    private ColorLabel colorLabel;
    private JLabel previewLabel;
    private String[] fontFamilies;
    private final String[] fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private static final String previewText = "Preview Text";
    private static final String ACTCMD_CHOOSE_COLOR = "ACTCMD_CHOOSE_COLOR";
    public static final int OK_OPTION = 1;
    public static final int CANCEL_OPTION = 0;
    protected int option = 0;

    public FontChooser() {
        ResourceManagementService res = GuiActivator.getResources();
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fontFamilies = ge.getAvailableFontFamilyNames();
        this.fontFamilyPanel = new InputList(res.getI18NString("service.gui.FONT_FAMILY"), this.fontFamilies);
        this.fontFamilyPanel.addListSelectionListener(this);
        this.fontSizePanel = new InputList(res.getI18NString("service.gui.FONT_SIZE"), this.fontSizes);
        this.fontSizePanel.addListSelectionListener(this);
        JPanel listsPanels = new JPanel(new GridLayout(1, 2, 5, 5));
        listsPanels.add((Component)this.fontFamilyPanel, "West");
        listsPanels.add((Component)this.fontSizePanel, "East");
        JLabel styleLabel = new JLabel(res.getI18NString("service.gui.FONT_STYLE"));
        styleLabel.setPreferredSize(new Dimension(100, 0));
        styleLabel.setFont(styleLabel.getFont().deriveFont(1));
        this.boldCheckBox = new SIPCommCheckBox(res.getI18NString("service.gui.FONT_BOLD"));
        this.boldCheckBox.addActionListener(this);
        this.boldCheckBox.setOpaque(false);
        this.italicCheckBox = new SIPCommCheckBox(res.getI18NString("service.gui.FONT_ITALIC"));
        this.italicCheckBox.addActionListener(this);
        this.underlineCheckBox = new SIPCommCheckBox(res.getI18NString("service.gui.FONT_UNDERLINE"));
        this.underlineCheckBox.addActionListener(this);
        JPanel styleGridPanel = new JPanel(new GridLayout(1, 3, 5, 5));
        styleGridPanel.add(this.boldCheckBox);
        styleGridPanel.add(this.italicCheckBox);
        styleGridPanel.add(this.underlineCheckBox);
        JPanel stylePanel = new JPanel(new BorderLayout(10, 10));
        stylePanel.add((Component)styleLabel, "West");
        stylePanel.add((Component)styleGridPanel, "Center");
        JLabel colorTextLabel = new JLabel(res.getI18NString("service.gui.FONT_COLOR"));
        colorTextLabel.setPreferredSize(new Dimension(100, 0));
        colorTextLabel.setFont(styleLabel.getFont().deriveFont(1));
        this.colorLabel = new ColorLabel();
        this.colorLabel.setOpaque(true);
        this.colorLabel.setBackground(Color.BLACK);
        this.colorLabel.setPreferredSize(new Dimension(18, 18));
        JButton colorButton = new JButton(res.getI18NString("service.gui.SELECT_COLOR"));
        colorButton.addActionListener(this);
        colorButton.setName(ACTCMD_CHOOSE_COLOR);
        JPanel colorPanelCenter = new JPanel(new FlowLayout(0));
        colorPanelCenter.add(this.colorLabel);
        colorPanelCenter.add(colorButton);
        JPanel colorPanel = new JPanel(new BorderLayout());
        colorPanel.add((Component)colorTextLabel, "West");
        colorPanel.add((Component)colorPanelCenter, "Center");
        JPanel formatPanel = new JPanel();
        formatPanel.setLayout(new BoxLayout(formatPanel, 1));
        formatPanel.add(listsPanels);
        formatPanel.add(stylePanel);
        formatPanel.add(colorPanel);
        this.add((Component)formatPanel, "North");
        this.previewLabel = new JLabel(previewText, 0);
        this.previewLabel.setOpaque(true);
        this.previewLabel.setBackground(Color.WHITE);
        this.previewLabel.setPreferredSize(new Dimension(0, 100));
        this.previewLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.add((Component)this.previewLabel, "Center");
        this.initDefaults();
    }

    private void initDefaults() {
        String defaultFontFamily = ConfigurationUtils.getChatDefaultFontFamily();
        int defaultFontSize = ConfigurationUtils.getChatDefaultFontSize();
        Color defaultFontColor = ConfigurationUtils.getChatDefaultFontColor();
        if (defaultFontFamily != null) {
            this.setFontFamily(defaultFontFamily);
        }
        if (defaultFontSize > 0) {
            this.setFontSize(defaultFontSize);
        }
        this.setBoldStyle(ConfigurationUtils.isChatFontBold());
        this.setItalicStyle(ConfigurationUtils.isChatFontItalic());
        this.setUnderlineStyle(ConfigurationUtils.isChatFontUnderline());
        if (defaultFontColor != null) {
            this.setColor(defaultFontColor);
        }
    }

    private void updatePreview() {
        Font f = new Font(this.fontFamilyPanel.getSelected(), 0, this.fontSizePanel.getSelectedInt());
        String text = this.fontFamilyPanel.getSelected();
        if (this.boldCheckBox.isSelected()) {
            text = "<b>" + text + "</b>";
        }
        if (this.italicCheckBox.isSelected()) {
            text = "<i>" + text + "</i>";
        }
        if (this.underlineCheckBox.isSelected()) {
            text = "<u>" + text + "</u>";
        }
        this.previewLabel.setFont(f);
        this.previewLabel.setForeground(this.colorLabel.getBackground());
        this.previewLabel.setText("<html>" + text + "</html>");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source;
        String name;
        if (e.getSource() instanceof JButton && (name = (source = (JButton)e.getSource()).getName()).equals(ACTCMD_CHOOSE_COLOR)) {
            Color c = JColorChooser.showDialog(this, "Color Chooser", this.colorLabel.getBackground());
            this.colorLabel.setBackground(c);
        }
        this.updatePreview();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updatePreview();
    }

    public void setFontFamily(String family) {
        if (family.endsWith(".plain")) {
            family = family.replace(".plain", "");
        }
        String[] stringArray = this.fontFamilies;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String f;
            String oldF = f = stringArray[i];
            if (!family.equals(f) && !family.equals(f.replaceAll(" ", ""))) continue;
            this.fontFamilyPanel.setSelected(oldF);
        }
        this.updatePreview();
    }

    public void setFontSize(int size) {
        this.fontSizePanel.setSelectedInt(size);
        this.updatePreview();
    }

    public void setBoldStyle(boolean b) {
        this.boldCheckBox.setSelected(b);
        this.updatePreview();
    }

    public void setItalicStyle(boolean b) {
        this.italicCheckBox.setSelected(b);
        this.updatePreview();
    }

    public void setUnderlineStyle(boolean b) {
        this.underlineCheckBox.setSelected(b);
        this.updatePreview();
    }

    public void setColor(Color c) {
        this.colorLabel.setBackground(c);
        this.updatePreview();
    }

    public String getFontFamily() {
        return this.fontFamilyPanel.getSelected();
    }

    public int getFontSize() {
        return this.fontSizePanel.getSelectedInt();
    }

    public boolean isBoldStyleSelected() {
        return this.boldCheckBox.isSelected();
    }

    public boolean isItalicStyleSelected() {
        return this.italicCheckBox.isSelected();
    }

    public boolean isUnderlineStyleSelected() {
        return this.underlineCheckBox.isSelected();
    }

    public Color getFontColor() {
        return this.colorLabel.getBackground();
    }

    public int showDialog(Component parent) {
        SIPCommDialog dialog = this.createDialog(parent);
        dialog.setVisible(true);
        dialog.dispose();
        dialog = null;
        return this.option;
    }

    private SIPCommDialog createDialog(Component parent) {
        final SIPCommDialog d = new SIPCommDialog();
        ResourceManagementService res = GuiActivator.getResources();
        d.setTitle(res.getI18NString("service.gui.FONT"));
        d.setModal(true);
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.option = 1;
                d.setVisible(false);
            }
        });
        buttonsPanel.add(okButton);
        JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.option = 0;
                d.setVisible(false);
            }
        });
        buttonsPanel.add(cancelButton);
        d.getContentPane().setLayout(new BorderLayout());
        d.getContentPane().add((Component)this, "Center");
        d.getContentPane().add((Component)buttonsPanel, "South");
        d.pack();
        d.setResizable(false);
        d.setLocationRelativeTo(parent);
        return d;
    }

    private class InputList
    extends JPanel
    implements KeyListener,
    ListSelectionListener {
        private JLabel label = new JLabel();
        private JTextField textField = new JTextField();
        private JList list;

        public InputList(String title, Object[] data) {
            this.setLayout(new BorderLayout());
            this.label.setText(title);
            this.label.setFont(this.label.getFont().deriveFont(1));
            this.add((Component)this.label, "North");
            JPanel middlePanel = new JPanel(new BorderLayout());
            this.textField.addKeyListener(this);
            middlePanel.add((Component)this.textField, "North");
            this.list = new JList<Object>(data);
            this.list.setSelectionMode(0);
            this.list.setVisibleRowCount(5);
            this.list.setSelectedIndex(0);
            this.list.addListSelectionListener(this);
            this.setFocusable(false);
            middlePanel.add((Component)new JScrollPane(this.list), "Center");
            this.add((Component)middlePanel, "Center");
        }

        public void setSelected(String value) {
            ListModel l = this.list.getModel();
            boolean inList = false;
            for (int i = 0; i < l.getSize() && !inList; ++i) {
                if (!l.getElementAt(i).toString().equals(value)) continue;
                inList = true;
            }
            if (inList) {
                this.list.setSelectedValue(value, true);
            } else {
                this.list.clearSelection();
            }
            this.textField.setText(value);
        }

        public String getSelected() {
            return this.textField.getText();
        }

        public void setSelectedInt(int value) {
            this.setSelected(Integer.toString(value));
        }

        public int getSelectedInt() {
            try {
                return Integer.parseInt(this.getSelected());
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        public void addListSelectionListener(ListSelectionListener l) {
            this.list.addListSelectionListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String selectedValue = (String)this.list.getSelectedValue();
            String oldValue = this.textField.getText();
            this.textField.setText(selectedValue);
            if (!oldValue.equalsIgnoreCase(selectedValue)) {
                this.textField.selectAll();
                this.textField.requestFocus();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                return;
            }
            String key = this.textField.getText().toLowerCase();
            ListModel model = this.list.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                String elem = model.getElementAt(i).toString();
                if (!elem.toLowerCase().startsWith(key)) continue;
                this.list.setSelectedValue(model.getElementAt(i), true);
                break;
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int i = this.list.getSelectedIndex();
            if (e.getKeyCode() == 38 && i > 0) {
                this.list.setSelectedIndex(i - 1);
            } else if (e.getKeyCode() == 40 && i < this.list.getModel().getSize() - 1) {
                this.list.setSelectedIndex(i + 1);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private static class ColorLabel
    extends JLabel {
        private ColorLabel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            g = g.create();
            try {
                AntialiasingManager.activateAntialiasing((Graphics)g);
                g.setColor(this.getBackground());
                g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 8, 8);
            }
            finally {
                g.dispose();
            }
        }
    }
}

