/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import javax.swing.ImageIcon;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;

public abstract class ChatContact<T> {
    public static final int AVATAR_ICON_HEIGHT = 25;
    public static final int AVATAR_ICON_WIDTH = 25;
    private ImageIcon avatar;
    private byte[] avatarBytes;
    protected final T descriptor;
    private boolean selected;

    protected ChatContact(T descriptor) {
        this.descriptor = descriptor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        ChatContact chatContact = (ChatContact)obj;
        return this.getDescriptor().equals(chatContact.getDescriptor());
    }

    public ImageIcon getAvatar() {
        byte[] avatarBytes = this.getAvatarBytes();
        if (this.avatarBytes != avatarBytes) {
            this.avatarBytes = avatarBytes;
            this.avatar = null;
        }
        if (this.avatar == null && this.avatarBytes != null && this.avatarBytes.length > 0) {
            this.avatar = ImageUtils.getScaledRoundedIcon((byte[])this.avatarBytes, (int)25, (int)25);
        }
        return this.avatar;
    }

    protected abstract byte[] getAvatarBytes();

    public T getDescriptor() {
        return this.descriptor;
    }

    public abstract String getName();

    public abstract String getUID();

    public int hashCode() {
        return this.getDescriptor().hashCode();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

