/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.ProtocolContactSourceServiceImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.StringContactSourceServiceImpl;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.impl.gui.utils.InviteDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.DemuxContactSourceService;
import net.java.sip.communicator.service.contactsource.ProtocolAwareContactSourceService;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIContactSource;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;

public class ConferenceInviteDialog
extends InviteDialog {
    private static final long serialVersionUID = 0L;
    private final JComboBox accountSelectorBox = new JComboBox();
    private Object lastSelectedAccount;
    private final CallConference conference;
    private ContactSourceService currentProviderContactSource;
    private ContactSourceService currentStringContactSource;
    private ProtocolProviderService preselectedProtocolProvider;
    private final boolean isJitsiVideobridge;

    public ConferenceInviteDialog(CallConference conference, ProtocolProviderService preselectedProvider, List<ProtocolProviderService> protocolProviders, final boolean isJitsiVideobridge) {
        super(isJitsiVideobridge ? GuiActivator.getResources().getI18NString("service.gui.INVITE_CONTACT_TO_VIDEO_BRIDGE") : GuiActivator.getResources().getI18NString("service.gui.INVITE_CONTACT_TO_CALL"), false);
        this.conference = conference;
        this.preselectedProtocolProvider = preselectedProvider;
        this.isJitsiVideobridge = isJitsiVideobridge;
        if (this.preselectedProtocolProvider == null) {
            this.initAccountSelectorPanel(protocolProviders);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConferenceInviteDialog.this.initContactSources();
                if (ConferenceInviteDialog.this.preselectedProtocolProvider != null) {
                    ConferenceInviteDialog.this.initContactListData(ConferenceInviteDialog.this.preselectedProtocolProvider);
                } else {
                    ConferenceInviteDialog.this.initContactListData((ProtocolProviderService)ConferenceInviteDialog.this.accountSelectorBox.getSelectedItem());
                }
            }
        });
        this.addInviteButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Collection selectedContacts = ConferenceInviteDialog.this.destContactList.getContacts(null);
                if (selectedContacts != null && selectedContacts.size() > 0) {
                    if (ConferenceInviteDialog.this.preselectedProtocolProvider == null) {
                        ConferenceInviteDialog.this.preselectedProtocolProvider = (ProtocolProviderService)ConferenceInviteDialog.this.accountSelectorBox.getSelectedItem();
                    }
                    if (isJitsiVideobridge) {
                        ConferenceInviteDialog.this.inviteJitsiVideobridgeContacts(ConferenceInviteDialog.this.preselectedProtocolProvider, selectedContacts);
                    } else {
                        ConferenceInviteDialog.this.inviteContacts(selectedContacts);
                    }
                    ConfigurationUtils.setLastCallConferenceProvider((ProtocolProviderService)ConferenceInviteDialog.this.preselectedProtocolProvider);
                    ConferenceInviteDialog.this.dispose();
                }
            }
        });
        this.addCancelButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenceInviteDialog.this.dispose();
            }
        });
    }

    public ConferenceInviteDialog() {
        this(null, null, null, false);
    }

    public ConferenceInviteDialog(CallConference conference) {
        this(conference, null, null, false);
    }

    public ConferenceInviteDialog(CallConference conference, ProtocolProviderService preselectedProtocolProvider, boolean isJitsiVideobridge) {
        this(conference, preselectedProtocolProvider, null, isJitsiVideobridge);
    }

    public ConferenceInviteDialog(List<ProtocolProviderService> protocolProviders, boolean isJitsiVideobridge) {
        this(null, null, protocolProviders, isJitsiVideobridge);
    }

    public ConferenceInviteDialog(ProtocolProviderService selectedConfProvider, boolean isJitsiVideobridge) {
        this(null, selectedConfProvider, null, isJitsiVideobridge);
    }

    private void initAccountSelectorPanel(List<ProtocolProviderService> protocolProviders) {
        JLabel accountSelectorLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.CALL_VIA"));
        TransparentPanel accountSelectorPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        accountSelectorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        accountSelectorPanel.add((Component)accountSelectorLabel, (Object)"West");
        accountSelectorPanel.add((Component)this.accountSelectorBox, (Object)"Center");
        if (protocolProviders != null && protocolProviders.size() > 0) {
            this.initAccountListData(protocolProviders);
        } else {
            this.initAccountListData();
        }
        this.accountSelectorBox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ProtocolProviderService protocolProvider = (ProtocolProviderService)value;
                if (protocolProvider != null) {
                    this.setText(protocolProvider.getAccountID().getDisplayName());
                    this.setIcon(ImageLoader.getAccountStatusImage(protocolProvider));
                }
                return this;
            }
        });
        this.accountSelectorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object accountSelectorBoxSelectedItem = ConferenceInviteDialog.this.accountSelectorBox.getSelectedItem();
                if (ConferenceInviteDialog.this.lastSelectedAccount == null || !ConferenceInviteDialog.this.lastSelectedAccount.equals(accountSelectorBoxSelectedItem)) {
                    ConferenceInviteDialog.this.lastSelectedAccount = accountSelectorBoxSelectedItem;
                    ConferenceInviteDialog.this.initContactListData((ProtocolProviderService)ConferenceInviteDialog.this.accountSelectorBox.getSelectedItem());
                    if (ConferenceInviteDialog.this.isJitsiVideobridge) {
                        ConferenceInviteDialog.this.destContactList.removeAll();
                    }
                }
            }
        });
        this.getContentPane().add((Component)accountSelectorPanel, "North");
    }

    private void initAccountListData(List<ProtocolProviderService> protocolProviders) {
        for (ProtocolProviderService protocolProvider : protocolProviders) {
            this.accountSelectorBox.addItem(protocolProvider);
        }
        if (this.accountSelectorBox.getItemCount() > 0) {
            this.accountSelectorBox.setSelectedIndex(0);
        }
    }

    private void initAccountListData() {
        Iterator<ProtocolProviderService> protocolProviders = GuiActivator.getUIService().getMainFrame().getProtocolProviders();
        while (protocolProviders.hasNext()) {
            ProtocolProviderService protocolProvider = protocolProviders.next();
            OperationSet opSet = protocolProvider.getOperationSet(OperationSetTelephonyConferencing.class);
            if (opSet == null || !protocolProvider.isRegistered()) continue;
            this.accountSelectorBox.addItem(protocolProvider);
        }
        ProtocolProviderService pps = ConfigurationUtils.getLastCallConferenceProvider();
        if (pps == null && this.conference != null) {
            for (Call call : this.conference.getCalls()) {
                ProtocolProviderService callPps = call.getProtocolProvider();
                if (callPps.getOperationSet(OperationSetTelephonyConferencing.class) == null) continue;
                pps = callPps;
                break;
            }
        }
        if (pps != null) {
            this.accountSelectorBox.setSelectedItem(pps);
        } else if (this.accountSelectorBox.getItemCount() > 0) {
            this.accountSelectorBox.setSelectedIndex(0);
        }
    }

    private void initContactSources() {
        DemuxContactSourceService demuxCSService = GuiActivator.getDemuxContactSourceService();
        if (demuxCSService == null) {
            return;
        }
        Iterator sourcesIter = new ArrayList(this.srcContactList.getContactSources()).iterator();
        this.srcContactList.removeAllContactSources();
        while (sourcesIter.hasNext()) {
            ContactSourceService contactSource = ((UIContactSource)sourcesIter.next()).getContactSourceService();
            this.srcContactList.addContactSource(demuxCSService.createDemuxContactSource(contactSource));
        }
    }

    private void initContactListData(ProtocolProviderService protocolProvider) {
        this.setCurrentProvider(protocolProvider);
        Iterator sourcesIter = new ArrayList(this.srcContactList.getContactSources()).iterator();
        while (sourcesIter.hasNext()) {
            ContactSourceService contactSource = ((UIContactSource)sourcesIter.next()).getContactSourceService();
            if (!(contactSource instanceof ProtocolAwareContactSourceService)) continue;
            ((ProtocolAwareContactSourceService)contactSource).setPreferredProtocolProvider(OperationSetBasicTelephony.class, protocolProvider);
        }
        this.srcContactList.removeContactSource(this.currentProviderContactSource);
        this.srcContactList.removeContactSource(this.currentStringContactSource);
        this.currentProviderContactSource = new ProtocolContactSourceServiceImpl(protocolProvider, OperationSetBasicTelephony.class);
        this.currentStringContactSource = new StringContactSourceServiceImpl(protocolProvider, OperationSetBasicTelephony.class);
        this.srcContactList.addContactSource(this.currentProviderContactSource);
        this.srcContactList.addContactSource(this.currentStringContactSource);
        this.srcContactList.applyDefaultFilter();
    }

    private void inviteContacts(Collection<UIContact> contacts) {
        HashMap<ProtocolProviderService, List<String>> selectedProviderCallees = new HashMap<ProtocolProviderService, List<String>>();
        for (UIContact uiContact : contacts) {
            Iterator contactDetailsIter = uiContact.getContactDetailsForOperationSet(OperationSetBasicTelephony.class).iterator();
            if (!contactDetailsIter.hasNext()) continue;
            UIContactDetail inviteDetail = (UIContactDetail)contactDetailsIter.next();
            ProtocolProviderService selectedProvider = inviteDetail.getPreferredProtocolProvider(OperationSetBasicTelephony.class);
            if (selectedProvider == null) {
                selectedProvider = (ProtocolProviderService)this.accountSelectorBox.getSelectedItem();
            }
            List<String> callees = selectedProvider != null && selectedProviderCallees.get(selectedProvider) != null ? (List)selectedProviderCallees.get(selectedProvider) : new ArrayList<String>();
            callees.add(inviteDetail.getAddress());
            selectedProviderCallees.put(selectedProvider, callees);
        }
        if (this.conference != null) {
            CallManager.inviteToConferenceCall(selectedProviderCallees, this.conference);
        } else {
            CallManager.createConferenceCall(selectedProviderCallees);
        }
    }

    private void inviteJitsiVideobridgeContacts(ProtocolProviderService preselectedProvider, Collection<UIContact> contacts) {
        ArrayList<String> callees = new ArrayList<String>();
        for (UIContact uiContact : contacts) {
            Iterator contactDetailsIter = uiContact.getContactDetailsForOperationSet(OperationSetBasicTelephony.class).iterator();
            if (!contactDetailsIter.hasNext()) continue;
            UIContactDetail inviteDetail = (UIContactDetail)contactDetailsIter.next();
            callees.add(inviteDetail.getAddress());
        }
        if (this.conference != null) {
            CallManager.inviteToJitsiVideobridgeConfCall(callees.toArray(new String[callees.size()]), (Call)this.conference.getCalls().get(0));
        } else {
            CallManager.createJitsiVideobridgeConfCall(preselectedProvider, callees.toArray(new String[callees.size()]));
        }
    }
}

