/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.lookandfeel;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommBorders;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommComboBoxUI;

public class SIPCommCallComboBoxUI
extends SIPCommComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new SIPCommCallComboBoxUI();
    }

    @Override
    protected ComboPopup createPopup() {
        SIPCommComboPopup popup = new SIPCommComboPopup(this.comboBox);
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return popup;
    }

    @Override
    protected void installComponents() {
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = 0;
        if (this.arrowButton != null) {
            buttonSize = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    private static class SIPCommComboPopup
    extends BasicComboPopup {
        private static final long serialVersionUID = 0L;

        public SIPCommComboPopup(JComboBox combo) {
            super(combo);
        }

        @Override
        protected void togglePopup() {
            if (this.isVisible()) {
                this.hide();
            } else {
                this.setListSelection(this.comboBox.getSelectedIndex());
                Point location = this.getPopupLocation();
                this.show(this.comboBox, location.x, location.y);
            }
        }

        @Override
        protected void configurePopup() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorderPainted(true);
            this.setBorder(SIPCommBorders.getTextFieldBorder());
            this.setOpaque(false);
            this.add(this.scroller);
            this.setDoubleBuffered(true);
            this.setFocusable(false);
        }

        private void setListSelection(int selectedIndex) {
            if (selectedIndex == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(selectedIndex);
                this.list.ensureIndexIsVisible(selectedIndex);
            }
        }

        private Point getPopupLocation() {
            Dimension popupSize = this.comboBox.getSize();
            Insets insets = this.getInsets();
            int popupHeight = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
            popupSize.setSize(popupSize.width - (insets.right + insets.left), popupHeight);
            Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getEditor().getEditorComponent().getBounds().y - popupHeight - 4, popupSize.width, popupSize.height);
            Dimension scrollSize = popupBounds.getSize();
            Point popupLocation = popupBounds.getLocation();
            this.scroller.setMaximumSize(scrollSize);
            this.scroller.setPreferredSize(scrollSize);
            this.scroller.setMinimumSize(scrollSize);
            this.list.revalidate();
            return popupLocation;
        }
    }
}

