/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.painter;

import com.explodingpixels.painter.Painter;
import java.awt.Component;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonStatePainter<B extends AbstractButton>
implements Painter<B> {
    private final Painter<Component> fDefaultPainter;
    private final Painter<Component> fRolloverPainter;
    private final Painter<Component> fPressedPainter;
    private final Painter<Component> fSelectedPainter;

    public ButtonStatePainter(Painter<Component> defaultPainter) {
        this(defaultPainter, defaultPainter, defaultPainter, defaultPainter);
    }

    public ButtonStatePainter(Painter<Component> defaultPainter, Painter<Component> rolloverPainter, Painter<Component> pressedPainter, Painter<Component> selectedPainter) {
        this.fDefaultPainter = defaultPainter;
        this.fRolloverPainter = rolloverPainter;
        this.fPressedPainter = pressedPainter;
        this.fSelectedPainter = selectedPainter;
    }

    @Override
    public void paint(Graphics2D g, B button, int width, int height) {
        if (((AbstractButton)button).getModel().isRollover()) {
            this.fRolloverPainter.paint(g, (Component)button, width, height);
        } else if (((AbstractButton)button).getModel().isPressed()) {
            this.fPressedPainter.paint(g, (Component)button, width, height);
        } else if (((AbstractButton)button).getModel().isSelected()) {
            this.fSelectedPainter.paint(g, (Component)button, width, height);
        } else {
            this.fDefaultPainter.paint(g, (Component)button, width, height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyPainter
    implements Painter<Component> {
        @Override
        public void paint(Graphics2D g, Component component, int width, int height) {
        }
    }
}

