/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr.authdialog;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManagerListener;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class KnownFingerprintsTableModel
extends AbstractTableModel
implements ScOtrKeyManagerListener {
    private static final long serialVersionUID = 0L;
    public static final int CONTACTNAME_INDEX = 0;
    public static final int VERIFIED_INDEX = 1;
    public static final int FINGERPRINT_INDEX = 2;
    public final LinkedHashMap<Contact, List<String>> allContactsFingerprints = new LinkedHashMap();

    public KnownFingerprintsTableModel() {
        ServiceReference[] protocolProviderRefs = null;
        try {
            protocolProviderRefs = OtrActivator.bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            return;
        }
        if (protocolProviderRefs == null || protocolProviderRefs.length < 1) {
            return;
        }
        for (int i = 0; i < protocolProviderRefs.length; ++i) {
            ProtocolProviderService provider = (ProtocolProviderService)OtrActivator.bundleContext.getService(protocolProviderRefs[i]);
            Iterator metaContacts = OtrActivator.getContactListService().findAllMetaContactsForProvider(provider);
            while (metaContacts.hasNext()) {
                MetaContact metaContact = (MetaContact)metaContacts.next();
                Iterator contacts = metaContact.getContacts();
                while (contacts.hasNext()) {
                    Contact contact = (Contact)contacts.next();
                    this.allContactsFingerprints.put(contact, OtrActivator.scOtrKeyManager.getAllRemoteFingerprints(contact));
                }
            }
        }
        OtrActivator.scOtrKeyManager.addListener(this);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return OtrActivator.resourceService.getI18NString("plugin.otr.configform.COLUMN_NAME_CONTACT");
            }
            case 1: {
                return OtrActivator.resourceService.getI18NString("plugin.otr.configform.COLUMN_NAME_VERIFIED_STATUS");
            }
            case 2: {
                return OtrActivator.resourceService.getI18NString("plugin.otr.configform.FINGERPRINT");
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Contact contact = this.getContactFromRow(row);
        String fingerprint = this.getFingerprintFromRow(row);
        switch (column) {
            case 0: {
                return contact.getDisplayName();
            }
            case 1: {
                return OtrActivator.scOtrKeyManager.isVerified(contact, fingerprint) ? OtrActivator.resourceService.getI18NString("plugin.otr.configform.COLUMN_VALUE_VERIFIED_TRUE") : OtrActivator.resourceService.getI18NString("plugin.otr.configform.COLUMN_VALUE_VERIFIED_FALSE");
            }
            case 2: {
                return fingerprint;
            }
        }
        return null;
    }

    Contact getContactFromRow(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        int index = -1;
        Contact contact = null;
        for (Map.Entry<Contact, List<String>> entry : this.allContactsFingerprints.entrySet()) {
            boolean found = false;
            contact = entry.getKey();
            List<String> fingerprints = entry.getValue();
            for (String f : fingerprints) {
                if (++index != row) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        return contact;
    }

    String getFingerprintFromRow(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        int index = -1;
        String fingerprint = null;
        for (Map.Entry<Contact, List<String>> entry : this.allContactsFingerprints.entrySet()) {
            boolean found = false;
            List<String> fingerprints = entry.getValue();
            for (String f : fingerprints) {
                fingerprint = f;
                if (++index != row) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        return fingerprint;
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        for (Map.Entry<Contact, List<String>> entry : this.allContactsFingerprints.entrySet()) {
            rowCount += entry.getValue().size();
        }
        return rowCount;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public void contactVerificationStatusChanged(OtrContactManager.OtrContact otrContact) {
        Contact contact = otrContact.contact;
        this.allContactsFingerprints.put(contact, OtrActivator.scOtrKeyManager.getAllRemoteFingerprints(contact));
        this.fireTableDataChanged();
    }
}

