/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.packets;

import gnu.java.zrtp.utils.ZrtpUtils;

public class ZrtpPacketBase {
    private static byte[] zrtpId = new byte[2];
    public static final int ZRTP_WORD_SIZE = 4;
    public static final int ZID_SIZE = 12;
    public static final int CLIENT_ID_SIZE = 16;
    public static final int HASH_IMAGE_SIZE = 32;
    public static final int HVI_SIZE = 32;
    public static final int HMAC_SIZE = 8;
    public static final int CRC_SIZE = 4;
    protected static final int ZRTP_HEADER_LENGTH = 3;
    private static final int ID_OFFSET = 0;
    private static final int LENGTH_OFFSET = 2;
    private static final int TYPE_OFFSET = 4;
    private static final int TYPE_LENGTH = 8;
    protected byte[] packetBuffer = null;

    protected ZrtpPacketBase(byte[] pb) {
        this.packetBuffer = pb;
    }

    public final byte[] getHeaderBase() {
        return this.packetBuffer;
    }

    public final boolean isZrtpPacket() {
        return this.packetBuffer[0] == zrtpId[0] && this.packetBuffer[1] == zrtpId[1];
    }

    public final short getLength() {
        return ZrtpUtils.readShort(this.packetBuffer, 2);
    }

    public final String getMessageType() {
        return new String(this.packetBuffer, 4, 8);
    }

    protected final void setZrtpId() {
        System.arraycopy(zrtpId, 0, this.packetBuffer, 0, zrtpId.length);
    }

    protected final void setLength(int length) {
        ZrtpUtils.short16ToArrayInPlace(length, this.packetBuffer, 2);
    }

    public final void setMessageType(byte[] messageType) {
        System.arraycopy(messageType, 0, this.packetBuffer, 4, 8);
    }

    static {
        ZrtpPacketBase.zrtpId[0] = 80;
        ZrtpPacketBase.zrtpId[1] = 90;
    }
}

