/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetUtilities2;
import org.jvnet.lafwidget.Resettable;
import org.jvnet.lafwidget.tabbed.TabPagerManager;
import org.jvnet.lafwidget.tabbed.TabPagerMouseWheelListener;
import org.jvnet.lafwidget.tabbed.TabPreviewPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabPagerWidget
extends LafWidgetAdapter<JTabbedPane>
implements Resettable {
    protected MouseWheelListener mouseWheelListener;
    protected MouseListener mouseListener;

    @Override
    public void installUI() {
        super.installUI();
        InputMap currMap = SwingUtilities.getUIInputMap(this.jcomp, 1);
        InputMap newMap = new InputMap();
        if (currMap != null) {
            KeyStroke[] kss = currMap.allKeys();
            for (int i = 0; i < kss.length; ++i) {
                KeyStroke stroke = kss[i];
                Object val = currMap.get(stroke);
                newMap.put(stroke, val);
            }
        }
        newMap.put(KeyStroke.getKeyStroke(39, 2), "tabSwitcherForward");
        newMap.put(KeyStroke.getKeyStroke(37, 2), "tabSwitcherBackward");
        newMap.put(KeyStroke.getKeyStroke(17, 0, true), "tabSwitcherClose");
        newMap.put(KeyStroke.getKeyStroke(27, 0), "tabSwitcherHide");
        ((JTabbedPane)this.jcomp).getActionMap().put("tabSwitcherForward", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TabPreviewPainter tpp = LafWidgetUtilities2.getTabPreviewPainter((JTabbedPane)TabPagerWidget.this.jcomp);
                if (tpp == null) {
                    return;
                }
                TabPagerManager te = TabPagerManager.getPager();
                te.page((JTabbedPane)TabPagerWidget.this.jcomp, true);
            }
        });
        ((JTabbedPane)this.jcomp).getActionMap().put("tabSwitcherBackward", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TabPreviewPainter tpp = LafWidgetUtilities2.getTabPreviewPainter((JTabbedPane)TabPagerWidget.this.jcomp);
                if (tpp == null) {
                    return;
                }
                TabPagerManager te = TabPagerManager.getPager();
                te.page((JTabbedPane)TabPagerWidget.this.jcomp, false);
            }
        });
        ((JTabbedPane)this.jcomp).getActionMap().put("tabSwitcherClose", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TabPreviewPainter tpp = LafWidgetUtilities2.getTabPreviewPainter((JTabbedPane)TabPagerWidget.this.jcomp);
                        if (tpp == null) {
                            return;
                        }
                        TabPagerManager te = TabPagerManager.getPager();
                        int index = te.hide();
                        if (index >= 0 && tpp.isSensitiveToEvents((JTabbedPane)TabPagerWidget.this.jcomp, index)) {
                            ((JTabbedPane)TabPagerWidget.this.jcomp).setSelectedIndex(index);
                        }
                    }
                });
            }
        });
        ((JTabbedPane)this.jcomp).getActionMap().put("tabSwitcherHide", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TabPagerManager te = TabPagerManager.getPager();
                if (te.isVisible()) {
                    te.hide();
                } else {
                    for (Container comp = ((JTabbedPane)TabPagerWidget.this.jcomp).getParent(); comp != null; comp = comp.getParent()) {
                        KeyStroke escapeKeyStroke;
                        JComponent jc;
                        ActionListener al;
                        if (!(comp instanceof JComponent) || (al = (jc = (JComponent)comp).getActionForKeyStroke(escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false))) == null) continue;
                        al.actionPerformed(e);
                        return;
                    }
                }
            }
        });
        SwingUtilities.replaceUIInputMap(this.jcomp, 1, newMap);
    }

    @Override
    public void uninstallUI() {
        super.uninstallUI();
    }

    @Override
    public void installListeners() {
        this.mouseWheelListener = new TabPagerMouseWheelListener((JTabbedPane)this.jcomp);
        ((JTabbedPane)this.jcomp).addMouseWheelListener(this.mouseWheelListener);
        this.mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 2) != 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TabPagerManager te = TabPagerManager.getPager();
                            int index = te.hide();
                            if (index >= 0) {
                                ((JTabbedPane)TabPagerWidget.this.jcomp).setSelectedIndex(index);
                            }
                        }
                    });
                }
            }
        };
        ((JTabbedPane)this.jcomp).addMouseListener(this.mouseListener);
    }

    @Override
    public void uninstallListeners() {
        ((JTabbedPane)this.jcomp).removeMouseWheelListener(this.mouseWheelListener);
        this.mouseWheelListener = null;
        ((JTabbedPane)this.jcomp).removeMouseListener(this.mouseListener);
        this.mouseListener = null;
    }

    @Override
    public boolean requiresCustomLafSupport() {
        return false;
    }

    @Override
    public void reset() {
        TabPagerManager.reset();
    }
}

