/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSShareData.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSFile.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ShareData convertDictionary<ShareData>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ShareData result;
    JSValue filesValue;
    if (isNullOrUndefined)
        filesValue = jsUndefined();
    else {
        filesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "files"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!filesValue.isUndefined()) {
        result.files = convert<IDLFrozenArray<IDLInterface<File>>>(lexicalGlobalObject, filesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue textValue;
    if (isNullOrUndefined)
        textValue = jsUndefined();
    else {
        textValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "text"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!textValue.isUndefined()) {
        result.text = convert<IDLUSVString>(lexicalGlobalObject, textValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue titleValue;
    if (isNullOrUndefined)
        titleValue = jsUndefined();
    else {
        titleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "title"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!titleValue.isUndefined()) {
        result.title = convert<IDLUSVString>(lexicalGlobalObject, titleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue urlValue;
    if (isNullOrUndefined)
        urlValue = jsUndefined();
    else {
        urlValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "url"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!urlValue.isUndefined()) {
        result.url = convert<IDLUSVString>(lexicalGlobalObject, urlValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
