/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPositionOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> PositionOptions convertDictionary<PositionOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PositionOptions result;
    JSValue enableHighAccuracyValue;
    if (isNullOrUndefined)
        enableHighAccuracyValue = jsUndefined();
    else {
        enableHighAccuracyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "enableHighAccuracy"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!enableHighAccuracyValue.isUndefined()) {
        result.enableHighAccuracy = convert<IDLBoolean>(lexicalGlobalObject, enableHighAccuracyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.enableHighAccuracy = false;
    JSValue maximumAgeValue;
    if (isNullOrUndefined)
        maximumAgeValue = jsUndefined();
    else {
        maximumAgeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maximumAge"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maximumAgeValue.isUndefined()) {
        result.maximumAge = convert<IDLClampAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, maximumAgeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.maximumAge = 0;
    JSValue timeoutValue;
    if (isNullOrUndefined)
        timeoutValue = jsUndefined();
    else {
        timeoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timeout"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timeoutValue.isUndefined()) {
        result.timeout = convert<IDLClampAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, timeoutValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.timeout = 0xFFFFFFFF;
    return result;
}

} // namespace WebCore
