/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSPannerOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDistanceModelType.h"
#include "JSPanningModelType.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> PannerOptions convertDictionary<PannerOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PannerOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountValue.isUndefined()) {
        result.channelCount = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountModeValue.isUndefined()) {
        result.channelCountMode = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        result.channelInterpretation = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue coneInnerAngleValue;
    if (isNullOrUndefined)
        coneInnerAngleValue = jsUndefined();
    else {
        coneInnerAngleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "coneInnerAngle"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!coneInnerAngleValue.isUndefined()) {
        result.coneInnerAngle = convert<IDLDouble>(lexicalGlobalObject, coneInnerAngleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.coneInnerAngle = 360;
    JSValue coneOuterAngleValue;
    if (isNullOrUndefined)
        coneOuterAngleValue = jsUndefined();
    else {
        coneOuterAngleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "coneOuterAngle"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!coneOuterAngleValue.isUndefined()) {
        result.coneOuterAngle = convert<IDLDouble>(lexicalGlobalObject, coneOuterAngleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.coneOuterAngle = 360;
    JSValue coneOuterGainValue;
    if (isNullOrUndefined)
        coneOuterGainValue = jsUndefined();
    else {
        coneOuterGainValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "coneOuterGain"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!coneOuterGainValue.isUndefined()) {
        result.coneOuterGain = convert<IDLDouble>(lexicalGlobalObject, coneOuterGainValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.coneOuterGain = 0;
    JSValue distanceModelValue;
    if (isNullOrUndefined)
        distanceModelValue = jsUndefined();
    else {
        distanceModelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "distanceModel"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!distanceModelValue.isUndefined()) {
        result.distanceModel = convert<IDLEnumeration<DistanceModelType>>(lexicalGlobalObject, distanceModelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.distanceModel = DistanceModelType::Inverse;
    JSValue maxDistanceValue;
    if (isNullOrUndefined)
        maxDistanceValue = jsUndefined();
    else {
        maxDistanceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxDistance"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxDistanceValue.isUndefined()) {
        result.maxDistance = convert<IDLDouble>(lexicalGlobalObject, maxDistanceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.maxDistance = 10000;
    JSValue orientationXValue;
    if (isNullOrUndefined)
        orientationXValue = jsUndefined();
    else {
        orientationXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "orientationX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!orientationXValue.isUndefined()) {
        result.orientationX = convert<IDLFloat>(lexicalGlobalObject, orientationXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.orientationX = 1;
    JSValue orientationYValue;
    if (isNullOrUndefined)
        orientationYValue = jsUndefined();
    else {
        orientationYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "orientationY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!orientationYValue.isUndefined()) {
        result.orientationY = convert<IDLFloat>(lexicalGlobalObject, orientationYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.orientationY = 0;
    JSValue orientationZValue;
    if (isNullOrUndefined)
        orientationZValue = jsUndefined();
    else {
        orientationZValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "orientationZ"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!orientationZValue.isUndefined()) {
        result.orientationZ = convert<IDLFloat>(lexicalGlobalObject, orientationZValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.orientationZ = 0;
    JSValue panningModelValue;
    if (isNullOrUndefined)
        panningModelValue = jsUndefined();
    else {
        panningModelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "panningModel"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!panningModelValue.isUndefined()) {
        result.panningModel = convert<IDLEnumeration<PanningModelType>>(lexicalGlobalObject, panningModelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.panningModel = PanningModelType::Equalpower;
    JSValue positionXValue;
    if (isNullOrUndefined)
        positionXValue = jsUndefined();
    else {
        positionXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "positionX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!positionXValue.isUndefined()) {
        result.positionX = convert<IDLFloat>(lexicalGlobalObject, positionXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.positionX = 0;
    JSValue positionYValue;
    if (isNullOrUndefined)
        positionYValue = jsUndefined();
    else {
        positionYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "positionY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!positionYValue.isUndefined()) {
        result.positionY = convert<IDLFloat>(lexicalGlobalObject, positionYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.positionY = 0;
    JSValue positionZValue;
    if (isNullOrUndefined)
        positionZValue = jsUndefined();
    else {
        positionZValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "positionZ"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!positionZValue.isUndefined()) {
        result.positionZ = convert<IDLFloat>(lexicalGlobalObject, positionZValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.positionZ = 0;
    JSValue refDistanceValue;
    if (isNullOrUndefined)
        refDistanceValue = jsUndefined();
    else {
        refDistanceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "refDistance"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!refDistanceValue.isUndefined()) {
        result.refDistance = convert<IDLDouble>(lexicalGlobalObject, refDistanceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.refDistance = 1;
    JSValue rolloffFactorValue;
    if (isNullOrUndefined)
        rolloffFactorValue = jsUndefined();
    else {
        rolloffFactorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rolloffFactor"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rolloffFactorValue.isUndefined()) {
        result.rolloffFactor = convert<IDLDouble>(lexicalGlobalObject, rolloffFactorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.rolloffFactor = 1;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
