/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaTrackSupportedConstraints.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

template<> MediaTrackSupportedConstraints convertDictionary<MediaTrackSupportedConstraints>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaTrackSupportedConstraints result;
    JSValue aspectRatioValue;
    if (isNullOrUndefined)
        aspectRatioValue = jsUndefined();
    else {
        aspectRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspectRatio"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aspectRatioValue.isUndefined()) {
        result.aspectRatio = convert<IDLBoolean>(lexicalGlobalObject, aspectRatioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.aspectRatio = true;
    JSValue deviceIdValue;
    if (isNullOrUndefined)
        deviceIdValue = jsUndefined();
    else {
        deviceIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deviceId"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deviceIdValue.isUndefined()) {
        result.deviceId = convert<IDLBoolean>(lexicalGlobalObject, deviceIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deviceId = true;
    JSValue displaySurfaceValue;
    if (isNullOrUndefined)
        displaySurfaceValue = jsUndefined();
    else {
        displaySurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displaySurface"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displaySurfaceValue.isUndefined()) {
        result.displaySurface = convert<IDLBoolean>(lexicalGlobalObject, displaySurfaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.displaySurface = true;
    JSValue echoCancellationValue;
    if (isNullOrUndefined)
        echoCancellationValue = jsUndefined();
    else {
        echoCancellationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoCancellation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!echoCancellationValue.isUndefined()) {
        result.echoCancellation = convert<IDLBoolean>(lexicalGlobalObject, echoCancellationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.echoCancellation = true;
    JSValue facingModeValue;
    if (isNullOrUndefined)
        facingModeValue = jsUndefined();
    else {
        facingModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "facingMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!facingModeValue.isUndefined()) {
        result.facingMode = convert<IDLBoolean>(lexicalGlobalObject, facingModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.facingMode = true;
    JSValue frameRateValue;
    if (isNullOrUndefined)
        frameRateValue = jsUndefined();
    else {
        frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameRateValue.isUndefined()) {
        result.frameRate = convert<IDLBoolean>(lexicalGlobalObject, frameRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.frameRate = true;
    JSValue groupIdValue;
    if (isNullOrUndefined)
        groupIdValue = jsUndefined();
    else {
        groupIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groupId"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!groupIdValue.isUndefined()) {
        result.groupId = convert<IDLBoolean>(lexicalGlobalObject, groupIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.groupId = true;
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLBoolean>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.height = true;
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLBoolean>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sampleRate = true;
    JSValue sampleSizeValue;
    if (isNullOrUndefined)
        sampleSizeValue = jsUndefined();
    else {
        sampleSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleSize"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleSizeValue.isUndefined()) {
        result.sampleSize = convert<IDLBoolean>(lexicalGlobalObject, sampleSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sampleSize = true;
    JSValue volumeValue;
    if (isNullOrUndefined)
        volumeValue = jsUndefined();
    else {
        volumeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "volume"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!volumeValue.isUndefined()) {
        result.volume = convert<IDLBoolean>(lexicalGlobalObject, volumeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.volume = true;
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLBoolean>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.width = true;
    JSValue zoomValue;
    if (isNullOrUndefined)
        zoomValue = jsUndefined();
    else {
        zoomValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "zoom"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!zoomValue.isUndefined()) {
        result.zoom = convert<IDLBoolean>(lexicalGlobalObject, zoomValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.zoom = true;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaTrackSupportedConstraints& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto aspectRatioValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.aspectRatio);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"_s), aspectRatioValue);
    auto deviceIdValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.deviceId);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"_s), deviceIdValue);
    auto displaySurfaceValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.displaySurface);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "displaySurface"_s), displaySurfaceValue);
    auto echoCancellationValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.echoCancellation);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"_s), echoCancellationValue);
    auto facingModeValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.facingMode);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"_s), facingModeValue);
    auto frameRateValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.frameRate);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"_s), frameRateValue);
    auto groupIdValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.groupId);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"_s), groupIdValue);
    auto heightValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.height);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    auto sampleRateValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.sampleRate);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"_s), sampleRateValue);
    auto sampleSizeValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.sampleSize);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"_s), sampleSizeValue);
    auto volumeValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.volume);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"_s), volumeValue);
    auto widthValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.width);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    auto zoomValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.zoom);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "zoom"_s), zoomValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(MEDIA_STREAM)
