/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLMediaElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "ElementInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "IDLTypes.h"
#include "JSAudioTrackList.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDate.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaController.h"
#include "JSMediaError.h"
#include "JSMediaSource.h"
#include "JSMediaStream.h"
#include "JSTextTrack.h"
#include "JSTextTrackList.h"
#include "JSTimeRanges.h"
#include "JSVideoPlaybackQuality.h"
#include "JSVideoTrackList.h"
#include "Quirks.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(ENCRYPTED_MEDIA)
#include "JSEventListener.h"
#include "JSMediaKeys.h"
#endif

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
#include "JSWebKitMediaKeys.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_load);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_canPlayType);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_getStartDate);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_play);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_pause);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_fastSeek);
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeys);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_setMediaKeys);
#endif
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_addTextTrack);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQuality);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPicker);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_setSinkId);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_error);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_src);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_src);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_srcObject);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_srcObject);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_currentSrc);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_crossOrigin);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_crossOrigin);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_networkState);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_preload);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_preload);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_buffered);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_readyState);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_seeking);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_currentTime);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_currentTime);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_duration);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_paused);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_defaultPlaybackRate);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_defaultPlaybackRate);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_playbackRate);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_playbackRate);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_played);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_seekable);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_ended);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_autoplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_autoplay);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_loop);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_loop);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_controls);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_controls);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_volume);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_volume);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_muted);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_muted);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_defaultMuted);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_defaultMuted);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitPreservesPitch);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_webkitPreservesPitch);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitHasClosedCaptions);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitClosedCaptionsVisible);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_webkitClosedCaptionsVisible);
#if ENABLE(MEDIA_STATISTICS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitAudioDecodedByteCount);
#endif
#if ENABLE(MEDIA_STATISTICS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitVideoDecodedByteCount);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitKeys);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_mediaKeys);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_onencrypted);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_onencrypted);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_onwaitingforkey);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_onwaitingforkey);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_audioTracks);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_textTracks);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_videoTracks);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_mediaGroup);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_mediaGroup);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_controller);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_controller);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWireless);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_sinkId);
#endif

class JSHTMLMediaElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLMediaElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLMediaElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLMediaElementPrototype>(vm)) JSHTMLMediaElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLMediaElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLMediaElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLMediaElementPrototype, JSHTMLMediaElementPrototype::Base);

using JSHTMLMediaElementDOMConstructor = JSDOMConstructorNotConstructable<JSHTMLMediaElement>;

/* Hash table for constructor */

static const HashTableValue JSHTMLMediaElementConstructorTableValues[] =
{
    { "NETWORK_EMPTY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "NETWORK_IDLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "NETWORK_LOADING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "NETWORK_NO_SOURCE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "HAVE_NOTHING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "HAVE_METADATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "HAVE_CURRENT_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "HAVE_FUTURE_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "HAVE_ENOUGH_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
};

static_assert(HTMLMediaElement::NETWORK_EMPTY == 0, "NETWORK_EMPTY in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::NETWORK_IDLE == 1, "NETWORK_IDLE in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::NETWORK_LOADING == 2, "NETWORK_LOADING in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::NETWORK_NO_SOURCE == 3, "NETWORK_NO_SOURCE in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_NOTHING == 0, "HAVE_NOTHING in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_METADATA == 1, "HAVE_METADATA in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_CURRENT_DATA == 2, "HAVE_CURRENT_DATA in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_FUTURE_DATA == 3, "HAVE_FUTURE_DATA in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_ENOUGH_DATA == 4, "HAVE_ENOUGH_DATA in HTMLMediaElement does not match value from IDL");

template<> const ClassInfo JSHTMLMediaElementDOMConstructor::s_info = { "HTMLMediaElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMediaElementDOMConstructor) };

template<> JSValue JSHTMLMediaElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLMediaElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLMediaElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLMediaElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSHTMLMediaElement::info(), JSHTMLMediaElementConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMediaElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElementConstructor, 0 } },
    { "error"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_error, 0 } },
    { "src"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_src, setJSHTMLMediaElement_src } },
    { "srcObject"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_srcObject, setJSHTMLMediaElement_srcObject } },
    { "currentSrc"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_currentSrc, 0 } },
    { "crossOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_crossOrigin, setJSHTMLMediaElement_crossOrigin } },
    { "networkState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_networkState, 0 } },
    { "preload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_preload, setJSHTMLMediaElement_preload } },
    { "buffered"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_buffered, 0 } },
    { "readyState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_readyState, 0 } },
    { "seeking"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_seeking, 0 } },
    { "currentTime"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_currentTime, setJSHTMLMediaElement_currentTime } },
    { "duration"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_duration, 0 } },
    { "paused"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_paused, 0 } },
    { "defaultPlaybackRate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_defaultPlaybackRate, setJSHTMLMediaElement_defaultPlaybackRate } },
    { "playbackRate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_playbackRate, setJSHTMLMediaElement_playbackRate } },
    { "played"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_played, 0 } },
    { "seekable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_seekable, 0 } },
    { "ended"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_ended, 0 } },
    { "autoplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_autoplay, setJSHTMLMediaElement_autoplay } },
    { "loop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_loop, setJSHTMLMediaElement_loop } },
    { "controls"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_controls, setJSHTMLMediaElement_controls } },
    { "volume"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_volume, setJSHTMLMediaElement_volume } },
    { "muted"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_muted, setJSHTMLMediaElement_muted } },
    { "defaultMuted"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_defaultMuted, setJSHTMLMediaElement_defaultMuted } },
    { "webkitPreservesPitch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitPreservesPitch, setJSHTMLMediaElement_webkitPreservesPitch } },
    { "webkitHasClosedCaptions"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitHasClosedCaptions, 0 } },
    { "webkitClosedCaptionsVisible"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitClosedCaptionsVisible, setJSHTMLMediaElement_webkitClosedCaptionsVisible } },
#if ENABLE(MEDIA_STATISTICS)
    { "webkitAudioDecodedByteCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitAudioDecodedByteCount, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    { "webkitVideoDecodedByteCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitVideoDecodedByteCount, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    { "webkitKeys"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitKeys, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "mediaKeys"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_mediaKeys, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "onencrypted"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_onencrypted, setJSHTMLMediaElement_onencrypted } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "onwaitingforkey"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_onwaitingforkey, setJSHTMLMediaElement_onwaitingforkey } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "audioTracks"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_audioTracks, 0 } },
    { "textTracks"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_textTracks, 0 } },
    { "videoTracks"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_videoTracks, 0 } },
    { "mediaGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_mediaGroup, setJSHTMLMediaElement_mediaGroup } },
    { "controller"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_controller, setJSHTMLMediaElement_controller } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "webkitCurrentPlaybackTargetIsWireless"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWireless, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
    { "sinkId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_sinkId, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "load"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_load, 0 } },
    { "canPlayType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_canPlayType, 1 } },
    { "getStartDate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_getStartDate, 0 } },
    { "play"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_play, 0 } },
    { "pause"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_pause, 0 } },
    { "fastSeek"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_fastSeek, 1 } },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    { "webkitSetMediaKeys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeys, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "setMediaKeys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_setMediaKeys, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "addTextTrack"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_addTextTrack, 1 } },
    { "getVideoPlaybackQuality"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQuality, 0 } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "webkitShowPlaybackTargetPicker"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPicker, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
    { "setSinkId"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_setSinkId, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "NETWORK_EMPTY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "NETWORK_IDLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "NETWORK_LOADING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "NETWORK_NO_SOURCE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "HAVE_NOTHING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "HAVE_METADATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "HAVE_CURRENT_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "HAVE_FUTURE_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "HAVE_ENOUGH_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
};

const ClassInfo JSHTMLMediaElementPrototype::s_info = { "HTMLMediaElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMediaElementPrototype) };

void JSHTMLMediaElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLMediaElement::info(), JSHTMLMediaElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().legacyEncryptedMediaAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitSetMediaKeys"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().encryptedMediaAPIEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setMediaKeys"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().wirelessPlaybackTargetAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitShowPlaybackTargetPicker"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().exposeSpeakersEnabled && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().perElementSpeakerSelectionEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setSinkId"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().legacyEncryptedMediaAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitKeys"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().encryptedMediaAPIEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "mediaKeys"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().encryptedMediaAPIEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onencrypted"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().encryptedMediaAPIEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onwaitingforkey"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().wirelessPlaybackTargetAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitCurrentPlaybackTargetIsWireless"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().exposeSpeakersEnabled && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().perElementSpeakerSelectionEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "sinkId"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLMediaElement::s_info = { "HTMLMediaElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMediaElement) };

JSHTMLMediaElement::JSHTMLMediaElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLMediaElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, HTMLMediaElement>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSHTMLMediaElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLMediaElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLMediaElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLMediaElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLMediaElement>(vm, globalObject);
}

JSValue JSHTMLMediaElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMediaElementDOMConstructor, DOMConstructorID::HTMLMediaElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLMediaElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLMediaElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsHTMLMediaElement_errorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaError>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.error())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_error, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_errorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_srcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::srcAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_srcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_srcSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_srcSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_srcObjectGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnion<IDLInterface<MediaStream>, IDLInterface<MediaSource>, IDLInterface<Blob>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.srcObject())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_srcObject, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_srcObjectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_srcObjectSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLUnion<IDLInterface<MediaStream>, IDLInterface<MediaSource>, IDLInterface<Blob>>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSrcObject(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_srcObject, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_srcObjectSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_currentSrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.currentSrc())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_currentSrc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_currentSrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_crossOriginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, throwScope, impl.crossOrigin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_crossOrigin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_crossOriginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_crossOriginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCrossOrigin(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_crossOrigin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_crossOriginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_networkStateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.networkState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_networkState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_networkStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_preloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.preload())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_preload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_preloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_preloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPreload(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_preload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_preloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_bufferedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.buffered())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_buffered, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_bufferedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_readyStateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.readyState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_readyState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_readyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_seekingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.seeking())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_seeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_seekingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_currentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.currentTimeForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_currentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_currentTimeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCurrentTimeForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_currentTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_durationGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.duration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_durationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_pausedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.paused())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_paused, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_pausedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_defaultPlaybackRateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.defaultPlaybackRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_defaultPlaybackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_defaultPlaybackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_defaultPlaybackRateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDefaultPlaybackRate(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_defaultPlaybackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_defaultPlaybackRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_playbackRateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.playbackRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_playbackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_playbackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_playbackRateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPlaybackRate(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_playbackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_playbackRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_playedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.played())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_played, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_playedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_seekableGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.seekable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_seekable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_seekableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_endedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ended())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_ended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_endedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_autoplayGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autoplayAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_autoplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_autoplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_autoplaySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autoplayAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_autoplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_autoplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_loopGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::loopAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_loop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_loopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_loopSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::loopAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_loop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_loopSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_controlsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.controls())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_controls, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_controlsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_controlsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setControls(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_controls, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_controlsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_volumeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.volume())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_volume, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_volumeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_volumeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setVolume(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_volume, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_volumeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_mutedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.muted())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_muted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_mutedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_mutedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMuted(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_muted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_mutedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_defaultMutedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::mutedAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_defaultMuted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_defaultMutedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_defaultMutedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::mutedAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_defaultMuted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_defaultMutedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_webkitPreservesPitchGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitPreservesPitch())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitPreservesPitch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitPreservesPitchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_webkitPreservesPitchSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setWebkitPreservesPitch(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_webkitPreservesPitch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_webkitPreservesPitchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_webkitHasClosedCaptionsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitHasClosedCaptions())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitHasClosedCaptions, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitHasClosedCaptionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_webkitClosedCaptionsVisibleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitClosedCaptionsVisible())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitClosedCaptionsVisible, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitClosedCaptionsVisibleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_webkitClosedCaptionsVisibleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setWebkitClosedCaptionsVisible(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_webkitClosedCaptionsVisible, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_webkitClosedCaptionsVisibleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLMediaElement_webkitAudioDecodedByteCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitAudioDecodedByteCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitAudioDecodedByteCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitAudioDecodedByteCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLMediaElement_webkitVideoDecodedByteCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitVideoDecodedByteCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitVideoDecodedByteCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitVideoDecodedByteCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElement_webkitKeysGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WebKitMediaKeys>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.webkitKeys())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitKeys, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitKeysGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElement_mediaKeysGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaKeys>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.mediaKeys())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_mediaKeys, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_mediaKeysGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElement_onencryptedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().encryptedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_onencrypted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_onencryptedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline bool setJSHTMLMediaElement_onencryptedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().encryptedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_onencrypted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_onencryptedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElement_onwaitingforkeyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().waitingforkeyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_onwaitingforkey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_onwaitingforkeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline bool setJSHTMLMediaElement_onwaitingforkeySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().waitingforkeyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_onwaitingforkey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_onwaitingforkeySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsHTMLMediaElement_audioTracksGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureAudioTracks())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_audioTracks, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_audioTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_textTracksGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TextTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureTextTracks())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_textTracks, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_textTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_videoTracksGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<VideoTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureVideoTracks())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_videoTracks, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_videoTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_mediaGroupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::mediagroupAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_mediaGroup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_mediaGroupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_mediaGroupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::mediagroupAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_mediaGroup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_mediaGroupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_controllerGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<MediaController>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.controllerForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_controller, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_controllerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_controllerSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<MediaController>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "HTMLMediaElement", "controller", "MediaController"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setControllerForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_controller, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_controllerSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSValue jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWirelessGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitCurrentPlaybackTargetIsWireless())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWireless, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWirelessGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
static inline JSValue jsHTMLMediaElement_sinkIdGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.audioOutputHashedDeviceId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_sinkId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_sinkIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_loadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.load(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_load, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_loadBody>(*lexicalGlobalObject, *callFrame, "load");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_canPlayTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.canPlayType(WTFMove(type)))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_canPlayType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_canPlayTypeBody>(*lexicalGlobalObject, *callFrame, "canPlayType");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_getStartDateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDate>(*lexicalGlobalObject, throwScope, impl.getStartDate())));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_getStartDate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_getStartDateBody>(*lexicalGlobalObject, *callFrame, "getStartDate");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_playBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLMediaElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.play(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_play, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_playBody>(*lexicalGlobalObject, *callFrame, "play");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_pauseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pause(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_pause, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_pauseBody>(*lexicalGlobalObject, *callFrame, "pause");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_fastSeekBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto time = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.fastSeek(WTFMove(time)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_fastSeek, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_fastSeekBody>(*lexicalGlobalObject, *callFrame, "fastSeek");
}

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mediaKeys = convert<IDLNullable<IDLInterface<WebKitMediaKeys>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaKeys", "HTMLMediaElement", "webkitSetMediaKeys", "WebKitMediaKeys"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.webkitSetMediaKeys(WTFMove(mediaKeys)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeys, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeysBody>(*lexicalGlobalObject, *callFrame, "webkitSetMediaKeys");
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_setMediaKeysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLMediaElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mediaKeys = convert<IDLNullable<IDLInterface<MediaKeys>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaKeys", "HTMLMediaElement", "setMediaKeys", "MediaKeys"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.setMediaKeys(WTFMove(mediaKeys), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_setMediaKeys, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_setMediaKeysBody>(*lexicalGlobalObject, *callFrame, "setMediaKeys");
}

#endif

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_addTextTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto kind = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto label = argument1.value().isUndefined() ? emptyAtom() : convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto language = argument2.value().isUndefined() ? emptyAtom() : convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<TextTrack>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.addTextTrack(WTFMove(kind), WTFMove(label), WTFMove(language)))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_addTextTrack, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_addTextTrackBody>(*lexicalGlobalObject, *callFrame, "addTextTrack");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQualityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<VideoPlaybackQuality>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getVideoPlaybackQuality())));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQuality, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQualityBody>(*lexicalGlobalObject, *callFrame, "getVideoPlaybackQuality");
}

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPickerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.webkitShowPlaybackTargetPicker(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPicker, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPickerBody>(*lexicalGlobalObject, *callFrame, "webkitShowPlaybackTargetPicker");
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_setSinkIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLMediaElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto deviceId = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.setAudioOutputDevice(WTFMove(deviceId), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_setSinkId, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_setSinkIdBody>(*lexicalGlobalObject, *callFrame, "setSinkId");
}

#endif

JSC::GCClient::IsoSubspace* JSHTMLMediaElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLMediaElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLMediaElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLMediaElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLMediaElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLMediaElement = std::forward<decltype(space)>(space); }
    );
}

void JSHTMLMediaElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLMediaElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLMediaElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsHTMLMediaElement = jsCast<JSHTMLMediaElement*>(handle.slot()->asCell());
    auto& wrapped = jsHTMLMediaElement->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor, reason))
        return true;
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSHTMLMediaElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLMediaElement = static_cast<JSHTMLMediaElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHTMLMediaElement->wrapped(), jsHTMLMediaElement);
}

HTMLMediaElement* JSHTMLMediaElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLMediaElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
