/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUShaderStage.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUShaderStageConstructor);

class JSGPUShaderStagePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUShaderStagePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUShaderStagePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUShaderStagePrototype>(vm)) JSGPUShaderStagePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUShaderStagePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUShaderStagePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUShaderStagePrototype, JSGPUShaderStagePrototype::Base);

using JSGPUShaderStageDOMConstructor = JSDOMConstructorNotConstructable<JSGPUShaderStage>;

/* Hash table for constructor */

static const HashTableValue JSGPUShaderStageConstructorTableValues[] =
{
    { "VERTEX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1 } },
    { "FRAGMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2 } },
    { "COMPUTE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x4 } },
};

static_assert(GPUShaderStage::VERTEX == 0x1, "VERTEX in GPUShaderStage does not match value from IDL");
static_assert(GPUShaderStage::FRAGMENT == 0x2, "FRAGMENT in GPUShaderStage does not match value from IDL");
static_assert(GPUShaderStage::COMPUTE == 0x4, "COMPUTE in GPUShaderStage does not match value from IDL");

template<> const ClassInfo JSGPUShaderStageDOMConstructor::s_info = { "GPUShaderStage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUShaderStageDOMConstructor) };

template<> JSValue JSGPUShaderStageDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUShaderStageDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUShaderStage"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUShaderStage::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSGPUShaderStage::info(), JSGPUShaderStageConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSGPUShaderStagePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUShaderStageConstructor, 0 } },
    { "VERTEX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1 } },
    { "FRAGMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2 } },
    { "COMPUTE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x4 } },
};

const ClassInfo JSGPUShaderStagePrototype::s_info = { "GPUShaderStage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUShaderStagePrototype) };

void JSGPUShaderStagePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUShaderStage::info(), JSGPUShaderStagePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUShaderStage::s_info = { "GPUShaderStage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUShaderStage) };

JSGPUShaderStage::JSGPUShaderStage(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUShaderStage>&& impl)
    : JSDOMWrapper<GPUShaderStage>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUShaderStage>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUShaderStage::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUShaderStagePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUShaderStagePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUShaderStage::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUShaderStage>(vm, globalObject);
}

JSValue JSGPUShaderStage::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUShaderStageDOMConstructor, DOMConstructorID::GPUShaderStage>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUShaderStage::destroy(JSC::JSCell* cell)
{
    JSGPUShaderStage* thisObject = static_cast<JSGPUShaderStage*>(cell);
    thisObject->JSGPUShaderStage::~JSGPUShaderStage();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUShaderStageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUShaderStagePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUShaderStage::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSGPUShaderStage::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUShaderStage, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUShaderStage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUShaderStage = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUShaderStage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUShaderStage = std::forward<decltype(space)>(space); }
    );
}

void JSGPUShaderStage::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUShaderStage*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUShaderStageOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUShaderStageOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUShaderStage = static_cast<JSGPUShaderStage*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUShaderStage->wrapped(), jsGPUShaderStage);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUShaderStage@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14GPUShaderStageE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUShaderStage>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPUShaderStage>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUShaderStage@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14GPUShaderStageE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUShaderStage has subclasses. If GPUShaderStage has subclasses that get passed
        // to toJS() we currently require GPUShaderStage you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPUShaderStage>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUShaderStage& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUShaderStage* JSGPUShaderStage::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUShaderStage*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
