/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUFeatureName.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUFeatureName enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("depth-clip-control"),
        MAKE_STATIC_STRING_IMPL("depth32float-stencil8"),
        MAKE_STATIC_STRING_IMPL("texture-compression-bc"),
        MAKE_STATIC_STRING_IMPL("texture-compression-etc2"),
        MAKE_STATIC_STRING_IMPL("texture-compression-astc"),
        MAKE_STATIC_STRING_IMPL("timestamp-query"),
        MAKE_STATIC_STRING_IMPL("indirect-first-instance"),
        MAKE_STATIC_STRING_IMPL("shader-f16"),
        MAKE_STATIC_STRING_IMPL("rg11b10ufloat-renderable"),
        MAKE_STATIC_STRING_IMPL("bgra8unorm-storage"),
    };
    static_assert(static_cast<size_t>(GPUFeatureName::DepthClipControl) == 0, "GPUFeatureName::DepthClipControl is not 0 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Depth32floatStencil8) == 1, "GPUFeatureName::Depth32floatStencil8 is not 1 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TextureCompressionBc) == 2, "GPUFeatureName::TextureCompressionBc is not 2 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TextureCompressionEtc2) == 3, "GPUFeatureName::TextureCompressionEtc2 is not 3 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TextureCompressionAstc) == 4, "GPUFeatureName::TextureCompressionAstc is not 4 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TimestampQuery) == 5, "GPUFeatureName::TimestampQuery is not 5 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::IndirectFirstInstance) == 6, "GPUFeatureName::IndirectFirstInstance is not 6 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::ShaderF16) == 7, "GPUFeatureName::ShaderF16 is not 7 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Rg11b10ufloatRenderable) == 8, "GPUFeatureName::Rg11b10ufloatRenderable is not 8 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Bgra8unormStorage) == 9, "GPUFeatureName::Bgra8unormStorage is not 9 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUFeatureName enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUFeatureName> parseEnumerationFromString<GPUFeatureName>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUFeatureName> mappings[] = {
        { "bgra8unorm-storage", GPUFeatureName::Bgra8unormStorage },
        { "depth-clip-control", GPUFeatureName::DepthClipControl },
        { "depth32float-stencil8", GPUFeatureName::Depth32floatStencil8 },
        { "indirect-first-instance", GPUFeatureName::IndirectFirstInstance },
        { "rg11b10ufloat-renderable", GPUFeatureName::Rg11b10ufloatRenderable },
        { "shader-f16", GPUFeatureName::ShaderF16 },
        { "texture-compression-astc", GPUFeatureName::TextureCompressionAstc },
        { "texture-compression-bc", GPUFeatureName::TextureCompressionBc },
        { "texture-compression-etc2", GPUFeatureName::TextureCompressionEtc2 },
        { "timestamp-query", GPUFeatureName::TimestampQuery },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUFeatureName> parseEnumeration<GPUFeatureName>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUFeatureName>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<GPUFeatureName>()
{
    return "\"depth-clip-control\", \"depth32float-stencil8\", \"texture-compression-bc\", \"texture-compression-etc2\", \"texture-compression-astc\", \"timestamp-query\", \"indirect-first-instance\", \"shader-f16\", \"rg11b10ufloat-renderable\", \"bgra8unorm-storage\"";
}

} // namespace WebCore
