/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUComputePassTimestampWrite.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSGPUComputePassTimestampLocation.h"
#include "JSGPUQuerySet.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUComputePassTimestampWrite convertDictionary<GPUComputePassTimestampWrite>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUComputePassTimestampWrite result;
    JSValue locationValue;
    if (isNullOrUndefined)
        locationValue = jsUndefined();
    else {
        locationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "location"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!locationValue.isUndefined()) {
        result.location = convert<IDLEnumeration<GPUComputePassTimestampLocation>>(lexicalGlobalObject, locationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "location", "GPUComputePassTimestampWrite", "GPUComputePassTimestampLocation");
        return { };
    }
    JSValue queryIndexValue;
    if (isNullOrUndefined)
        queryIndexValue = jsUndefined();
    else {
        queryIndexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "queryIndex"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!queryIndexValue.isUndefined()) {
        result.queryIndex = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, queryIndexValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "queryIndex", "GPUComputePassTimestampWrite", "unsigned long");
        return { };
    }
    JSValue querySetValue;
    if (isNullOrUndefined)
        querySetValue = jsUndefined();
    else {
        querySetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "querySet"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!querySetValue.isUndefined()) {
        result.querySet = convert<IDLInterface<GPUQuerySet>>(lexicalGlobalObject, querySetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "querySet", "GPUComputePassTimestampWrite", "GPUQuerySet");
        return { };
    }
    return result;
}

} // namespace WebCore
