/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUCompareFunction.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUCompareFunction enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("never"),
        MAKE_STATIC_STRING_IMPL("less"),
        MAKE_STATIC_STRING_IMPL("equal"),
        MAKE_STATIC_STRING_IMPL("less-equal"),
        MAKE_STATIC_STRING_IMPL("greater"),
        MAKE_STATIC_STRING_IMPL("not-equal"),
        MAKE_STATIC_STRING_IMPL("greater-equal"),
        MAKE_STATIC_STRING_IMPL("always"),
    };
    static_assert(static_cast<size_t>(GPUCompareFunction::Never) == 0, "GPUCompareFunction::Never is not 0 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::Less) == 1, "GPUCompareFunction::Less is not 1 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::Equal) == 2, "GPUCompareFunction::Equal is not 2 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::LessEqual) == 3, "GPUCompareFunction::LessEqual is not 3 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::Greater) == 4, "GPUCompareFunction::Greater is not 4 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::NotEqual) == 5, "GPUCompareFunction::NotEqual is not 5 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::GreaterEqual) == 6, "GPUCompareFunction::GreaterEqual is not 6 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::Always) == 7, "GPUCompareFunction::Always is not 7 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUCompareFunction enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUCompareFunction> parseEnumerationFromString<GPUCompareFunction>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUCompareFunction> mappings[] = {
        { "always", GPUCompareFunction::Always },
        { "equal", GPUCompareFunction::Equal },
        { "greater", GPUCompareFunction::Greater },
        { "greater-equal", GPUCompareFunction::GreaterEqual },
        { "less", GPUCompareFunction::Less },
        { "less-equal", GPUCompareFunction::LessEqual },
        { "never", GPUCompareFunction::Never },
        { "not-equal", GPUCompareFunction::NotEqual },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUCompareFunction> parseEnumeration<GPUCompareFunction>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUCompareFunction>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<GPUCompareFunction>()
{
    return "\"never\", \"less\", \"equal\", \"less-equal\", \"greater\", \"not-equal\", \"greater-equal\", \"always\"";
}

} // namespace WebCore
