/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUColorDict.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUColorDict convertDictionary<GPUColorDict>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUColorDict result;
    JSValue aValue;
    if (isNullOrUndefined)
        aValue = jsUndefined();
    else {
        aValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "a"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aValue.isUndefined()) {
        result.a = convert<IDLDouble>(lexicalGlobalObject, aValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "a", "GPUColorDict", "double");
        return { };
    }
    JSValue bValue;
    if (isNullOrUndefined)
        bValue = jsUndefined();
    else {
        bValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "b"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bValue.isUndefined()) {
        result.b = convert<IDLDouble>(lexicalGlobalObject, bValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "b", "GPUColorDict", "double");
        return { };
    }
    JSValue gValue;
    if (isNullOrUndefined)
        gValue = jsUndefined();
    else {
        gValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "g"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!gValue.isUndefined()) {
        result.g = convert<IDLDouble>(lexicalGlobalObject, gValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "g", "GPUColorDict", "double");
        return { };
    }
    JSValue rValue;
    if (isNullOrUndefined)
        rValue = jsUndefined();
    else {
        rValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "r"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rValue.isUndefined()) {
        result.r = convert<IDLDouble>(lexicalGlobalObject, rValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "r", "GPUColorDict", "double");
        return { };
    }
    return result;
}

} // namespace WebCore
