/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTFloatBlend.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSEXTFloatBlendPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTFloatBlendPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTFloatBlendPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTFloatBlendPrototype>(vm)) JSEXTFloatBlendPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTFloatBlendPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTFloatBlendPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTFloatBlendPrototype, JSEXTFloatBlendPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSEXTFloatBlendPrototype::s_info = { "EXTFloatBlend"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTFloatBlendPrototype) };

void JSEXTFloatBlendPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTFloatBlend::s_info = { "EXTFloatBlend"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTFloatBlend) };

JSEXTFloatBlend::JSEXTFloatBlend(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTFloatBlend>&& impl)
    : JSDOMWrapper<EXTFloatBlend>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTFloatBlend>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTFloatBlend::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTFloatBlendPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTFloatBlendPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTFloatBlend::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTFloatBlend>(vm, globalObject);
}

void JSEXTFloatBlend::destroy(JSC::JSCell* cell)
{
    JSEXTFloatBlend* thisObject = static_cast<JSEXTFloatBlend*>(cell);
    thisObject->JSEXTFloatBlend::~JSEXTFloatBlend();
}

JSC::GCClient::IsoSubspace* JSEXTFloatBlend::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTFloatBlend, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTFloatBlend.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTFloatBlend = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTFloatBlend.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTFloatBlend = std::forward<decltype(space)>(space); }
    );
}

void JSEXTFloatBlend::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTFloatBlend*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTFloatBlendOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsEXTFloatBlend = jsCast<JSEXTFloatBlend*>(handle.slot()->asCell());
    WebGLRenderingContextBase* owner = WTF::getPtr(jsEXTFloatBlend->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from EXTFloatBlend";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTFloatBlendOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTFloatBlend = static_cast<JSEXTFloatBlend*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTFloatBlend->wrapped(), jsEXTFloatBlend);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTFloatBlend@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13EXTFloatBlendE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTFloatBlend>&& impl)
{

    if constexpr (std::is_polymorphic_v<EXTFloatBlend>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTFloatBlend@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13EXTFloatBlendE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTFloatBlend has subclasses. If EXTFloatBlend has subclasses that get passed
        // to toJS() we currently require EXTFloatBlend you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<EXTFloatBlend>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTFloatBlend& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTFloatBlend* JSEXTFloatBlend::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTFloatBlend*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
