/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTColorBufferHalfFloat.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSEXTColorBufferHalfFloatPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTColorBufferHalfFloatPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTColorBufferHalfFloatPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTColorBufferHalfFloatPrototype>(vm)) JSEXTColorBufferHalfFloatPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTColorBufferHalfFloatPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTColorBufferHalfFloatPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTColorBufferHalfFloatPrototype, JSEXTColorBufferHalfFloatPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTColorBufferHalfFloatPrototypeTableValues[] =
{
    { "RGBA16F_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x881A } },
    { "RGB16F_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x881B } },
    { "FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8211 } },
    { "UNSIGNED_NORMALIZED_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C17 } },
};

const ClassInfo JSEXTColorBufferHalfFloatPrototype::s_info = { "EXTColorBufferHalfFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTColorBufferHalfFloatPrototype) };

void JSEXTColorBufferHalfFloatPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTColorBufferHalfFloat::info(), JSEXTColorBufferHalfFloatPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTColorBufferHalfFloat::s_info = { "EXTColorBufferHalfFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTColorBufferHalfFloat) };

JSEXTColorBufferHalfFloat::JSEXTColorBufferHalfFloat(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTColorBufferHalfFloat>&& impl)
    : JSDOMWrapper<EXTColorBufferHalfFloat>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTColorBufferHalfFloat>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTColorBufferHalfFloat::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTColorBufferHalfFloatPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTColorBufferHalfFloatPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTColorBufferHalfFloat::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTColorBufferHalfFloat>(vm, globalObject);
}

void JSEXTColorBufferHalfFloat::destroy(JSC::JSCell* cell)
{
    JSEXTColorBufferHalfFloat* thisObject = static_cast<JSEXTColorBufferHalfFloat*>(cell);
    thisObject->JSEXTColorBufferHalfFloat::~JSEXTColorBufferHalfFloat();
}

JSC::GCClient::IsoSubspace* JSEXTColorBufferHalfFloat::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTColorBufferHalfFloat, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTColorBufferHalfFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTColorBufferHalfFloat = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTColorBufferHalfFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTColorBufferHalfFloat = std::forward<decltype(space)>(space); }
    );
}

void JSEXTColorBufferHalfFloat::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTColorBufferHalfFloat*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTColorBufferHalfFloatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsEXTColorBufferHalfFloat = jsCast<JSEXTColorBufferHalfFloat*>(handle.slot()->asCell());
    WebGLRenderingContextBase* owner = WTF::getPtr(jsEXTColorBufferHalfFloat->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from EXTColorBufferHalfFloat";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTColorBufferHalfFloatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTColorBufferHalfFloat = static_cast<JSEXTColorBufferHalfFloat*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTColorBufferHalfFloat->wrapped(), jsEXTColorBufferHalfFloat);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTColorBufferHalfFloat@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23EXTColorBufferHalfFloatE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTColorBufferHalfFloat>&& impl)
{

    if constexpr (std::is_polymorphic_v<EXTColorBufferHalfFloat>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTColorBufferHalfFloat@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore23EXTColorBufferHalfFloatE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTColorBufferHalfFloat has subclasses. If EXTColorBufferHalfFloat has subclasses that get passed
        // to toJS() we currently require EXTColorBufferHalfFloat you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<EXTColorBufferHalfFloat>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTColorBufferHalfFloat& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTColorBufferHalfFloat* JSEXTColorBufferHalfFloat::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTColorBufferHalfFloat*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
