/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMQuad.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMPoint.h"
#include "JSDOMPointInit.h"
#include "JSDOMQuad.h"
#include "JSDOMQuadInit.h"
#include "JSDOMRect.h"
#include "JSDOMRectInit.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMQuadConstructorFunction_fromRect);
static JSC_DECLARE_HOST_FUNCTION(jsDOMQuadConstructorFunction_fromQuad);
static JSC_DECLARE_HOST_FUNCTION(jsDOMQuadPrototypeFunction_getBounds);
static JSC_DECLARE_HOST_FUNCTION(jsDOMQuadPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMQuadConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMQuad_p1);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMQuad_p2);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMQuad_p3);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMQuad_p4);

class JSDOMQuadPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMQuadPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMQuadPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMQuadPrototype>(vm)) JSDOMQuadPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMQuadPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMQuadPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMQuadPrototype, JSDOMQuadPrototype::Base);

using JSDOMQuadDOMConstructor = JSDOMConstructor<JSDOMQuad>;

/* Hash table for constructor */

static const HashTableValue JSDOMQuadConstructorTableValues[] =
{
    { "fromRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMQuadConstructorFunction_fromRect, 0 } },
    { "fromQuad"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMQuadConstructorFunction_fromQuad, 0 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSDOMQuadDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDOMQuadDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto p1 = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto p2 = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto p3 = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto p4 = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMQuad::create(WTFMove(p1), WTFMove(p2), WTFMove(p3), WTFMove(p4));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<DOMQuad>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<DOMQuad>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSDOMQuadDOMConstructorConstruct, JSDOMQuadDOMConstructor::construct);

template<> const ClassInfo JSDOMQuadDOMConstructor::s_info = { "DOMQuad"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMQuadDOMConstructor) };

template<> JSValue JSDOMQuadDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMQuadDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DOMQuad"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMQuad::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSDOMQuad::info(), JSDOMQuadConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSDOMQuadPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMQuadConstructor, 0 } },
    { "p1"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMQuad_p1, 0 } },
    { "p2"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMQuad_p2, 0 } },
    { "p3"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMQuad_p3, 0 } },
    { "p4"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMQuad_p4, 0 } },
    { "getBounds"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMQuadPrototypeFunction_getBounds, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMQuadPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSDOMQuadPrototype::s_info = { "DOMQuad"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMQuadPrototype) };

void JSDOMQuadPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMQuad::info(), JSDOMQuadPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMQuad::s_info = { "DOMQuad"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMQuad) };

JSDOMQuad::JSDOMQuad(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMQuad>&& impl)
    : JSDOMWrapper<DOMQuad, SignedPtrTraits<DOMQuad, DOMQuadPtrTag>>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMQuad>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMQuad::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMQuadPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMQuadPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMQuad::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMQuad>(vm, globalObject);
}

JSValue JSDOMQuad::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMQuadDOMConstructor, DOMConstructorID::DOMQuad>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMQuad::destroy(JSC::JSCell* cell)
{
    JSDOMQuad* thisObject = static_cast<JSDOMQuad*>(cell);
    thisObject->JSDOMQuad::~JSDOMQuad();
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMQuadConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMQuadPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMQuad::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsDOMQuad_p1Getter(JSGlobalObject& lexicalGlobalObject, JSDOMQuad& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.p1())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMQuad_p1, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMQuad>::get<jsDOMQuad_p1Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMQuad_p2Getter(JSGlobalObject& lexicalGlobalObject, JSDOMQuad& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.p2())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMQuad_p2, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMQuad>::get<jsDOMQuad_p2Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMQuad_p3Getter(JSGlobalObject& lexicalGlobalObject, JSDOMQuad& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.p3())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMQuad_p3, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMQuad>::get<jsDOMQuad_p3Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMQuad_p4Getter(JSGlobalObject& lexicalGlobalObject, JSDOMQuad& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.p4())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMQuad_p4, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMQuad>::get<jsDOMQuad_p4Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDOMQuadConstructorFunction_fromRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto other = convert<IDLDictionary<DOMRectInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMQuad>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMQuad::fromRect(WTFMove(other)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMQuadConstructorFunction_fromRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMQuad>::callStatic<jsDOMQuadConstructorFunction_fromRectBody>(*lexicalGlobalObject, *callFrame, "fromRect");
}

static inline JSC::EncodedJSValue jsDOMQuadConstructorFunction_fromQuadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto other = convert<IDLDictionary<DOMQuadInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMQuad>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMQuad::fromQuad(WTFMove(other)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMQuadConstructorFunction_fromQuad, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMQuad>::callStatic<jsDOMQuadConstructorFunction_fromQuadBody>(*lexicalGlobalObject, *callFrame, "fromQuad");
}

static inline JSC::EncodedJSValue jsDOMQuadPrototypeFunction_getBoundsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMQuad>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getBounds())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMQuadPrototypeFunction_getBounds, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMQuad>::call<jsDOMQuadPrototypeFunction_getBoundsBody>(*lexicalGlobalObject, *callFrame, "getBounds");
}

static inline EncodedJSValue jsDOMQuadPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSDOMQuad* castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto p1Value = toJS<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.p1());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "p1"_s), p1Value);
    auto p2Value = toJS<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.p2());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "p2"_s), p2Value);
    auto p3Value = toJS<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.p3());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "p3"_s), p3Value);
    auto p4Value = toJS<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.p4());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "p4"_s), p4Value);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsDOMQuadPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMQuad>::call<jsDOMQuadPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSDOMQuad::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMQuad, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMQuad.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMQuad = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMQuad.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMQuad = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSDOMQuad::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSDOMQuad*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSDOMQuad);

template<typename Visitor>
void JSDOMQuad::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSDOMQuad*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSDOMQuad::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSDOMQuad::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSDOMQuad::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMQuad*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMQuadOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMQuadOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMQuad = static_cast<JSDOMQuad*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMQuad->wrapped(), jsDOMQuad);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMQuad@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7DOMQuadE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMQuad>&& impl)
{

    if constexpr (std::is_polymorphic_v<DOMQuad>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMQuad@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore7DOMQuadE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMQuad has subclasses. If DOMQuad has subclasses that get passed
        // to toJS() we currently require DOMQuad you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<DOMQuad>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMQuad& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMQuad* JSDOMQuad::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMQuad*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
