/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMPointReadOnly.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrixInit.h"
#include "JSDOMOperation.h"
#include "JSDOMPoint.h"
#include "JSDOMPointInit.h"
#include "JSDOMPointReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMPointReadOnlyConstructorFunction_fromPoint);
static JSC_DECLARE_HOST_FUNCTION(jsDOMPointReadOnlyPrototypeFunction_matrixTransform);
static JSC_DECLARE_HOST_FUNCTION(jsDOMPointReadOnlyPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMPointReadOnlyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMPointReadOnly_x);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMPointReadOnly_y);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMPointReadOnly_z);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMPointReadOnly_w);

class JSDOMPointReadOnlyPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMPointReadOnlyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMPointReadOnlyPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMPointReadOnlyPrototype>(vm)) JSDOMPointReadOnlyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMPointReadOnlyPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMPointReadOnlyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMPointReadOnlyPrototype, JSDOMPointReadOnlyPrototype::Base);

using JSDOMPointReadOnlyDOMConstructor = JSDOMConstructor<JSDOMPointReadOnly>;

/* Hash table for constructor */

static const HashTableValue JSDOMPointReadOnlyConstructorTableValues[] =
{
    { "fromPoint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMPointReadOnlyConstructorFunction_fromPoint, 0 } },
};

static inline EncodedJSValue constructJSDOMPointReadOnly1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDOMPointReadOnlyDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto point = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMPointReadOnly::create(WTFMove(point));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<DOMPointReadOnly>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<DOMPointReadOnly>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSDOMPointReadOnly2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDOMPointReadOnlyDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto x = argument0.value().isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto y = argument1.value().isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto z = argument2.value().isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto w = argument3.value().isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMPointReadOnly::create(WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<DOMPointReadOnly>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<DOMPointReadOnly>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSDOMPointReadOnlyDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (constructJSDOMPointReadOnly1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject())
            RELEASE_AND_RETURN(throwScope, (constructJSDOMPointReadOnly1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isNumber())
            RELEASE_AND_RETURN(throwScope, (constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame)));
        RELEASE_AND_RETURN(throwScope, (constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 4) {
        RELEASE_AND_RETURN(throwScope, (constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}
JSC_ANNOTATE_HOST_FUNCTION(JSDOMPointReadOnlyConstructorConstruct, JSDOMPointReadOnlyDOMConstructor::construct);

template<> const ClassInfo JSDOMPointReadOnlyDOMConstructor::s_info = { "DOMPointReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMPointReadOnlyDOMConstructor) };

template<> JSValue JSDOMPointReadOnlyDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMPointReadOnlyDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DOMPointReadOnly"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMPointReadOnly::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSDOMPointReadOnly::info(), JSDOMPointReadOnlyConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSDOMPointReadOnlyPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMPointReadOnlyConstructor, 0 } },
    { "x"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMPointReadOnly_x, 0 } },
    { "y"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMPointReadOnly_y, 0 } },
    { "z"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMPointReadOnly_z, 0 } },
    { "w"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMPointReadOnly_w, 0 } },
    { "matrixTransform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMPointReadOnlyPrototypeFunction_matrixTransform, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMPointReadOnlyPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSDOMPointReadOnlyPrototype::s_info = { "DOMPointReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMPointReadOnlyPrototype) };

void JSDOMPointReadOnlyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMPointReadOnly::info(), JSDOMPointReadOnlyPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMPointReadOnly::s_info = { "DOMPointReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMPointReadOnly) };

JSDOMPointReadOnly::JSDOMPointReadOnly(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMPointReadOnly>&& impl)
    : JSDOMWrapper<DOMPointReadOnly, SignedPtrTraits<DOMPointReadOnly, DOMPointReadOnlyPtrTag>>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMPointReadOnly>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMPointReadOnly::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMPointReadOnlyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMPointReadOnlyPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMPointReadOnly::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMPointReadOnly>(vm, globalObject);
}

JSValue JSDOMPointReadOnly::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMPointReadOnlyDOMConstructor, DOMConstructorID::DOMPointReadOnly>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMPointReadOnly::destroy(JSC::JSCell* cell)
{
    JSDOMPointReadOnly* thisObject = static_cast<JSDOMPointReadOnly*>(cell);
    thisObject->JSDOMPointReadOnly::~JSDOMPointReadOnly();
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMPointReadOnlyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMPointReadOnlyPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMPointReadOnly::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsDOMPointReadOnly_xGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPointReadOnly& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.x())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMPointReadOnly_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMPointReadOnly>::get<jsDOMPointReadOnly_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMPointReadOnly_yGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPointReadOnly& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.y())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMPointReadOnly_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMPointReadOnly>::get<jsDOMPointReadOnly_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMPointReadOnly_zGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPointReadOnly& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.z())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMPointReadOnly_z, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMPointReadOnly>::get<jsDOMPointReadOnly_zGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMPointReadOnly_wGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPointReadOnly& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.w())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMPointReadOnly_w, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMPointReadOnly>::get<jsDOMPointReadOnly_wGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDOMPointReadOnlyConstructorFunction_fromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto other = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMPointReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMPointReadOnly::fromPoint(WTFMove(other)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMPointReadOnlyConstructorFunction_fromPoint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMPointReadOnly>::callStatic<jsDOMPointReadOnlyConstructorFunction_fromPointBody>(*lexicalGlobalObject, *callFrame, "fromPoint");
}

static inline JSC::EncodedJSValue jsDOMPointReadOnlyPrototypeFunction_matrixTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMPointReadOnly>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto matrix = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.matrixTransform(WTFMove(matrix)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMPointReadOnlyPrototypeFunction_matrixTransform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMPointReadOnly>::call<jsDOMPointReadOnlyPrototypeFunction_matrixTransformBody>(*lexicalGlobalObject, *callFrame, "matrixTransform");
}

static inline EncodedJSValue jsDOMPointReadOnlyPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSDOMPointReadOnly* castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto xValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.x());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "x"_s), xValue);
    auto yValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.y());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "y"_s), yValue);
    auto zValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.z());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "z"_s), zValue);
    auto wValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.w());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "w"_s), wValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsDOMPointReadOnlyPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMPointReadOnly>::call<jsDOMPointReadOnlyPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSDOMPointReadOnly::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMPointReadOnly, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMPointReadOnly.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMPointReadOnly = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMPointReadOnly.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMPointReadOnly = std::forward<decltype(space)>(space); }
    );
}

void JSDOMPointReadOnly::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMPointReadOnly*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMPointReadOnlyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMPointReadOnlyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMPointReadOnly = static_cast<JSDOMPointReadOnly*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMPointReadOnly->wrapped(), jsDOMPointReadOnly);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMPointReadOnly@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16DOMPointReadOnlyE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMPointReadOnly>&& impl)
{

    if constexpr (std::is_polymorphic_v<DOMPointReadOnly>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMPointReadOnly@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16DOMPointReadOnlyE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMPointReadOnly has subclasses. If DOMPointReadOnly has subclasses that get passed
        // to toJS() we currently require DOMPointReadOnly you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<DOMPointReadOnly>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMPointReadOnly& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMPointReadOnly* JSDOMPointReadOnly::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMPointReadOnly*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
