/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMCSSNamespace.h"

#include "ActiveDOMObject.h"
#include "CSSNumericFactory.h"
#include "DOMCSSNamespace.h"
#include "DOMCSSRegisterCustomProperty.h"
#include "DeprecatedGlobalSettings.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCSSUnitValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMCSSCustomPropertyDescriptor.h"
#include "JSDOMConstructorNotCallable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHighlightRegister.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectPrototype.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>

#if ENABLE(CSS_PAINTING_API)
#include "DOMCSSPaintWorklet.h"
#include "JSWorklet.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_supports);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_escape);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_number);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_percent);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_em);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ex);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ch);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ic);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rem);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rlh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cm);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_mm);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_Q);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_in);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_pt);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_pc);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_px);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_deg);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_grad);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rad);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_turn);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_s);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ms);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_Hz);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_kHz);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dpi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dpcm);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dppx);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_fr);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_registerProperty);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMCSSNamespaceConstructor_highlights);
#if ENABLE(CSS_PAINTING_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDOMCSSNamespaceConstructor_paintWorklet);
#endif

using JSDOMCSSNamespaceDOMConstructor = JSDOMConstructorNotCallable<JSDOMCSSNamespace>;

/* Hash table for constructor */

static const HashTableValue JSDOMCSSNamespaceConstructorTableValues[] =
{
    { "highlights"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMCSSNamespaceConstructor_highlights, 0 } },
#if ENABLE(CSS_PAINTING_API)
    { "paintWorklet"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMCSSNamespaceConstructor_paintWorklet, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "supports"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_supports, 1 } },
    { "escape"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_escape, 1 } },
    { "number"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_number, 1 } },
    { "percent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_percent, 1 } },
    { "em"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_em, 1 } },
    { "ex"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_ex, 1 } },
    { "ch"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_ch, 1 } },
    { "ic"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_ic, 1 } },
    { "rem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_rem, 1 } },
    { "lh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lh, 1 } },
    { "rlh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_rlh, 1 } },
    { "vw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vw, 1 } },
    { "vh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vh, 1 } },
    { "vi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vi, 1 } },
    { "vb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vb, 1 } },
    { "vmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vmin, 1 } },
    { "vmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vmax, 1 } },
    { "svw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svw, 1 } },
    { "svh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svh, 1 } },
    { "svi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svi, 1 } },
    { "svb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svb, 1 } },
    { "svmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svmin, 1 } },
    { "svmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svmax, 1 } },
    { "lvw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvw, 1 } },
    { "lvh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvh, 1 } },
    { "lvi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvi, 1 } },
    { "lvb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvb, 1 } },
    { "lvmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvmin, 1 } },
    { "lvmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvmax, 1 } },
    { "dvw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvw, 1 } },
    { "dvh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvh, 1 } },
    { "dvi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvi, 1 } },
    { "dvb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvb, 1 } },
    { "dvmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvmin, 1 } },
    { "dvmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvmax, 1 } },
    { "cqw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqw, 1 } },
    { "cqh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqh, 1 } },
    { "cqi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqi, 1 } },
    { "cqb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqb, 1 } },
    { "cqmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqmin, 1 } },
    { "cqmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqmax, 1 } },
    { "cm"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cm, 1 } },
    { "mm"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_mm, 1 } },
    { "Q"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_Q, 1 } },
    { "in"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_in, 1 } },
    { "pt"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_pt, 1 } },
    { "pc"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_pc, 1 } },
    { "px"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_px, 1 } },
    { "deg"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_deg, 1 } },
    { "grad"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_grad, 1 } },
    { "rad"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_rad, 1 } },
    { "turn"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_turn, 1 } },
    { "s"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_s, 1 } },
    { "ms"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_ms, 1 } },
    { "Hz"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_Hz, 1 } },
    { "kHz"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_kHz, 1 } },
    { "dpi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dpi, 1 } },
    { "dpcm"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dpcm, 1 } },
    { "dppx"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dppx, 1 } },
    { "fr"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_fr, 1 } },
    { "registerProperty"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_registerProperty, 1 } },
};

template<> const ClassInfo JSDOMCSSNamespaceDOMConstructor::s_info = { "CSS"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCSSNamespaceDOMConstructor) };

template<> JSValue JSDOMCSSNamespaceDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.objectPrototype();
}

template<> void JSDOMCSSNamespaceDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
    reifyStaticProperties(vm, JSDOMCSSNamespace::info(), JSDOMCSSNamespaceConstructorTableValues, *this);
    if (!DeprecatedGlobalSettings::highlightAPIEnabled()) {
        auto propertyName = Identifier::fromString(vm, "highlights"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
#if ENABLE(CSS_PAINTING_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssPaintingAPIEnabled) {
        auto propertyName = Identifier::fromString(vm, "paintWorklet"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
#endif
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "number"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "percent"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "em"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "ex"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "ch"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "ic"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "rem"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "lh"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "rlh"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "vw"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "vh"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "vi"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "vb"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "vmin"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "vmax"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "svw"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "svh"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "svi"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "svb"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "svmin"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "svmax"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "lvw"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "lvh"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "lvi"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "lvb"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "lvmin"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "lvmax"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "dvw"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "dvh"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "dvi"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "dvb"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "dvmin"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "dvmax"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "cqw"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "cqh"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "cqi"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "cqb"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "cqmin"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "cqmax"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "cm"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "mm"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "Q"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "in"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "pt"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "pc"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "px"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "deg"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "grad"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "rad"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "turn"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "s"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "ms"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "Hz"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "kHz"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "dpi"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "dpcm"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "dppx"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        auto propertyName = Identifier::fromString(vm, "fr"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssCustomPropertiesAndValuesEnabled) {
        auto propertyName = Identifier::fromString(vm, "registerProperty"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
}

const ClassInfo JSDOMCSSNamespace::s_info = { "CSS"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCSSNamespace) };

JSDOMCSSNamespace::JSDOMCSSNamespace(Structure* structure, JSDOMGlobalObject& globalObject)
    : JSDOMObject(structure, globalObject) { }

static_assert(!std::is_base_of<ActiveDOMObject, DOMCSSNamespace>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSValue JSDOMCSSNamespace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMCSSNamespaceDOMConstructor, DOMConstructorID::DOMCSSNamespace>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMCSSNamespace::destroy(JSC::JSCell* cell)
{
    JSDOMCSSNamespace* thisObject = static_cast<JSDOMCSSNamespace*>(cell);
    thisObject->JSDOMCSSNamespace::~JSDOMCSSNamespace();
}

static inline JSValue jsDOMCSSNamespaceConstructor_highlightsGetter(JSGlobalObject& lexicalGlobalObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HighlightRegister>>(lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), throwScope, DOMCSSNamespace::highlights(document))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMCSSNamespaceConstructor_highlights, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMCSSNamespace>::getStatic<jsDOMCSSNamespaceConstructor_highlightsGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(CSS_PAINTING_API)
static inline JSValue jsDOMCSSNamespaceConstructor_paintWorkletGetter(JSGlobalObject& lexicalGlobalObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Worklet>>(lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), throwScope, WebCore::DOMCSSPaintWorklet::ensurePaintWorklet(document))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMCSSNamespaceConstructor_paintWorklet, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMCSSNamespace>::getStatic<jsDOMCSSNamespaceConstructor_paintWorkletGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_supports1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto property = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto value = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, DOMCSSNamespace::supports(document, WTFMove(property), WTFMove(value)))));
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_supports2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto conditionText = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, DOMCSSNamespace::supports(document, WTFMove(conditionText)))));
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_supportsOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsDOMCSSNamespaceConstructorFunction_supports2Body(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsDOMCSSNamespaceConstructorFunction_supports1Body(lexicalGlobalObject, callFrame)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_supports, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_supportsOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "supports");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_escapeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto ident = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, DOMCSSNamespace::escape(WTFMove(ident)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_escape, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_escapeBody>(*lexicalGlobalObject, *callFrame, "escape");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_numberBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::number(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_number, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_numberBody>(*lexicalGlobalObject, *callFrame, "number");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_percentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::percent(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_percent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_percentBody>(*lexicalGlobalObject, *callFrame, "percent");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_emBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::em(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_em, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_emBody>(*lexicalGlobalObject, *callFrame, "em");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_exBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::ex(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ex, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_exBody>(*lexicalGlobalObject, *callFrame, "ex");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_chBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::ch(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ch, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_chBody>(*lexicalGlobalObject, *callFrame, "ch");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_icBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::ic(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ic, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_icBody>(*lexicalGlobalObject, *callFrame, "ic");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_remBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::rem(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_remBody>(*lexicalGlobalObject, *callFrame, "rem");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lh(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lhBody>(*lexicalGlobalObject, *callFrame, "lh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_rlhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::rlh(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rlh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_rlhBody>(*lexicalGlobalObject, *callFrame, "rlh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vw(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vwBody>(*lexicalGlobalObject, *callFrame, "vw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vh(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vhBody>(*lexicalGlobalObject, *callFrame, "vh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_viBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vi(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_viBody>(*lexicalGlobalObject, *callFrame, "vi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vb(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vbBody>(*lexicalGlobalObject, *callFrame, "vb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vmin(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vminBody>(*lexicalGlobalObject, *callFrame, "vmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vmax(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vmaxBody>(*lexicalGlobalObject, *callFrame, "vmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svw(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svwBody>(*lexicalGlobalObject, *callFrame, "svw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svh(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svhBody>(*lexicalGlobalObject, *callFrame, "svh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_sviBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svi(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_sviBody>(*lexicalGlobalObject, *callFrame, "svi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svb(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svbBody>(*lexicalGlobalObject, *callFrame, "svb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svmin(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svminBody>(*lexicalGlobalObject, *callFrame, "svmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svmax(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svmaxBody>(*lexicalGlobalObject, *callFrame, "svmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvw(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvwBody>(*lexicalGlobalObject, *callFrame, "lvw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvh(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvhBody>(*lexicalGlobalObject, *callFrame, "lvh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lviBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvi(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lviBody>(*lexicalGlobalObject, *callFrame, "lvi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvb(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvbBody>(*lexicalGlobalObject, *callFrame, "lvb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvmin(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvminBody>(*lexicalGlobalObject, *callFrame, "lvmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvmax(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvmaxBody>(*lexicalGlobalObject, *callFrame, "lvmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvw(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvwBody>(*lexicalGlobalObject, *callFrame, "dvw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvh(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvhBody>(*lexicalGlobalObject, *callFrame, "dvh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dviBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvi(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dviBody>(*lexicalGlobalObject, *callFrame, "dvi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvb(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvbBody>(*lexicalGlobalObject, *callFrame, "dvb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvmin(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvminBody>(*lexicalGlobalObject, *callFrame, "dvmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvmax(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvmaxBody>(*lexicalGlobalObject, *callFrame, "dvmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqw(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqwBody>(*lexicalGlobalObject, *callFrame, "cqw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqh(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqhBody>(*lexicalGlobalObject, *callFrame, "cqh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqi(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqiBody>(*lexicalGlobalObject, *callFrame, "cqi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqb(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqbBody>(*lexicalGlobalObject, *callFrame, "cqb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqmin(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqminBody>(*lexicalGlobalObject, *callFrame, "cqmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqmax(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqmaxBody>(*lexicalGlobalObject, *callFrame, "cqmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cmBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cm(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cm, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cmBody>(*lexicalGlobalObject, *callFrame, "cm");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_mmBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::mm(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_mm, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_mmBody>(*lexicalGlobalObject, *callFrame, "mm");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_QBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::q(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_Q, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_QBody>(*lexicalGlobalObject, *callFrame, "Q");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_inBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::in(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_in, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_inBody>(*lexicalGlobalObject, *callFrame, "in");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_ptBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::pt(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_pt, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_ptBody>(*lexicalGlobalObject, *callFrame, "pt");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_pcBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::pc(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_pc, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_pcBody>(*lexicalGlobalObject, *callFrame, "pc");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_pxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::px(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_px, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_pxBody>(*lexicalGlobalObject, *callFrame, "px");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_degBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::deg(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_deg, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_degBody>(*lexicalGlobalObject, *callFrame, "deg");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_gradBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::grad(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_grad, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_gradBody>(*lexicalGlobalObject, *callFrame, "grad");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_radBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::rad(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rad, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_radBody>(*lexicalGlobalObject, *callFrame, "rad");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_turnBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::turn(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_turn, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_turnBody>(*lexicalGlobalObject, *callFrame, "turn");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_sBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::s(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_s, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_sBody>(*lexicalGlobalObject, *callFrame, "s");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_msBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::ms(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ms, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_msBody>(*lexicalGlobalObject, *callFrame, "ms");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_HzBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::hz(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_Hz, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_HzBody>(*lexicalGlobalObject, *callFrame, "Hz");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_kHzBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::kHz(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_kHz, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_kHzBody>(*lexicalGlobalObject, *callFrame, "kHz");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dpiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dpi(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dpi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dpiBody>(*lexicalGlobalObject, *callFrame, "dpi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dpcmBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dpcm(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dpcm, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dpcmBody>(*lexicalGlobalObject, *callFrame, "dpcm");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dppxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dppx(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dppx, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dppxBody>(*lexicalGlobalObject, *callFrame, "dppx");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_frBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::fr(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_fr, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_frBody>(*lexicalGlobalObject, *callFrame, "fr");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_registerPropertyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptor = convert<IDLDictionary<DOMCSSCustomPropertyDescriptor>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return WebCore::DOMCSSRegisterCustomProperty::registerProperty(document, WTFMove(descriptor)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_registerProperty, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_registerPropertyBody>(*lexicalGlobalObject, *callFrame, "registerProperty");
}

JSC::GCClient::IsoSubspace* JSDOMCSSNamespace::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMCSSNamespace, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMCSSNamespace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMCSSNamespace = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMCSSNamespace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMCSSNamespace = std::forward<decltype(space)>(space); }
    );
}


}
