/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCommandLineAPIHost.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDatabase.h"
#include "JSEventTarget.h"
#include "JSStorage.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

template<> CommandLineAPIHost::ListenerEntry convertDictionary<CommandLineAPIHost::ListenerEntry>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CommandLineAPIHost::ListenerEntry result;
    JSValue listenerValue;
    if (isNullOrUndefined)
        listenerValue = jsUndefined();
    else {
        listenerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "listener"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!listenerValue.isUndefined()) {
        result.listener = convert<IDLObject>(lexicalGlobalObject, listenerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "listener", "ListenerEntry", "object");
        return { };
    }
    JSValue onceValue;
    if (isNullOrUndefined)
        onceValue = jsUndefined();
    else {
        onceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "once"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!onceValue.isUndefined()) {
        result.once = convert<IDLBoolean>(lexicalGlobalObject, onceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "once", "ListenerEntry", "boolean");
        return { };
    }
    JSValue passiveValue;
    if (isNullOrUndefined)
        passiveValue = jsUndefined();
    else {
        passiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "passive"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!passiveValue.isUndefined()) {
        result.passive = convert<IDLBoolean>(lexicalGlobalObject, passiveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "passive", "ListenerEntry", "boolean");
        return { };
    }
    JSValue useCaptureValue;
    if (isNullOrUndefined)
        useCaptureValue = jsUndefined();
    else {
        useCaptureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "useCapture"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!useCaptureValue.isUndefined()) {
        result.useCapture = convert<IDLBoolean>(lexicalGlobalObject, useCaptureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "useCapture", "ListenerEntry", "boolean");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const CommandLineAPIHost::ListenerEntry& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto listenerValue = toJS<IDLObject>(lexicalGlobalObject, throwScope, dictionary.listener);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "listener"_s), listenerValue);
    auto onceValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.once);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "once"_s), onceValue);
    auto passiveValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.passive);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "passive"_s), passiveValue);
    auto useCaptureValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.useCapture);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "useCapture"_s), useCaptureValue);
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_clearConsoleMessages);
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_copyText);
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_inspect);
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_inspectedObject);
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_getEventListeners);
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_databaseId);
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_storageId);

class JSCommandLineAPIHostPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCommandLineAPIHostPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCommandLineAPIHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSCommandLineAPIHostPrototype>(vm)) JSCommandLineAPIHostPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCommandLineAPIHostPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCommandLineAPIHostPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCommandLineAPIHostPrototype, JSCommandLineAPIHostPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSCommandLineAPIHostPrototypeTableValues[] =
{
    { "clearConsoleMessages"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_clearConsoleMessages, 0 } },
    { "copyText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_copyText, 1 } },
    { "inspect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_inspect, 2 } },
    { "inspectedObject"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_inspectedObject, 0 } },
    { "getEventListeners"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_getEventListeners, 1 } },
    { "databaseId"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_databaseId, 1 } },
    { "storageId"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_storageId, 1 } },
};

const ClassInfo JSCommandLineAPIHostPrototype::s_info = { "CommandLineAPIHost"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCommandLineAPIHostPrototype) };

void JSCommandLineAPIHostPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCommandLineAPIHost::info(), JSCommandLineAPIHostPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCommandLineAPIHost::s_info = { "CommandLineAPIHost"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCommandLineAPIHost) };

JSCommandLineAPIHost::JSCommandLineAPIHost(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CommandLineAPIHost>&& impl)
    : JSDOMWrapper<CommandLineAPIHost>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CommandLineAPIHost>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCommandLineAPIHost::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCommandLineAPIHostPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCommandLineAPIHostPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCommandLineAPIHost::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCommandLineAPIHost>(vm, globalObject);
}

void JSCommandLineAPIHost::destroy(JSC::JSCell* cell)
{
    JSCommandLineAPIHost* thisObject = static_cast<JSCommandLineAPIHost*>(cell);
    thisObject->JSCommandLineAPIHost::~JSCommandLineAPIHost();
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_clearConsoleMessagesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearConsoleMessages(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_clearConsoleMessages, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_clearConsoleMessagesBody>(*lexicalGlobalObject, *callFrame, "clearConsoleMessages");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_copyTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyText(WTFMove(text)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_copyText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_copyTextBody>(*lexicalGlobalObject, *callFrame, "copyText");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_inspectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto objectToInspect = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto hints = convert<IDLAny>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.inspect(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(objectToInspect), WTFMove(hints)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_inspect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_inspectBody>(*lexicalGlobalObject, *callFrame, "inspect");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_inspectedObjectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, impl.inspectedObject(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_inspectedObject, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_inspectedObjectBody>(*lexicalGlobalObject, *callFrame, "inspectedObject");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_getEventListenersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLInterface<EventTarget>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "CommandLineAPIHost", "getEventListeners", "EventTarget"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLRecord<IDLDOMString, IDLSequence<IDLDictionary<CommandLineAPIHost::ListenerEntry>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getEventListeners(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *target))));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_getEventListeners, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_getEventListenersBody>(*lexicalGlobalObject, *callFrame, "getEventListeners");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_databaseIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto database = convert<IDLInterface<Database>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "database", "CommandLineAPIHost", "databaseId", "Database"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.databaseId(*database))));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_databaseId, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_databaseIdBody>(*lexicalGlobalObject, *callFrame, "databaseId");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_storageIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto storage = convert<IDLInterface<Storage>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "storage", "CommandLineAPIHost", "storageId", "Storage"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.storageId(*storage))));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_storageId, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_storageIdBody>(*lexicalGlobalObject, *callFrame, "storageId");
}

JSC::GCClient::IsoSubspace* JSCommandLineAPIHost::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCommandLineAPIHost, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCommandLineAPIHost.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCommandLineAPIHost = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCommandLineAPIHost.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCommandLineAPIHost = std::forward<decltype(space)>(space); }
    );
}

void JSCommandLineAPIHost::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCommandLineAPIHost*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCommandLineAPIHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCommandLineAPIHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCommandLineAPIHost = static_cast<JSCommandLineAPIHost*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCommandLineAPIHost->wrapped(), jsCommandLineAPIHost);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CommandLineAPIHost@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18CommandLineAPIHostE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CommandLineAPIHost>&& impl)
{

    if constexpr (std::is_polymorphic_v<CommandLineAPIHost>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CommandLineAPIHost@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18CommandLineAPIHostE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CommandLineAPIHost has subclasses. If CommandLineAPIHost has subclasses that get passed
        // to toJS() we currently require CommandLineAPIHost you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<CommandLineAPIHost>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CommandLineAPIHost& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CommandLineAPIHost* JSCommandLineAPIHost::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCommandLineAPIHost*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
