/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleValue.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSStyleValue.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleValueConstructorFunction_parse);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleValueConstructorFunction_parseAll);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleValuePrototypeFunction_toString);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleValueConstructor);

class JSCSSStyleValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSStyleValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSStyleValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSStyleValuePrototype>(vm)) JSCSSStyleValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSStyleValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleValuePrototype, JSCSSStyleValuePrototype::Base);

using JSCSSStyleValueDOMConstructor = JSDOMConstructorNotConstructable<JSCSSStyleValue>;

/* Hash table for constructor */

static const HashTableValue JSCSSStyleValueConstructorTableValues[] =
{
    { "parse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleValueConstructorFunction_parse, 2 } },
    { "parseAll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleValueConstructorFunction_parseAll, 2 } },
};

template<> const ClassInfo JSCSSStyleValueDOMConstructor::s_info = { "CSSStyleValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleValueDOMConstructor) };

template<> JSValue JSCSSStyleValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSStyleValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSStyleValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSStyleValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSCSSStyleValue::info(), JSCSSStyleValueConstructorTableValues, *this);
    if (!(&globalObject)->inherits<JSDOMWindowBase>()) {
        auto propertyName = Identifier::fromString(vm, "parse"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
    if (!(&globalObject)->inherits<JSDOMWindowBase>()) {
        auto propertyName = Identifier::fromString(vm, "parseAll"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
}

/* Hash table for prototype */

static const HashTableValue JSCSSStyleValuePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleValueConstructor, 0 } },
    { "toString"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleValuePrototypeFunction_toString, 0 } },
};

const ClassInfo JSCSSStyleValuePrototype::s_info = { "CSSStyleValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleValuePrototype) };

void JSCSSStyleValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSStyleValue::info(), JSCSSStyleValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSStyleValue::s_info = { "CSSStyleValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleValue) };

JSCSSStyleValue::JSCSSStyleValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSStyleValue>&& impl)
    : JSDOMWrapper<CSSStyleValue>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSStyleValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSStyleValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSStyleValuePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCSSStyleValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSStyleValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSStyleValue>(vm, globalObject);
}

JSValue JSCSSStyleValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleValueDOMConstructor, DOMConstructorID::CSSStyleValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCSSStyleValue::destroy(JSC::JSCell* cell)
{
    JSCSSStyleValue* thisObject = static_cast<JSCSSStyleValue*>(cell);
    thisObject->JSCSSStyleValue::~JSCSSStyleValue();
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSStyleValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSStyleValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsCSSStyleValueConstructorFunction_parseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto property = convert<IDLAtomStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto cssText = convert<IDLUSVString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSStyleValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, CSSStyleValue::parse(document, WTFMove(property), WTFMove(cssText)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleValueConstructorFunction_parse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleValue>::callStatic<jsCSSStyleValueConstructorFunction_parseBody>(*lexicalGlobalObject, *callFrame, "parse");
}

static inline JSC::EncodedJSValue jsCSSStyleValueConstructorFunction_parseAllBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto property = convert<IDLAtomStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto cssText = convert<IDLUSVString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<CSSStyleValue>>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, CSSStyleValue::parseAll(document, WTFMove(property), WTFMove(cssText)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleValueConstructorFunction_parseAll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleValue>::callStatic<jsCSSStyleValueConstructorFunction_parseAllBody>(*lexicalGlobalObject, *callFrame, "parseAll");
}

static inline JSC::EncodedJSValue jsCSSStyleValuePrototypeFunction_toStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.toString())));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleValuePrototypeFunction_toString, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleValue>::call<jsCSSStyleValuePrototypeFunction_toStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

JSC::GCClient::IsoSubspace* JSCSSStyleValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSStyleValue, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSStyleValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSStyleValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSStyleValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSStyleValue = std::forward<decltype(space)>(space); }
    );
}

void JSCSSStyleValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSStyleValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCSSStyleValueOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCSSStyleValueOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCSSStyleValue = static_cast<JSCSSStyleValue*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCSSStyleValue->wrapped(), jsCSSStyleValue);
}

CSSStyleValue* JSCSSStyleValue::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSStyleValue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
