/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSMathValue.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSMathOperator.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSMathValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSMathValue_operator);

class JSCSSMathValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSMathValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSMathValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSMathValuePrototype>(vm)) JSCSSMathValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSMathValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSMathValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSMathValuePrototype, JSCSSMathValuePrototype::Base);

using JSCSSMathValueDOMConstructor = JSDOMConstructorNotConstructable<JSCSSMathValue>;

template<> const ClassInfo JSCSSMathValueDOMConstructor::s_info = { "CSSMathValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSMathValueDOMConstructor) };

template<> JSValue JSCSSMathValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSNumericValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSMathValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSMathValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSMathValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSMathValuePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSMathValueConstructor, 0 } },
    { "operator"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSMathValue_operator, 0 } },
};

const ClassInfo JSCSSMathValuePrototype::s_info = { "CSSMathValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSMathValuePrototype) };

void JSCSSMathValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSMathValue::info(), JSCSSMathValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSMathValue::s_info = { "CSSMathValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSMathValue) };

JSCSSMathValue::JSCSSMathValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSMathValue>&& impl)
    : JSCSSNumericValue(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSMathValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSMathValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSMathValuePrototype::createStructure(vm, &globalObject, JSCSSNumericValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSMathValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSMathValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSMathValue>(vm, globalObject);
}

JSValue JSCSSMathValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSMathValueDOMConstructor, DOMConstructorID::CSSMathValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSMathValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSMathValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSMathValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsCSSMathValue_operatorGetter(JSGlobalObject& lexicalGlobalObject, JSCSSMathValue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<CSSMathOperator>>(lexicalGlobalObject, throwScope, impl.getOperator())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSMathValue_operator, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSMathValue>::get<jsCSSMathValue_operatorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSMathValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSMathValue, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSMathValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSMathValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSMathValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSMathValue = std::forward<decltype(space)>(space); }
    );
}

void JSCSSMathValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSMathValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
