/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "InspectorProtocolObjects.h"

#include <wtf/Assertions.h>

namespace Inspector {

namespace Protocol {

namespace Helpers {

static const ASCIILiteral enum_constant_values[] = {
    "ready"_s,
    "delayed"_s,
    "active"_s,
    "canceled"_s,
    "done"_s,
    "normal"_s,
    "reverse"_s,
    "alternate"_s,
    "alternate-reverse"_s,
    "none"_s,
    "forwards"_s,
    "backwards"_s,
    "both"_s,
    "auto"_s,
    "main"_s,
    "webkit"_s,
    "user"_s,
    "user-agent"_s,
    "author"_s,
    "inspector"_s,
    "first-line"_s,
    "first-letter"_s,
    "highlight"_s,
    "marker"_s,
    "before"_s,
    "after"_s,
    "selection"_s,
    "backdrop"_s,
    "scrollbar"_s,
    "scrollbar-thumb"_s,
    "scrollbar-button"_s,
    "scrollbar-track"_s,
    "scrollbar-track-piece"_s,
    "scrollbar-corner"_s,
    "resizer"_s,
    "focus"_s,
    "focus-visible"_s,
    "focus-within"_s,
    "hover"_s,
    "target"_s,
    "visited"_s,
    "inactive"_s,
    "disabled"_s,
    "style"_s,
    "media-rule"_s,
    "media-import-rule"_s,
    "media-link-node"_s,
    "media-style-node"_s,
    "supports-rule"_s,
    "layer-rule"_s,
    "layer-import-rule"_s,
    "container-rule"_s,
    "style-rule"_s,
    "rendered"_s,
    "scrollable"_s,
    "flex"_s,
    "grid"_s,
    "event"_s,
    "observed"_s,
    "all"_s,
    "srgb"_s,
    "display-p3"_s,
    "canvas-2d"_s,
    "offscreen-canvas-2d"_s,
    "bitmaprenderer"_s,
    "webgl"_s,
    "webgl2"_s,
    "compute"_s,
    "render"_s,
    "fragment"_s,
    "vertex"_s,
    "xml"_s,
    "javascript"_s,
    "network"_s,
    "console-api"_s,
    "storage"_s,
    "appcache"_s,
    "rendering"_s,
    "css"_s,
    "security"_s,
    "content-blocker"_s,
    "media"_s,
    "mediasource"_s,
    "webrtc"_s,
    "itp-debug"_s,
    "private-click-measurement"_s,
    "payment-request"_s,
    "other"_s,
    "off"_s,
    "basic"_s,
    "verbose"_s,
    "main-frame-navigation"_s,
    "log"_s,
    "info"_s,
    "warning"_s,
    "error"_s,
    "debug"_s,
    "dir"_s,
    "dirxml"_s,
    "table"_s,
    "trace"_s,
    "clear"_s,
    "startGroup"_s,
    "startGroupCollapsed"_s,
    "endGroup"_s,
    "assert"_s,
    "timing"_s,
    "profile"_s,
    "profileEnd"_s,
    "image"_s,
    "open"_s,
    "closed"_s,
    "builtin"_s,
    "custom"_s,
    "waiting"_s,
    "failed"_s,
    "additions"_s,
    "removals"_s,
    "text"_s,
    "true"_s,
    "false"_s,
    "mixed"_s,
    "page"_s,
    "step"_s,
    "location"_s,
    "date"_s,
    "time"_s,
    "grammar"_s,
    "spelling"_s,
    "assertive"_s,
    "polite"_s,
    "subtree-modified"_s,
    "attribute-modified"_s,
    "node-removed"_s,
    "animation-frame"_s,
    "interval"_s,
    "listener"_s,
    "timeout"_s,
    "evaluate"_s,
    "sound"_s,
    "probe"_s,
    "global"_s,
    "with"_s,
    "closure"_s,
    "catch"_s,
    "functionName"_s,
    "globalLexicalEnvironment"_s,
    "nestedLexical"_s,
    "full"_s,
    "partial"_s,
    "number"_s,
    "string"_s,
    "array"_s,
    "null"_s,
    "jit"_s,
    "images"_s,
    "layers"_s,
    "empty-string"_s,
    "no-referrer"_s,
    "no-referrer-when-downgrade"_s,
    "same-origin"_s,
    "origin"_s,
    "strict-origin"_s,
    "origin-when-cross-origin"_s,
    "strict-origin-when-cross-origin"_s,
    "unsafe-url"_s,
    "unknown"_s,
    "memory-cache"_s,
    "disk-cache"_s,
    "service-worker"_s,
    "inspector-override"_s,
    "low"_s,
    "medium"_s,
    "high"_s,
    "Document"_s,
    "StyleSheet"_s,
    "Image"_s,
    "Font"_s,
    "Script"_s,
    "XHR"_s,
    "Fetch"_s,
    "Ping"_s,
    "Beacon"_s,
    "WebSocket"_s,
    "EventSource"_s,
    "Other"_s,
    "parser"_s,
    "script"_s,
    "request"_s,
    "response"_s,
    "General"_s,
    "AccessControl"_s,
    "Cancellation"_s,
    "Timeout"_s,
    "PrivateClickMeasurementDebugModeEnabled"_s,
    "AuthorAndUserStylesEnabled"_s,
    "ICECandidateFilteringEnabled"_s,
    "ITPDebugModeEnabled"_s,
    "ImagesEnabled"_s,
    "MediaCaptureRequiresSecureConnection"_s,
    "MockCaptureDevicesEnabled"_s,
    "NeedsSiteSpecificQuirks"_s,
    "ScriptEnabled"_s,
    "ShowDebugBorders"_s,
    "ShowRepaintCounter"_s,
    "WebSecurityEnabled"_s,
    "PrefersReducedMotion"_s,
    "PrefersContrast"_s,
    "PrefersColorScheme"_s,
    "NoPreference"_s,
    "Reduce"_s,
    "More"_s,
    "Light"_s,
    "Dark"_s,
    "Viewport"_s,
    "Page"_s,
    "None"_s,
    "Lax"_s,
    "Strict"_s,
    "canvas-bitmaprenderer"_s,
    "canvas-webgl"_s,
    "canvas-webgl2"_s,
    "frontend"_s,
    "console"_s,
    "auto-capture"_s,
    "object"_s,
    "function"_s,
    "undefined"_s,
    "boolean"_s,
    "symbol"_s,
    "bigint"_s,
    "node"_s,
    "regexp"_s,
    "map"_s,
    "set"_s,
    "weakmap"_s,
    "weakset"_s,
    "iterator"_s,
    "class"_s,
    "proxy"_s,
    "weakref"_s,
    "accessor"_s,
    "internal"_s,
    "irrecoverable"_s,
    "unterminated-literal"_s,
    "recoverable"_s,
    "API"_s,
    "Microtask"_s,
    "worker"_s,
    "EventDispatch"_s,
    "ScheduleStyleRecalculation"_s,
    "RecalculateStyles"_s,
    "InvalidateLayout"_s,
    "Layout"_s,
    "Paint"_s,
    "Composite"_s,
    "RenderingFrame"_s,
    "TimerInstall"_s,
    "TimerRemove"_s,
    "TimerFire"_s,
    "EvaluateScript"_s,
    "TimeStamp"_s,
    "Time"_s,
    "TimeEnd"_s,
    "FunctionCall"_s,
    "ProbeSample"_s,
    "ConsoleProfile"_s,
    "RequestAnimationFrame"_s,
    "CancelAnimationFrame"_s,
    "FireAnimationFrame"_s,
    "ObserverCallback"_s,
    "Screenshot"_s,
    "ScriptProfiler"_s,
    "Timeline"_s,
    "CPU"_s,
    "Memory"_s,
    "Heap"_s,
    "Animation"_s,
    "URL"_s,
    "DOM"_s,
    "AnimationFrame"_s,
    "Interval"_s,
    "Listener"_s,
    "exception"_s,
    "CSPViolation"_s,
    "DebuggerStatement"_s,
    "Breakpoint"_s,
    "PauseOnNextStatement"_s,
    "BlackboxedScript"_s,
    "critical"_s,
    "non-critical"_s,
    "uncaught"_s,
};

String getEnumConstantValue(int code) {
    return enum_constant_values[code];
}

// Enums in the 'Animation' Domain

template<> std::optional<Protocol::Animation::AnimationState> parseEnumValueFromString<Protocol::Animation::AnimationState>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Animation::AnimationState::Ready,
        (size_t)Protocol::Animation::AnimationState::Delayed,
        (size_t)Protocol::Animation::AnimationState::Active,
        (size_t)Protocol::Animation::AnimationState::Canceled,
        (size_t)Protocol::Animation::AnimationState::Done,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Animation::AnimationState)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Animation::PlaybackDirection> parseEnumValueFromString<Protocol::Animation::PlaybackDirection>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Animation::PlaybackDirection::Normal,
        (size_t)Protocol::Animation::PlaybackDirection::Reverse,
        (size_t)Protocol::Animation::PlaybackDirection::Alternate,
        (size_t)Protocol::Animation::PlaybackDirection::AlternateReverse,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Animation::PlaybackDirection)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Animation::FillMode> parseEnumValueFromString<Protocol::Animation::FillMode>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Animation::FillMode::None,
        (size_t)Protocol::Animation::FillMode::Forwards,
        (size_t)Protocol::Animation::FillMode::Backwards,
        (size_t)Protocol::Animation::FillMode::Both,
        (size_t)Protocol::Animation::FillMode::Auto,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Animation::FillMode)constantValues[i];

    return std::nullopt;
}

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
// Enums in the 'CPUProfiler' Domain

template<> std::optional<Protocol::CPUProfiler::ThreadInfo::Type> parseEnumValueFromString<Protocol::CPUProfiler::ThreadInfo::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::CPUProfiler::ThreadInfo::Type::Main,
        (size_t)Protocol::CPUProfiler::ThreadInfo::Type::WebKit,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::CPUProfiler::ThreadInfo::Type)constantValues[i];

    return std::nullopt;
}
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

// Enums in the 'CSS' Domain

template<> std::optional<Protocol::CSS::StyleSheetOrigin> parseEnumValueFromString<Protocol::CSS::StyleSheetOrigin>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::CSS::StyleSheetOrigin::User,
        (size_t)Protocol::CSS::StyleSheetOrigin::UserAgent,
        (size_t)Protocol::CSS::StyleSheetOrigin::Author,
        (size_t)Protocol::CSS::StyleSheetOrigin::Inspector,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::CSS::StyleSheetOrigin)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::CSS::PseudoId> parseEnumValueFromString<Protocol::CSS::PseudoId>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::CSS::PseudoId::FirstLine,
        (size_t)Protocol::CSS::PseudoId::FirstLetter,
        (size_t)Protocol::CSS::PseudoId::Highlight,
        (size_t)Protocol::CSS::PseudoId::Marker,
        (size_t)Protocol::CSS::PseudoId::Before,
        (size_t)Protocol::CSS::PseudoId::After,
        (size_t)Protocol::CSS::PseudoId::Selection,
        (size_t)Protocol::CSS::PseudoId::Backdrop,
        (size_t)Protocol::CSS::PseudoId::Scrollbar,
        (size_t)Protocol::CSS::PseudoId::ScrollbarThumb,
        (size_t)Protocol::CSS::PseudoId::ScrollbarButton,
        (size_t)Protocol::CSS::PseudoId::ScrollbarTrack,
        (size_t)Protocol::CSS::PseudoId::ScrollbarTrackPiece,
        (size_t)Protocol::CSS::PseudoId::ScrollbarCorner,
        (size_t)Protocol::CSS::PseudoId::Resizer,
    };
    for (size_t i = 0; i < 15; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::CSS::PseudoId)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::CSS::ForceablePseudoClass> parseEnumValueFromString<Protocol::CSS::ForceablePseudoClass>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::CSS::ForceablePseudoClass::Active,
        (size_t)Protocol::CSS::ForceablePseudoClass::Focus,
        (size_t)Protocol::CSS::ForceablePseudoClass::FocusVisible,
        (size_t)Protocol::CSS::ForceablePseudoClass::FocusWithin,
        (size_t)Protocol::CSS::ForceablePseudoClass::Hover,
        (size_t)Protocol::CSS::ForceablePseudoClass::Target,
        (size_t)Protocol::CSS::ForceablePseudoClass::Visited,
    };
    for (size_t i = 0; i < 7; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::CSS::ForceablePseudoClass)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::CSS::CSSPropertyStatus> parseEnumValueFromString<Protocol::CSS::CSSPropertyStatus>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::CSS::CSSPropertyStatus::Active,
        (size_t)Protocol::CSS::CSSPropertyStatus::Inactive,
        (size_t)Protocol::CSS::CSSPropertyStatus::Disabled,
        (size_t)Protocol::CSS::CSSPropertyStatus::Style,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::CSS::CSSPropertyStatus)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::CSS::LayoutFlag> parseEnumValueFromString<Protocol::CSS::LayoutFlag>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::CSS::LayoutFlag::Rendered,
        (size_t)Protocol::CSS::LayoutFlag::Scrollable,
        (size_t)Protocol::CSS::LayoutFlag::Flex,
        (size_t)Protocol::CSS::LayoutFlag::Grid,
        (size_t)Protocol::CSS::LayoutFlag::Event,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::CSS::LayoutFlag)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::CSS::LayoutContextTypeChangedMode> parseEnumValueFromString<Protocol::CSS::LayoutContextTypeChangedMode>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::CSS::LayoutContextTypeChangedMode::Observed,
        (size_t)Protocol::CSS::LayoutContextTypeChangedMode::All,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::CSS::LayoutContextTypeChangedMode)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::CSS::Grouping::Type> parseEnumValueFromString<Protocol::CSS::Grouping::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::CSS::Grouping::Type::MediaRule,
        (size_t)Protocol::CSS::Grouping::Type::MediaImportRule,
        (size_t)Protocol::CSS::Grouping::Type::MediaLinkNode,
        (size_t)Protocol::CSS::Grouping::Type::MediaStyleNode,
        (size_t)Protocol::CSS::Grouping::Type::SupportsRule,
        (size_t)Protocol::CSS::Grouping::Type::LayerRule,
        (size_t)Protocol::CSS::Grouping::Type::LayerImportRule,
        (size_t)Protocol::CSS::Grouping::Type::ContainerRule,
        (size_t)Protocol::CSS::Grouping::Type::StyleRule,
    };
    for (size_t i = 0; i < 9; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::CSS::Grouping::Type)constantValues[i];

    return std::nullopt;
}

// Enums in the 'Canvas' Domain

template<> std::optional<Protocol::Canvas::ColorSpace> parseEnumValueFromString<Protocol::Canvas::ColorSpace>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Canvas::ColorSpace::SRGB,
        (size_t)Protocol::Canvas::ColorSpace::DisplayP3,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Canvas::ColorSpace)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Canvas::ContextType> parseEnumValueFromString<Protocol::Canvas::ContextType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Canvas::ContextType::Canvas2D,
        (size_t)Protocol::Canvas::ContextType::OffscreenCanvas2D,
        (size_t)Protocol::Canvas::ContextType::BitmapRenderer,
        (size_t)Protocol::Canvas::ContextType::WebGL,
        (size_t)Protocol::Canvas::ContextType::WebGL2,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Canvas::ContextType)constantValues[i];

    return std::nullopt;
}

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
template<> std::optional<Protocol::Canvas::ProgramType> parseEnumValueFromString<Protocol::Canvas::ProgramType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Canvas::ProgramType::Compute,
        (size_t)Protocol::Canvas::ProgramType::Render,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Canvas::ProgramType)constantValues[i];

    return std::nullopt;
}
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
template<> std::optional<Protocol::Canvas::ShaderType> parseEnumValueFromString<Protocol::Canvas::ShaderType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Canvas::ShaderType::Compute,
        (size_t)Protocol::Canvas::ShaderType::Fragment,
        (size_t)Protocol::Canvas::ShaderType::Vertex,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Canvas::ShaderType)constantValues[i];

    return std::nullopt;
}
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

// Enums in the 'Console' Domain

template<> std::optional<Protocol::Console::ChannelSource> parseEnumValueFromString<Protocol::Console::ChannelSource>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Console::ChannelSource::XML,
        (size_t)Protocol::Console::ChannelSource::JavaScript,
        (size_t)Protocol::Console::ChannelSource::Network,
        (size_t)Protocol::Console::ChannelSource::ConsoleAPI,
        (size_t)Protocol::Console::ChannelSource::Storage,
        (size_t)Protocol::Console::ChannelSource::Appcache,
        (size_t)Protocol::Console::ChannelSource::Rendering,
        (size_t)Protocol::Console::ChannelSource::CSS,
        (size_t)Protocol::Console::ChannelSource::Security,
        (size_t)Protocol::Console::ChannelSource::ContentBlocker,
        (size_t)Protocol::Console::ChannelSource::Media,
        (size_t)Protocol::Console::ChannelSource::MediaSource,
        (size_t)Protocol::Console::ChannelSource::WebRTC,
        (size_t)Protocol::Console::ChannelSource::ITPDebug,
        (size_t)Protocol::Console::ChannelSource::PrivateClickMeasurement,
        (size_t)Protocol::Console::ChannelSource::PaymentRequest,
        (size_t)Protocol::Console::ChannelSource::Other,
    };
    for (size_t i = 0; i < 17; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Console::ChannelSource)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Console::ChannelLevel> parseEnumValueFromString<Protocol::Console::ChannelLevel>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Console::ChannelLevel::Off,
        (size_t)Protocol::Console::ChannelLevel::Basic,
        (size_t)Protocol::Console::ChannelLevel::Verbose,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Console::ChannelLevel)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Console::ClearReason> parseEnumValueFromString<Protocol::Console::ClearReason>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Console::ClearReason::ConsoleAPI,
        (size_t)Protocol::Console::ClearReason::MainFrameNavigation,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Console::ClearReason)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Console::ConsoleMessage::Level> parseEnumValueFromString<Protocol::Console::ConsoleMessage::Level>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Console::ConsoleMessage::Level::Log,
        (size_t)Protocol::Console::ConsoleMessage::Level::Info,
        (size_t)Protocol::Console::ConsoleMessage::Level::Warning,
        (size_t)Protocol::Console::ConsoleMessage::Level::Error,
        (size_t)Protocol::Console::ConsoleMessage::Level::Debug,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Console::ConsoleMessage::Level)constantValues[i];

    return std::nullopt;
}
template<> std::optional<Protocol::Console::ConsoleMessage::Type> parseEnumValueFromString<Protocol::Console::ConsoleMessage::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Console::ConsoleMessage::Type::Log,
        (size_t)Protocol::Console::ConsoleMessage::Type::Dir,
        (size_t)Protocol::Console::ConsoleMessage::Type::DirXML,
        (size_t)Protocol::Console::ConsoleMessage::Type::Table,
        (size_t)Protocol::Console::ConsoleMessage::Type::Trace,
        (size_t)Protocol::Console::ConsoleMessage::Type::Clear,
        (size_t)Protocol::Console::ConsoleMessage::Type::StartGroup,
        (size_t)Protocol::Console::ConsoleMessage::Type::StartGroupCollapsed,
        (size_t)Protocol::Console::ConsoleMessage::Type::EndGroup,
        (size_t)Protocol::Console::ConsoleMessage::Type::Assert,
        (size_t)Protocol::Console::ConsoleMessage::Type::Timing,
        (size_t)Protocol::Console::ConsoleMessage::Type::Profile,
        (size_t)Protocol::Console::ConsoleMessage::Type::ProfileEnd,
        (size_t)Protocol::Console::ConsoleMessage::Type::Image,
    };
    for (size_t i = 0; i < 14; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Console::ConsoleMessage::Type)constantValues[i];

    return std::nullopt;
}

// Enums in the 'DOM' Domain

template<> std::optional<Protocol::DOM::PseudoType> parseEnumValueFromString<Protocol::DOM::PseudoType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOM::PseudoType::Before,
        (size_t)Protocol::DOM::PseudoType::After,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOM::PseudoType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::DOM::ShadowRootType> parseEnumValueFromString<Protocol::DOM::ShadowRootType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOM::ShadowRootType::UserAgent,
        (size_t)Protocol::DOM::ShadowRootType::Open,
        (size_t)Protocol::DOM::ShadowRootType::Closed,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOM::ShadowRootType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::DOM::CustomElementState> parseEnumValueFromString<Protocol::DOM::CustomElementState>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOM::CustomElementState::Builtin,
        (size_t)Protocol::DOM::CustomElementState::Custom,
        (size_t)Protocol::DOM::CustomElementState::Waiting,
        (size_t)Protocol::DOM::CustomElementState::Failed,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOM::CustomElementState)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::DOM::LiveRegionRelevant> parseEnumValueFromString<Protocol::DOM::LiveRegionRelevant>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOM::LiveRegionRelevant::Additions,
        (size_t)Protocol::DOM::LiveRegionRelevant::Removals,
        (size_t)Protocol::DOM::LiveRegionRelevant::Text,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOM::LiveRegionRelevant)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::DOM::AccessibilityProperties::Checked> parseEnumValueFromString<Protocol::DOM::AccessibilityProperties::Checked>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOM::AccessibilityProperties::Checked::True,
        (size_t)Protocol::DOM::AccessibilityProperties::Checked::False,
        (size_t)Protocol::DOM::AccessibilityProperties::Checked::Mixed,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOM::AccessibilityProperties::Checked)constantValues[i];

    return std::nullopt;
}
template<> std::optional<Protocol::DOM::AccessibilityProperties::Current> parseEnumValueFromString<Protocol::DOM::AccessibilityProperties::Current>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOM::AccessibilityProperties::Current::True,
        (size_t)Protocol::DOM::AccessibilityProperties::Current::False,
        (size_t)Protocol::DOM::AccessibilityProperties::Current::Page,
        (size_t)Protocol::DOM::AccessibilityProperties::Current::Step,
        (size_t)Protocol::DOM::AccessibilityProperties::Current::Location,
        (size_t)Protocol::DOM::AccessibilityProperties::Current::Date,
        (size_t)Protocol::DOM::AccessibilityProperties::Current::Time,
    };
    for (size_t i = 0; i < 7; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOM::AccessibilityProperties::Current)constantValues[i];

    return std::nullopt;
}
template<> std::optional<Protocol::DOM::AccessibilityProperties::Invalid> parseEnumValueFromString<Protocol::DOM::AccessibilityProperties::Invalid>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOM::AccessibilityProperties::Invalid::True,
        (size_t)Protocol::DOM::AccessibilityProperties::Invalid::False,
        (size_t)Protocol::DOM::AccessibilityProperties::Invalid::Grammar,
        (size_t)Protocol::DOM::AccessibilityProperties::Invalid::Spelling,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOM::AccessibilityProperties::Invalid)constantValues[i];

    return std::nullopt;
}
template<> std::optional<Protocol::DOM::AccessibilityProperties::LiveRegionStatus> parseEnumValueFromString<Protocol::DOM::AccessibilityProperties::LiveRegionStatus>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOM::AccessibilityProperties::LiveRegionStatus::Assertive,
        (size_t)Protocol::DOM::AccessibilityProperties::LiveRegionStatus::Polite,
        (size_t)Protocol::DOM::AccessibilityProperties::LiveRegionStatus::Off,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOM::AccessibilityProperties::LiveRegionStatus)constantValues[i];

    return std::nullopt;
}

// Enums in the 'DOMDebugger' Domain

template<> std::optional<Protocol::DOMDebugger::DOMBreakpointType> parseEnumValueFromString<Protocol::DOMDebugger::DOMBreakpointType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOMDebugger::DOMBreakpointType::SubtreeModified,
        (size_t)Protocol::DOMDebugger::DOMBreakpointType::AttributeModified,
        (size_t)Protocol::DOMDebugger::DOMBreakpointType::NodeRemoved,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOMDebugger::DOMBreakpointType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::DOMDebugger::EventBreakpointType> parseEnumValueFromString<Protocol::DOMDebugger::EventBreakpointType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::DOMDebugger::EventBreakpointType::AnimationFrame,
        (size_t)Protocol::DOMDebugger::EventBreakpointType::Interval,
        (size_t)Protocol::DOMDebugger::EventBreakpointType::Listener,
        (size_t)Protocol::DOMDebugger::EventBreakpointType::Timeout,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::DOMDebugger::EventBreakpointType)constantValues[i];

    return std::nullopt;
}

// Enums in the 'Debugger' Domain

template<> std::optional<Protocol::Debugger::BreakpointAction::Type> parseEnumValueFromString<Protocol::Debugger::BreakpointAction::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Debugger::BreakpointAction::Type::Log,
        (size_t)Protocol::Debugger::BreakpointAction::Type::Evaluate,
        (size_t)Protocol::Debugger::BreakpointAction::Type::Sound,
        (size_t)Protocol::Debugger::BreakpointAction::Type::Probe,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Debugger::BreakpointAction::Type)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Debugger::Scope::Type> parseEnumValueFromString<Protocol::Debugger::Scope::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Debugger::Scope::Type::Global,
        (size_t)Protocol::Debugger::Scope::Type::With,
        (size_t)Protocol::Debugger::Scope::Type::Closure,
        (size_t)Protocol::Debugger::Scope::Type::Catch,
        (size_t)Protocol::Debugger::Scope::Type::FunctionName,
        (size_t)Protocol::Debugger::Scope::Type::GlobalLexicalEnvironment,
        (size_t)Protocol::Debugger::Scope::Type::NestedLexical,
    };
    for (size_t i = 0; i < 7; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Debugger::Scope::Type)constantValues[i];

    return std::nullopt;
}

// Enums in the 'Heap' Domain

template<> std::optional<Protocol::Heap::GarbageCollection::Type> parseEnumValueFromString<Protocol::Heap::GarbageCollection::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Heap::GarbageCollection::Type::Full,
        (size_t)Protocol::Heap::GarbageCollection::Type::Partial,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Heap::GarbageCollection::Type)constantValues[i];

    return std::nullopt;
}

// Enums in the 'IndexedDB' Domain

template<> std::optional<Protocol::IndexedDB::Key::Type> parseEnumValueFromString<Protocol::IndexedDB::Key::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::IndexedDB::Key::Type::Number,
        (size_t)Protocol::IndexedDB::Key::Type::String,
        (size_t)Protocol::IndexedDB::Key::Type::Date,
        (size_t)Protocol::IndexedDB::Key::Type::Array,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::IndexedDB::Key::Type)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::IndexedDB::KeyPath::Type> parseEnumValueFromString<Protocol::IndexedDB::KeyPath::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::IndexedDB::KeyPath::Type::Null,
        (size_t)Protocol::IndexedDB::KeyPath::Type::String,
        (size_t)Protocol::IndexedDB::KeyPath::Type::Array,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::IndexedDB::KeyPath::Type)constantValues[i];

    return std::nullopt;
}

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
// Enums in the 'Memory' Domain

template<> std::optional<Protocol::Memory::CategoryData::Type> parseEnumValueFromString<Protocol::Memory::CategoryData::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Memory::CategoryData::Type::JavaScript,
        (size_t)Protocol::Memory::CategoryData::Type::JIT,
        (size_t)Protocol::Memory::CategoryData::Type::Images,
        (size_t)Protocol::Memory::CategoryData::Type::Layers,
        (size_t)Protocol::Memory::CategoryData::Type::Page,
        (size_t)Protocol::Memory::CategoryData::Type::Other,
    };
    for (size_t i = 0; i < 6; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Memory::CategoryData::Type)constantValues[i];

    return std::nullopt;
}
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

// Enums in the 'Network' Domain

template<> std::optional<Protocol::Network::ReferrerPolicy> parseEnumValueFromString<Protocol::Network::ReferrerPolicy>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Network::ReferrerPolicy::EmptyString,
        (size_t)Protocol::Network::ReferrerPolicy::NoReferrer,
        (size_t)Protocol::Network::ReferrerPolicy::NoReferrerWhenDowngrade,
        (size_t)Protocol::Network::ReferrerPolicy::SameOrigin,
        (size_t)Protocol::Network::ReferrerPolicy::Origin,
        (size_t)Protocol::Network::ReferrerPolicy::StrictOrigin,
        (size_t)Protocol::Network::ReferrerPolicy::OriginWhenCrossOrigin,
        (size_t)Protocol::Network::ReferrerPolicy::StrictOriginWhenCrossOrigin,
        (size_t)Protocol::Network::ReferrerPolicy::UnsafeUrl,
    };
    for (size_t i = 0; i < 9; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Network::ReferrerPolicy)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Network::NetworkStage> parseEnumValueFromString<Protocol::Network::NetworkStage>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Network::NetworkStage::Request,
        (size_t)Protocol::Network::NetworkStage::Response,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Network::NetworkStage)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Network::ResourceErrorType> parseEnumValueFromString<Protocol::Network::ResourceErrorType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Network::ResourceErrorType::General,
        (size_t)Protocol::Network::ResourceErrorType::AccessControl,
        (size_t)Protocol::Network::ResourceErrorType::Cancellation,
        (size_t)Protocol::Network::ResourceErrorType::Timeout,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Network::ResourceErrorType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Network::Response::Source> parseEnumValueFromString<Protocol::Network::Response::Source>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Network::Response::Source::Unknown,
        (size_t)Protocol::Network::Response::Source::Network,
        (size_t)Protocol::Network::Response::Source::MemoryCache,
        (size_t)Protocol::Network::Response::Source::DiskCache,
        (size_t)Protocol::Network::Response::Source::ServiceWorker,
        (size_t)Protocol::Network::Response::Source::InspectorOverride,
    };
    for (size_t i = 0; i < 6; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Network::Response::Source)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Network::Metrics::Priority> parseEnumValueFromString<Protocol::Network::Metrics::Priority>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Network::Metrics::Priority::Low,
        (size_t)Protocol::Network::Metrics::Priority::Medium,
        (size_t)Protocol::Network::Metrics::Priority::High,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Network::Metrics::Priority)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Network::Initiator::Type> parseEnumValueFromString<Protocol::Network::Initiator::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Network::Initiator::Type::Parser,
        (size_t)Protocol::Network::Initiator::Type::Script,
        (size_t)Protocol::Network::Initiator::Type::Other,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Network::Initiator::Type)constantValues[i];

    return std::nullopt;
}

// Enums in the 'Page' Domain

template<> std::optional<Protocol::Page::Setting> parseEnumValueFromString<Protocol::Page::Setting>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Page::Setting::PrivateClickMeasurementDebugModeEnabled,
        (size_t)Protocol::Page::Setting::AuthorAndUserStylesEnabled,
        (size_t)Protocol::Page::Setting::ICECandidateFilteringEnabled,
        (size_t)Protocol::Page::Setting::ITPDebugModeEnabled,
        (size_t)Protocol::Page::Setting::ImagesEnabled,
        (size_t)Protocol::Page::Setting::MediaCaptureRequiresSecureConnection,
        (size_t)Protocol::Page::Setting::MockCaptureDevicesEnabled,
        (size_t)Protocol::Page::Setting::NeedsSiteSpecificQuirks,
        (size_t)Protocol::Page::Setting::ScriptEnabled,
        (size_t)Protocol::Page::Setting::ShowDebugBorders,
        (size_t)Protocol::Page::Setting::ShowRepaintCounter,
        (size_t)Protocol::Page::Setting::WebSecurityEnabled,
    };
    for (size_t i = 0; i < 12; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Page::Setting)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Page::UserPreferenceName> parseEnumValueFromString<Protocol::Page::UserPreferenceName>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Page::UserPreferenceName::PrefersReducedMotion,
        (size_t)Protocol::Page::UserPreferenceName::PrefersContrast,
        (size_t)Protocol::Page::UserPreferenceName::PrefersColorScheme,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Page::UserPreferenceName)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Page::UserPreferenceValue> parseEnumValueFromString<Protocol::Page::UserPreferenceValue>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Page::UserPreferenceValue::NoPreference,
        (size_t)Protocol::Page::UserPreferenceValue::Reduce,
        (size_t)Protocol::Page::UserPreferenceValue::More,
        (size_t)Protocol::Page::UserPreferenceValue::Light,
        (size_t)Protocol::Page::UserPreferenceValue::Dark,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Page::UserPreferenceValue)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Page::ResourceType> parseEnumValueFromString<Protocol::Page::ResourceType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Page::ResourceType::Document,
        (size_t)Protocol::Page::ResourceType::StyleSheet,
        (size_t)Protocol::Page::ResourceType::Image,
        (size_t)Protocol::Page::ResourceType::Font,
        (size_t)Protocol::Page::ResourceType::Script,
        (size_t)Protocol::Page::ResourceType::XHR,
        (size_t)Protocol::Page::ResourceType::Fetch,
        (size_t)Protocol::Page::ResourceType::Ping,
        (size_t)Protocol::Page::ResourceType::Beacon,
        (size_t)Protocol::Page::ResourceType::WebSocket,
        (size_t)Protocol::Page::ResourceType::EventSource,
        (size_t)Protocol::Page::ResourceType::Other,
    };
    for (size_t i = 0; i < 12; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Page::ResourceType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Page::CoordinateSystem> parseEnumValueFromString<Protocol::Page::CoordinateSystem>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Page::CoordinateSystem::Viewport,
        (size_t)Protocol::Page::CoordinateSystem::Page,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Page::CoordinateSystem)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Page::CookieSameSitePolicy> parseEnumValueFromString<Protocol::Page::CookieSameSitePolicy>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Page::CookieSameSitePolicy::None,
        (size_t)Protocol::Page::CookieSameSitePolicy::Lax,
        (size_t)Protocol::Page::CookieSameSitePolicy::Strict,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Page::CookieSameSitePolicy)constantValues[i];

    return std::nullopt;
}

// Enums in the 'Recording' Domain

template<> std::optional<Protocol::Recording::Type> parseEnumValueFromString<Protocol::Recording::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Recording::Type::Canvas2D,
        (size_t)Protocol::Recording::Type::OffscreenCanvas2D,
        (size_t)Protocol::Recording::Type::CanvasBitmapRenderer,
        (size_t)Protocol::Recording::Type::CanvasWebGL,
        (size_t)Protocol::Recording::Type::CanvasWebGL2,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Recording::Type)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Recording::Initiator> parseEnumValueFromString<Protocol::Recording::Initiator>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Recording::Initiator::Frontend,
        (size_t)Protocol::Recording::Initiator::Console,
        (size_t)Protocol::Recording::Initiator::AutoCapture,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Recording::Initiator)constantValues[i];

    return std::nullopt;
}

// Enums in the 'Runtime' Domain

template<> std::optional<Protocol::Runtime::ExecutionContextType> parseEnumValueFromString<Protocol::Runtime::ExecutionContextType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Runtime::ExecutionContextType::Normal,
        (size_t)Protocol::Runtime::ExecutionContextType::User,
        (size_t)Protocol::Runtime::ExecutionContextType::Internal,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Runtime::ExecutionContextType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Runtime::SyntaxErrorType> parseEnumValueFromString<Protocol::Runtime::SyntaxErrorType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Runtime::SyntaxErrorType::None,
        (size_t)Protocol::Runtime::SyntaxErrorType::Irrecoverable,
        (size_t)Protocol::Runtime::SyntaxErrorType::UnterminatedLiteral,
        (size_t)Protocol::Runtime::SyntaxErrorType::Recoverable,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Runtime::SyntaxErrorType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Runtime::RemoteObject::Type> parseEnumValueFromString<Protocol::Runtime::RemoteObject::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Runtime::RemoteObject::Type::Object,
        (size_t)Protocol::Runtime::RemoteObject::Type::Function,
        (size_t)Protocol::Runtime::RemoteObject::Type::Undefined,
        (size_t)Protocol::Runtime::RemoteObject::Type::String,
        (size_t)Protocol::Runtime::RemoteObject::Type::Number,
        (size_t)Protocol::Runtime::RemoteObject::Type::Boolean,
        (size_t)Protocol::Runtime::RemoteObject::Type::Symbol,
        (size_t)Protocol::Runtime::RemoteObject::Type::Bigint,
    };
    for (size_t i = 0; i < 8; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Runtime::RemoteObject::Type)constantValues[i];

    return std::nullopt;
}
template<> std::optional<Protocol::Runtime::RemoteObject::Subtype> parseEnumValueFromString<Protocol::Runtime::RemoteObject::Subtype>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Array,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Null,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Node,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Regexp,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Date,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Error,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Map,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Set,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Weakmap,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Weakset,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Iterator,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Class,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Proxy,
        (size_t)Protocol::Runtime::RemoteObject::Subtype::Weakref,
    };
    for (size_t i = 0; i < 14; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Runtime::RemoteObject::Subtype)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Runtime::ObjectPreview::Type> parseEnumValueFromString<Protocol::Runtime::ObjectPreview::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Runtime::ObjectPreview::Type::Object,
        (size_t)Protocol::Runtime::ObjectPreview::Type::Function,
        (size_t)Protocol::Runtime::ObjectPreview::Type::Undefined,
        (size_t)Protocol::Runtime::ObjectPreview::Type::String,
        (size_t)Protocol::Runtime::ObjectPreview::Type::Number,
        (size_t)Protocol::Runtime::ObjectPreview::Type::Boolean,
        (size_t)Protocol::Runtime::ObjectPreview::Type::Symbol,
        (size_t)Protocol::Runtime::ObjectPreview::Type::Bigint,
    };
    for (size_t i = 0; i < 8; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Runtime::ObjectPreview::Type)constantValues[i];

    return std::nullopt;
}
template<> std::optional<Protocol::Runtime::ObjectPreview::Subtype> parseEnumValueFromString<Protocol::Runtime::ObjectPreview::Subtype>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Array,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Null,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Node,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Regexp,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Date,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Error,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Map,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Set,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Weakmap,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Weakset,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Iterator,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Class,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Proxy,
        (size_t)Protocol::Runtime::ObjectPreview::Subtype::Weakref,
    };
    for (size_t i = 0; i < 14; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Runtime::ObjectPreview::Subtype)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Runtime::PropertyPreview::Type> parseEnumValueFromString<Protocol::Runtime::PropertyPreview::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Runtime::PropertyPreview::Type::Object,
        (size_t)Protocol::Runtime::PropertyPreview::Type::Function,
        (size_t)Protocol::Runtime::PropertyPreview::Type::Undefined,
        (size_t)Protocol::Runtime::PropertyPreview::Type::String,
        (size_t)Protocol::Runtime::PropertyPreview::Type::Number,
        (size_t)Protocol::Runtime::PropertyPreview::Type::Boolean,
        (size_t)Protocol::Runtime::PropertyPreview::Type::Symbol,
        (size_t)Protocol::Runtime::PropertyPreview::Type::Bigint,
        (size_t)Protocol::Runtime::PropertyPreview::Type::Accessor,
    };
    for (size_t i = 0; i < 9; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Runtime::PropertyPreview::Type)constantValues[i];

    return std::nullopt;
}
template<> std::optional<Protocol::Runtime::PropertyPreview::Subtype> parseEnumValueFromString<Protocol::Runtime::PropertyPreview::Subtype>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Array,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Null,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Node,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Regexp,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Date,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Error,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Map,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Set,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Weakmap,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Weakset,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Iterator,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Class,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Proxy,
        (size_t)Protocol::Runtime::PropertyPreview::Subtype::Weakref,
    };
    for (size_t i = 0; i < 14; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Runtime::PropertyPreview::Subtype)constantValues[i];

    return std::nullopt;
}

// Enums in the 'ScriptProfiler' Domain

template<> std::optional<Protocol::ScriptProfiler::EventType> parseEnumValueFromString<Protocol::ScriptProfiler::EventType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::ScriptProfiler::EventType::API,
        (size_t)Protocol::ScriptProfiler::EventType::Microtask,
        (size_t)Protocol::ScriptProfiler::EventType::Other,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::ScriptProfiler::EventType)constantValues[i];

    return std::nullopt;
}

// Enums in the 'Target' Domain

template<> std::optional<Protocol::Target::TargetInfo::Type> parseEnumValueFromString<Protocol::Target::TargetInfo::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Target::TargetInfo::Type::Page,
        (size_t)Protocol::Target::TargetInfo::Type::ServiceWorker,
        (size_t)Protocol::Target::TargetInfo::Type::Worker,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Target::TargetInfo::Type)constantValues[i];

    return std::nullopt;
}

// Enums in the 'Timeline' Domain

template<> std::optional<Protocol::Timeline::EventType> parseEnumValueFromString<Protocol::Timeline::EventType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Timeline::EventType::EventDispatch,
        (size_t)Protocol::Timeline::EventType::ScheduleStyleRecalculation,
        (size_t)Protocol::Timeline::EventType::RecalculateStyles,
        (size_t)Protocol::Timeline::EventType::InvalidateLayout,
        (size_t)Protocol::Timeline::EventType::Layout,
        (size_t)Protocol::Timeline::EventType::Paint,
        (size_t)Protocol::Timeline::EventType::Composite,
        (size_t)Protocol::Timeline::EventType::RenderingFrame,
        (size_t)Protocol::Timeline::EventType::TimerInstall,
        (size_t)Protocol::Timeline::EventType::TimerRemove,
        (size_t)Protocol::Timeline::EventType::TimerFire,
        (size_t)Protocol::Timeline::EventType::EvaluateScript,
        (size_t)Protocol::Timeline::EventType::TimeStamp,
        (size_t)Protocol::Timeline::EventType::Time,
        (size_t)Protocol::Timeline::EventType::TimeEnd,
        (size_t)Protocol::Timeline::EventType::FunctionCall,
        (size_t)Protocol::Timeline::EventType::ProbeSample,
        (size_t)Protocol::Timeline::EventType::ConsoleProfile,
        (size_t)Protocol::Timeline::EventType::RequestAnimationFrame,
        (size_t)Protocol::Timeline::EventType::CancelAnimationFrame,
        (size_t)Protocol::Timeline::EventType::FireAnimationFrame,
        (size_t)Protocol::Timeline::EventType::ObserverCallback,
        (size_t)Protocol::Timeline::EventType::Screenshot,
    };
    for (size_t i = 0; i < 23; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Timeline::EventType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Timeline::Instrument> parseEnumValueFromString<Protocol::Timeline::Instrument>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Timeline::Instrument::ScriptProfiler,
        (size_t)Protocol::Timeline::Instrument::Timeline,
        (size_t)Protocol::Timeline::Instrument::CPU,
        (size_t)Protocol::Timeline::Instrument::Memory,
        (size_t)Protocol::Timeline::Instrument::Heap,
        (size_t)Protocol::Timeline::Instrument::Animation,
        (size_t)Protocol::Timeline::Instrument::Screenshot,
    };
    for (size_t i = 0; i < 7; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Timeline::Instrument)constantValues[i];

    return std::nullopt;
}

} // namespace Helpers

const ASCIILiteral Protocol::CSS::CSSProperty::parsedOkKey = "parsedOk"_s;
const ASCIILiteral Protocol::CSS::CSSProperty::priorityKey = "priority"_s;
const ASCIILiteral Protocol::CSS::CSSProperty::statusKey = "status"_s;
const ASCIILiteral Protocol::DOM::RGBAColor::aKey = "a"_s;
const ASCIILiteral Protocol::DOM::RGBAColor::bKey = "b"_s;
const ASCIILiteral Protocol::DOM::RGBAColor::gKey = "g"_s;
const ASCIILiteral Protocol::DOM::RGBAColor::rKey = "r"_s;
const ASCIILiteral Protocol::DOM::HighlightConfig::borderColorKey = "borderColor"_s;
const ASCIILiteral Protocol::DOM::HighlightConfig::contentColorKey = "contentColor"_s;
const ASCIILiteral Protocol::DOM::HighlightConfig::marginColorKey = "marginColor"_s;
const ASCIILiteral Protocol::DOM::HighlightConfig::paddingColorKey = "paddingColor"_s;
const ASCIILiteral Protocol::DOM::HighlightConfig::showInfoKey = "showInfo"_s;
const ASCIILiteral Protocol::DOM::GridOverlayConfig::gridColorKey = "gridColor"_s;
const ASCIILiteral Protocol::DOM::GridOverlayConfig::showAreaNamesKey = "showAreaNames"_s;
const ASCIILiteral Protocol::DOM::GridOverlayConfig::showExtendedGridLinesKey = "showExtendedGridLines"_s;
const ASCIILiteral Protocol::DOM::GridOverlayConfig::showLineNamesKey = "showLineNames"_s;
const ASCIILiteral Protocol::DOM::GridOverlayConfig::showLineNumbersKey = "showLineNumbers"_s;
const ASCIILiteral Protocol::DOM::GridOverlayConfig::showTrackSizesKey = "showTrackSizes"_s;
const ASCIILiteral Protocol::DOM::FlexOverlayConfig::flexColorKey = "flexColor"_s;
const ASCIILiteral Protocol::DOM::FlexOverlayConfig::showOrderNumbersKey = "showOrderNumbers"_s;
const ASCIILiteral Protocol::DOMStorage::StorageId::isLocalStorageKey = "isLocalStorage"_s;
const ASCIILiteral Protocol::DOMStorage::StorageId::securityOriginKey = "securityOrigin"_s;
const ASCIILiteral Protocol::Debugger::Location::columnNumberKey = "columnNumber"_s;
const ASCIILiteral Protocol::Debugger::Location::lineNumberKey = "lineNumber"_s;
const ASCIILiteral Protocol::Debugger::Location::scriptIdKey = "scriptId"_s;
const ASCIILiteral Protocol::Debugger::BreakpointAction::dataKey = "data"_s;
const ASCIILiteral Protocol::Debugger::BreakpointAction::emulateUserGestureKey = "emulateUserGesture"_s;
const ASCIILiteral Protocol::Debugger::BreakpointAction::idKey = "id"_s;
const ASCIILiteral Protocol::Debugger::BreakpointAction::typeKey = "type"_s;
const ASCIILiteral Protocol::Debugger::BreakpointOptions::actionsKey = "actions"_s;
const ASCIILiteral Protocol::Debugger::BreakpointOptions::autoContinueKey = "autoContinue"_s;
const ASCIILiteral Protocol::Debugger::BreakpointOptions::conditionKey = "condition"_s;
const ASCIILiteral Protocol::Debugger::BreakpointOptions::ignoreCountKey = "ignoreCount"_s;
const ASCIILiteral Protocol::IndexedDB::Key::arrayKey = "array"_s;
const ASCIILiteral Protocol::IndexedDB::Key::dateKey = "date"_s;
const ASCIILiteral Protocol::IndexedDB::Key::numberKey = "number"_s;
const ASCIILiteral Protocol::IndexedDB::Key::stringKey = "string"_s;
const ASCIILiteral Protocol::IndexedDB::Key::typeKey = "type"_s;
const ASCIILiteral Protocol::IndexedDB::KeyRange::lowerKey = "lower"_s;
const ASCIILiteral Protocol::IndexedDB::KeyRange::lowerOpenKey = "lowerOpen"_s;
const ASCIILiteral Protocol::IndexedDB::KeyRange::upperKey = "upper"_s;
const ASCIILiteral Protocol::IndexedDB::KeyRange::upperOpenKey = "upperOpen"_s;
const ASCIILiteral Protocol::Network::Response::mimeTypeKey = "mimeType"_s;
const ASCIILiteral Protocol::Network::Response::sourceKey = "source"_s;
const ASCIILiteral Protocol::Network::Response::statusKey = "status"_s;
const ASCIILiteral Protocol::Network::Response::statusTextKey = "statusText"_s;
const ASCIILiteral Protocol::Page::Cookie::domainKey = "domain"_s;
const ASCIILiteral Protocol::Page::Cookie::expiresKey = "expires"_s;
const ASCIILiteral Protocol::Page::Cookie::httpOnlyKey = "httpOnly"_s;
const ASCIILiteral Protocol::Page::Cookie::nameKey = "name"_s;
const ASCIILiteral Protocol::Page::Cookie::pathKey = "path"_s;
const ASCIILiteral Protocol::Page::Cookie::sameSiteKey = "sameSite"_s;
const ASCIILiteral Protocol::Page::Cookie::secureKey = "secure"_s;
const ASCIILiteral Protocol::Page::Cookie::sessionKey = "session"_s;
const ASCIILiteral Protocol::Page::Cookie::valueKey = "value"_s;
const ASCIILiteral Protocol::Runtime::CallArgument::objectIdKey = "objectId"_s;
const ASCIILiteral Protocol::Runtime::TypeLocation::divotKey = "divot"_s;
const ASCIILiteral Protocol::Runtime::TypeLocation::sourceIDKey = "sourceID"_s;
const ASCIILiteral Protocol::Runtime::TypeLocation::typeInformationDescriptorKey = "typeInformationDescriptor"_s;
const ASCIILiteral Protocol::Timeline::TimelineEvent::childrenKey = "children"_s;
const ASCIILiteral Protocol::Timeline::TimelineEvent::dataKey = "data"_s;
const ASCIILiteral Protocol::Timeline::TimelineEvent::typeKey = "type"_s;

void BindingTraits<Protocol::Debugger::Location>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto scriptIdPos = object->find("scriptId"_s);
        ASSERT(scriptIdPos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(scriptIdPos->value.ptr());
    }
    {
        auto lineNumberPos = object->find("lineNumber"_s);
        ASSERT(lineNumberPos != object->end());
        BindingTraits<int>::assertValueHasExpectedType(lineNumberPos->value.ptr());
    }
    {
        auto columnNumberPos = object->find("columnNumber"_s);
        if (columnNumberPos != object->end()) {
            BindingTraits<int>::assertValueHasExpectedType(columnNumberPos->value.ptr());
        }
    }
#endif
}

void BindingTraits<Protocol::Debugger::FunctionDetails>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto locationPos = object->find("location"_s);
        ASSERT(locationPos != object->end());
        BindingTraits<Protocol::Debugger::Location>::assertValueHasExpectedType(locationPos->value.ptr());
    }

    size_t foundPropertiesCount = 1;
    {
        auto namePos = object->find("name"_s);
        if (namePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(namePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto displayNamePos = object->find("displayName"_s);
        if (displayNamePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(displayNamePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto scopeChainPos = object->find("scopeChain"_s);
        if (scopeChainPos != object->end()) {
            BindingTraits<JSON::ArrayOf<Protocol::Debugger::Scope>>::assertValueHasExpectedType(scopeChainPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

Ref<Protocol::Debugger::FunctionDetails> BindingTraits<Protocol::Debugger::FunctionDetails>::runtimeCast(Ref<JSON::Value>&& value)
{
    auto result = value->asObject();
    BindingTraits<Protocol::Debugger::FunctionDetails>::assertValueHasExpectedType(result.get());
    static_assert(sizeof(Protocol::Debugger::FunctionDetails) == sizeof(JSON::ObjectBase), "type cast problem");
    return static_reference_cast<Protocol::Debugger::FunctionDetails>(static_reference_cast<JSON::ObjectBase>(result.releaseNonNull()));
}


void BindingTraits<Protocol::Debugger::CallFrame>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto callFrameIdPos = object->find("callFrameId"_s);
        ASSERT(callFrameIdPos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(callFrameIdPos->value.ptr());
    }
    {
        auto functionNamePos = object->find("functionName"_s);
        ASSERT(functionNamePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(functionNamePos->value.ptr());
    }
    {
        auto locationPos = object->find("location"_s);
        ASSERT(locationPos != object->end());
        BindingTraits<Protocol::Debugger::Location>::assertValueHasExpectedType(locationPos->value.ptr());
    }
    {
        auto scopeChainPos = object->find("scopeChain"_s);
        ASSERT(scopeChainPos != object->end());
        BindingTraits<JSON::ArrayOf<Protocol::Debugger::Scope>>::assertValueHasExpectedType(scopeChainPos->value.ptr());
    }
    {
        auto thisPos = object->find("this"_s);
        ASSERT(thisPos != object->end());
        BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(thisPos->value.ptr());
    }
    {
        auto isTailDeletedPos = object->find("isTailDeleted"_s);
        ASSERT(isTailDeletedPos != object->end());
        BindingTraits<bool>::assertValueHasExpectedType(isTailDeletedPos->value.ptr());
    }

    size_t foundPropertiesCount = 6;
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

Ref<Protocol::Debugger::CallFrame> BindingTraits<Protocol::Debugger::CallFrame>::runtimeCast(Ref<JSON::Value>&& value)
{
    auto result = value->asObject();
    BindingTraits<Protocol::Debugger::CallFrame>::assertValueHasExpectedType(result.get());
    static_assert(sizeof(Protocol::Debugger::CallFrame) == sizeof(JSON::ObjectBase), "type cast problem");
    return static_reference_cast<Protocol::Debugger::CallFrame>(static_reference_cast<JSON::ObjectBase>(result.releaseNonNull()));
}


void BindingTraits<Protocol::Debugger::Scope::Type>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto result = value->asString();
    ASSERT(result);
    ASSERT(result == "global"_s || result == "with"_s || result == "closure"_s || result == "catch"_s || result == "functionName"_s || result == "globalLexicalEnvironment"_s || result == "nestedLexical"_s);
#endif
}

void BindingTraits<Protocol::Debugger::Scope>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto objectPos = object->find("object"_s);
        ASSERT(objectPos != object->end());
        BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(objectPos->value.ptr());
    }
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Protocol::Debugger::Scope::Type>::assertValueHasExpectedType(typePos->value.ptr());
    }

    size_t foundPropertiesCount = 2;
    {
        auto namePos = object->find("name"_s);
        if (namePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(namePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto locationPos = object->find("location"_s);
        if (locationPos != object->end()) {
            BindingTraits<Protocol::Debugger::Location>::assertValueHasExpectedType(locationPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto emptyPos = object->find("empty"_s);
        if (emptyPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(emptyPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

void BindingTraits<Protocol::Runtime::RemoteObject::Type>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto result = value->asString();
    ASSERT(result);
    ASSERT(result == "object"_s || result == "function"_s || result == "undefined"_s || result == "string"_s || result == "number"_s || result == "boolean"_s || result == "symbol"_s || result == "bigint"_s);
#endif
}

void BindingTraits<Protocol::Runtime::RemoteObject::Subtype>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto result = value->asString();
    ASSERT(result);
    ASSERT(result == "array"_s || result == "null"_s || result == "node"_s || result == "regexp"_s || result == "date"_s || result == "error"_s || result == "map"_s || result == "set"_s || result == "weakmap"_s || result == "weakset"_s || result == "iterator"_s || result == "class"_s || result == "proxy"_s || result == "weakref"_s);
#endif
}

void BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Protocol::Runtime::RemoteObject::Type>::assertValueHasExpectedType(typePos->value.ptr());
    }

    size_t foundPropertiesCount = 1;
    {
        auto subtypePos = object->find("subtype"_s);
        if (subtypePos != object->end()) {
            BindingTraits<Protocol::Runtime::RemoteObject::Subtype>::assertValueHasExpectedType(subtypePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto classNamePos = object->find("className"_s);
        if (classNamePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(classNamePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto valuePos = object->find("value"_s);
        if (valuePos != object->end()) {
            BindingTraits<JSON::Value>::assertValueHasExpectedType(valuePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto descriptionPos = object->find("description"_s);
        if (descriptionPos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(descriptionPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto objectIdPos = object->find("objectId"_s);
        if (objectIdPos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(objectIdPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto sizePos = object->find("size"_s);
        if (sizePos != object->end()) {
            BindingTraits<int>::assertValueHasExpectedType(sizePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto classPrototypePos = object->find("classPrototype"_s);
        if (classPrototypePos != object->end()) {
            BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(classPrototypePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto previewPos = object->find("preview"_s);
        if (previewPos != object->end()) {
            BindingTraits<Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(previewPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

Ref<Protocol::Runtime::RemoteObject> BindingTraits<Protocol::Runtime::RemoteObject>::runtimeCast(Ref<JSON::Value>&& value)
{
    auto result = value->asObject();
    BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(result.get());
    static_assert(sizeof(Protocol::Runtime::RemoteObject) == sizeof(JSON::ObjectBase), "type cast problem");
    return static_reference_cast<Protocol::Runtime::RemoteObject>(static_reference_cast<JSON::ObjectBase>(result.releaseNonNull()));
}


void BindingTraits<Protocol::Runtime::ObjectPreview::Type>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto result = value->asString();
    ASSERT(result);
    ASSERT(result == "object"_s || result == "function"_s || result == "undefined"_s || result == "string"_s || result == "number"_s || result == "boolean"_s || result == "symbol"_s || result == "bigint"_s);
#endif
}

void BindingTraits<Protocol::Runtime::ObjectPreview::Subtype>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto result = value->asString();
    ASSERT(result);
    ASSERT(result == "array"_s || result == "null"_s || result == "node"_s || result == "regexp"_s || result == "date"_s || result == "error"_s || result == "map"_s || result == "set"_s || result == "weakmap"_s || result == "weakset"_s || result == "iterator"_s || result == "class"_s || result == "proxy"_s || result == "weakref"_s);
#endif
}

void BindingTraits<Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Protocol::Runtime::ObjectPreview::Type>::assertValueHasExpectedType(typePos->value.ptr());
    }
    {
        auto losslessPos = object->find("lossless"_s);
        ASSERT(losslessPos != object->end());
        BindingTraits<bool>::assertValueHasExpectedType(losslessPos->value.ptr());
    }

    size_t foundPropertiesCount = 2;
    {
        auto subtypePos = object->find("subtype"_s);
        if (subtypePos != object->end()) {
            BindingTraits<Protocol::Runtime::ObjectPreview::Subtype>::assertValueHasExpectedType(subtypePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto descriptionPos = object->find("description"_s);
        if (descriptionPos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(descriptionPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto overflowPos = object->find("overflow"_s);
        if (overflowPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(overflowPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto propertiesPos = object->find("properties"_s);
        if (propertiesPos != object->end()) {
            BindingTraits<JSON::ArrayOf<Protocol::Runtime::PropertyPreview>>::assertValueHasExpectedType(propertiesPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto entriesPos = object->find("entries"_s);
        if (entriesPos != object->end()) {
            BindingTraits<JSON::ArrayOf<Protocol::Runtime::EntryPreview>>::assertValueHasExpectedType(entriesPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto sizePos = object->find("size"_s);
        if (sizePos != object->end()) {
            BindingTraits<int>::assertValueHasExpectedType(sizePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

Ref<Protocol::Runtime::ObjectPreview> BindingTraits<Protocol::Runtime::ObjectPreview>::runtimeCast(Ref<JSON::Value>&& value)
{
    auto result = value->asObject();
    BindingTraits<Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(result.get());
    static_assert(sizeof(Protocol::Runtime::ObjectPreview) == sizeof(JSON::ObjectBase), "type cast problem");
    return static_reference_cast<Protocol::Runtime::ObjectPreview>(static_reference_cast<JSON::ObjectBase>(result.releaseNonNull()));
}


void BindingTraits<Protocol::Runtime::PropertyPreview::Type>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto result = value->asString();
    ASSERT(result);
    ASSERT(result == "object"_s || result == "function"_s || result == "undefined"_s || result == "string"_s || result == "number"_s || result == "boolean"_s || result == "symbol"_s || result == "bigint"_s || result == "accessor"_s);
#endif
}

void BindingTraits<Protocol::Runtime::PropertyPreview::Subtype>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto result = value->asString();
    ASSERT(result);
    ASSERT(result == "array"_s || result == "null"_s || result == "node"_s || result == "regexp"_s || result == "date"_s || result == "error"_s || result == "map"_s || result == "set"_s || result == "weakmap"_s || result == "weakset"_s || result == "iterator"_s || result == "class"_s || result == "proxy"_s || result == "weakref"_s);
#endif
}

void BindingTraits<Protocol::Runtime::PropertyPreview>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto namePos = object->find("name"_s);
        ASSERT(namePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(namePos->value.ptr());
    }
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Protocol::Runtime::PropertyPreview::Type>::assertValueHasExpectedType(typePos->value.ptr());
    }

    size_t foundPropertiesCount = 2;
    {
        auto subtypePos = object->find("subtype"_s);
        if (subtypePos != object->end()) {
            BindingTraits<Protocol::Runtime::PropertyPreview::Subtype>::assertValueHasExpectedType(subtypePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto valuePos = object->find("value"_s);
        if (valuePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(valuePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto valuePreviewPos = object->find("valuePreview"_s);
        if (valuePreviewPos != object->end()) {
            BindingTraits<Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(valuePreviewPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto isPrivatePos = object->find("isPrivate"_s);
        if (isPrivatePos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(isPrivatePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto internalPos = object->find("internal"_s);
        if (internalPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(internalPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

void BindingTraits<Protocol::Runtime::EntryPreview>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto valuePos = object->find("value"_s);
        ASSERT(valuePos != object->end());
        BindingTraits<Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(valuePos->value.ptr());
    }

    size_t foundPropertiesCount = 1;
    {
        auto keyPos = object->find("key"_s);
        if (keyPos != object->end()) {
            BindingTraits<Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(keyPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

void BindingTraits<Protocol::Runtime::CollectionEntry>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto valuePos = object->find("value"_s);
        ASSERT(valuePos != object->end());
        BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(valuePos->value.ptr());
    }

    size_t foundPropertiesCount = 1;
    {
        auto keyPos = object->find("key"_s);
        if (keyPos != object->end()) {
            BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(keyPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

Ref<Protocol::Runtime::CollectionEntry> BindingTraits<Protocol::Runtime::CollectionEntry>::runtimeCast(Ref<JSON::Value>&& value)
{
    auto result = value->asObject();
    BindingTraits<Protocol::Runtime::CollectionEntry>::assertValueHasExpectedType(result.get());
    static_assert(sizeof(Protocol::Runtime::CollectionEntry) == sizeof(JSON::ObjectBase), "type cast problem");
    return static_reference_cast<Protocol::Runtime::CollectionEntry>(static_reference_cast<JSON::ObjectBase>(result.releaseNonNull()));
}


void BindingTraits<Protocol::Runtime::PropertyDescriptor>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto namePos = object->find("name"_s);
        ASSERT(namePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(namePos->value.ptr());
    }

    size_t foundPropertiesCount = 1;
    {
        auto valuePos = object->find("value"_s);
        if (valuePos != object->end()) {
            BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(valuePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto writablePos = object->find("writable"_s);
        if (writablePos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(writablePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto getPos = object->find("get"_s);
        if (getPos != object->end()) {
            BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(getPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto setPos = object->find("set"_s);
        if (setPos != object->end()) {
            BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(setPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto wasThrownPos = object->find("wasThrown"_s);
        if (wasThrownPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(wasThrownPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto configurablePos = object->find("configurable"_s);
        if (configurablePos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(configurablePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto enumerablePos = object->find("enumerable"_s);
        if (enumerablePos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(enumerablePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto isOwnPos = object->find("isOwn"_s);
        if (isOwnPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(isOwnPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto symbolPos = object->find("symbol"_s);
        if (symbolPos != object->end()) {
            BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(symbolPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto isPrivatePos = object->find("isPrivate"_s);
        if (isPrivatePos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(isPrivatePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    {
        auto nativeGetterPos = object->find("nativeGetter"_s);
        if (nativeGetterPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(nativeGetterPos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

Ref<Protocol::Runtime::PropertyDescriptor> BindingTraits<Protocol::Runtime::PropertyDescriptor>::runtimeCast(Ref<JSON::Value>&& value)
{
    auto result = value->asObject();
    BindingTraits<Protocol::Runtime::PropertyDescriptor>::assertValueHasExpectedType(result.get());
    static_assert(sizeof(Protocol::Runtime::PropertyDescriptor) == sizeof(JSON::ObjectBase), "type cast problem");
    return static_reference_cast<Protocol::Runtime::PropertyDescriptor>(static_reference_cast<JSON::ObjectBase>(result.releaseNonNull()));
}


void BindingTraits<Protocol::Runtime::InternalPropertyDescriptor>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto namePos = object->find("name"_s);
        ASSERT(namePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(namePos->value.ptr());
    }

    size_t foundPropertiesCount = 1;
    {
        auto valuePos = object->find("value"_s);
        if (valuePos != object->end()) {
            BindingTraits<Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(valuePos->value.ptr());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#endif
}

Ref<Protocol::Runtime::InternalPropertyDescriptor> BindingTraits<Protocol::Runtime::InternalPropertyDescriptor>::runtimeCast(Ref<JSON::Value>&& value)
{
    auto result = value->asObject();
    BindingTraits<Protocol::Runtime::InternalPropertyDescriptor>::assertValueHasExpectedType(result.get());
    static_assert(sizeof(Protocol::Runtime::InternalPropertyDescriptor) == sizeof(JSON::ObjectBase), "type cast problem");
    return static_reference_cast<Protocol::Runtime::InternalPropertyDescriptor>(static_reference_cast<JSON::ObjectBase>(result.releaseNonNull()));
}


void BindingTraits<Protocol::Timeline::EventType>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto result = value->asString();
    ASSERT(result);
    ASSERT(result == "EventDispatch"_s || result == "ScheduleStyleRecalculation"_s || result == "RecalculateStyles"_s || result == "InvalidateLayout"_s || result == "Layout"_s || result == "Paint"_s || result == "Composite"_s || result == "RenderingFrame"_s || result == "TimerInstall"_s || result == "TimerRemove"_s || result == "TimerFire"_s || result == "EvaluateScript"_s || result == "TimeStamp"_s || result == "Time"_s || result == "TimeEnd"_s || result == "FunctionCall"_s || result == "ProbeSample"_s || result == "ConsoleProfile"_s || result == "RequestAnimationFrame"_s || result == "CancelAnimationFrame"_s || result == "FireAnimationFrame"_s || result == "ObserverCallback"_s || result == "Screenshot"_s);
#endif
}

void BindingTraits<Protocol::Timeline::TimelineEvent>::assertValueHasExpectedType(JSON::Value* value)
{
    ASSERT_UNUSED(value, value);
#if ASSERT_ENABLED
    auto object = value->asObject();
    ASSERT(object);
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Protocol::Timeline::EventType>::assertValueHasExpectedType(typePos->value.ptr());
    }
    {
        auto dataPos = object->find("data"_s);
        ASSERT(dataPos != object->end());
        BindingTraits<JSON::Object>::assertValueHasExpectedType(dataPos->value.ptr());
    }
    {
        auto childrenPos = object->find("children"_s);
        if (childrenPos != object->end()) {
            BindingTraits<JSON::ArrayOf<Protocol::Timeline::TimelineEvent>>::assertValueHasExpectedType(childrenPos->value.ptr());
        }
    }
#endif
}

Ref<Protocol::Timeline::TimelineEvent> BindingTraits<Protocol::Timeline::TimelineEvent>::runtimeCast(Ref<JSON::Value>&& value)
{
    auto result = value->asObject();
    BindingTraits<Protocol::Timeline::TimelineEvent>::assertValueHasExpectedType(result.get());
    static_assert(sizeof(Protocol::Timeline::TimelineEvent) == sizeof(JSON::ObjectBase), "type cast problem");
    return static_reference_cast<Protocol::Timeline::TimelineEvent>(static_reference_cast<JSON::ObjectBase>(result.releaseNonNull()));
}


} // namespace Protocol

} // namespace Inspector
