/*
 * Copyright (C) 2021-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "ViewGestureGeometryCollector.h"

#include "Decoder.h" // NOLINT
#include "HandleMessage.h" // NOLINT
#include "ViewGestureGeometryCollectorMessages.h" // NOLINT
#if PLATFORM(COCOA)
#include "WebCoreArgumentCoders.h" // NOLINT
#endif
#if PLATFORM(COCOA)
#include <WebCore/FloatPoint.h> // NOLINT
#endif

#if ENABLE(IPC_TESTING_API)
#include "JSIPCBinding.h"
#endif

namespace WebKit {

void ViewGestureGeometryCollector::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
#if PLATFORM(COCOA)
    if (decoder.messageName() == Messages::ViewGestureGeometryCollector::CollectGeometryForSmartMagnificationGesture::name())
        return IPC::handleMessage<Messages::ViewGestureGeometryCollector::CollectGeometryForSmartMagnificationGesture>(connection, decoder, this, &ViewGestureGeometryCollector::collectGeometryForSmartMagnificationGesture);
#endif
#if !PLATFORM(IOS_FAMILY)
    if (decoder.messageName() == Messages::ViewGestureGeometryCollector::CollectGeometryForMagnificationGesture::name())
        return IPC::handleMessage<Messages::ViewGestureGeometryCollector::CollectGeometryForMagnificationGesture>(connection, decoder, this, &ViewGestureGeometryCollector::collectGeometryForMagnificationGesture);
    if (decoder.messageName() == Messages::ViewGestureGeometryCollector::SetRenderTreeSizeNotificationThreshold::name())
        return IPC::handleMessage<Messages::ViewGestureGeometryCollector::SetRenderTreeSizeNotificationThreshold>(connection, decoder, this, &ViewGestureGeometryCollector::setRenderTreeSizeNotificationThreshold);
#endif
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()), decoder.destinationID());
}

} // namespace WebKit

#if ENABLE(IPC_TESTING_API)

namespace IPC {

#if PLATFORM(COCOA)
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ViewGestureGeometryCollector_CollectGeometryForSmartMagnificationGesture>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ViewGestureGeometryCollector::CollectGeometryForSmartMagnificationGesture::Arguments>(globalObject, decoder);
}
#endif
#if !PLATFORM(IOS_FAMILY)
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ViewGestureGeometryCollector_CollectGeometryForMagnificationGesture>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ViewGestureGeometryCollector::CollectGeometryForMagnificationGesture::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ViewGestureGeometryCollector_SetRenderTreeSizeNotificationThreshold>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ViewGestureGeometryCollector::SetRenderTreeSizeNotificationThreshold::Arguments>(globalObject, decoder);
}
#endif

}

#endif

