/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

public class DiffOptions {
    private final int flags;

    public DiffOptions(Flag ... flagArray) {
        int n = 0;
        for (Flag flag : flagArray) {
            n |= flag.value;
        }
        this.flags = n;
    }

    public boolean getIgnoreWhitespace() {
        return 0 != (this.flags & Flag.IgnoreWhitespace.value);
    }

    public boolean getIgnoreSpaceChange() {
        return 0 != (this.flags & Flag.IgnoreSpaceChange.value);
    }

    public boolean getIgnoreEOLStyle() {
        return 0 != (this.flags & Flag.IgnoreEOLStyle.value);
    }

    public boolean getShowFunction() {
        return 0 != (this.flags & Flag.ShowFunction.value);
    }

    public boolean getGitFormat() {
        return 0 != (this.flags & Flag.GitFormat.value);
    }

    public static enum Flag {
        IgnoreWhitespace(1),
        IgnoreSpaceChange(2),
        IgnoreEOLStyle(4),
        ShowFunction(8),
        GitFormat(16);

        final int value;

        private Flag(int n2) {
            this.value = n2;
        }
    }
}

