/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.net.URI;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradleModuleMetadataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultUrlArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.MavenRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.maven.MavenMetadataLoader;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultMavenPomMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenLocalPomMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.caching.ImplicitInputsCapturingInstantiator;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMavenLocalArtifactRepository
extends DefaultMavenArtifactRepository
implements MavenArtifactRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenResolver.class);
    private final ChecksumService checksumService;

    public DefaultMavenLocalArtifactRepository(FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, InstantiatorFactory instantiatorFactory, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, GradleModuleMetadataParser metadataParser, AuthenticationContainer authenticationContainer, FileResourceRepository fileResourceRepository, MavenMutableModuleMetadataFactory metadataFactory, IsolatableFactory isolatableFactory, ObjectFactory objectFactory, DefaultUrlArtifactRepository.Factory urlArtifactRepositoryFactory, ChecksumService checksumService, VersionParser versionParser) {
        super(fileResolver, transportFactory, locallyAvailableResourceFinder, instantiatorFactory, artifactFileStore, pomParser, metadataParser, authenticationContainer, null, fileResourceRepository, metadataFactory, isolatableFactory, objectFactory, urlArtifactRepositoryFactory, checksumService, null, versionParser);
        this.checksumService = checksumService;
    }

    @Override
    public MavenResolver createResolver() {
        URI rootUri = this.validateUrl();
        RepositoryTransport transport = this.getTransport(rootUri.getScheme());
        MavenMetadataLoader mavenMetadataLoader = new MavenMetadataLoader(transport.getResourceAccessor(), this.getResourcesFileStore());
        ImplicitInputsCapturingInstantiator injector = this.createInjectorForMetadataSuppliers(transport, this.getInstantiatorFactory(), rootUri, this.getResourcesFileStore());
        return new MavenResolver((MavenRepositoryDescriptor)this.getDescriptor(), rootUri, transport, this.getLocallyAvailableResourceFinder(), this.getArtifactFileStore(), this.createMetadataSources(mavenMetadataLoader), MavenMetadataArtifactProvider.INSTANCE, mavenMetadataLoader, null, null, (Instantiator)injector, this.checksumService);
    }

    @Override
    protected DefaultMavenPomMetadataSource createPomMetadataSource(MavenMetadataLoader mavenMetadataLoader, FileResourceRepository fileResourceRepository) {
        return new MavenLocalPomMetadataSource(MavenMetadataArtifactProvider.INSTANCE, this.getPomParser(), fileResourceRepository, this.getMetadataValidationServices(), mavenMetadataLoader, this.checksumService);
    }

    @Override
    protected DefaultMavenPomMetadataSource.MavenMetadataValidator getMetadataValidationServices() {
        return new MavenLocalMetadataValidator();
    }

    private static class MavenLocalMetadataValidator
    implements DefaultMavenPomMetadataSource.MavenMetadataValidator {
        private MavenLocalMetadataValidator() {
        }

        @Override
        public boolean isUsableModule(String repoName, MutableMavenModuleResolveMetadata metaData, ExternalResourceArtifactResolver artifactResolver) {
            if (metaData.isPomPackaging()) {
                return true;
            }
            ModuleComponentArtifactMetadata artifact = metaData.isKnownJarPackaging() ? metaData.artifact("jar", "jar", null) : metaData.artifact(metaData.getPackaging(), metaData.getPackaging(), null);
            if (artifactResolver.artifactExists(artifact, new DefaultResourceAwareResolveResult())) {
                return true;
            }
            LOGGER.debug("POM file found for module '{}' in repository '{}' but no artifact found. Ignoring.", (Object)metaData.getModuleVersionId(), (Object)repoName);
            return false;
        }
    }
}

