/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.convert.RenameHandler;
import org.joda.convert.TypedStringConverter;

enum JDKStringConverter implements TypedStringConverter<Object>
{
    STRING((Class)String.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return str;
        }
    }
    ,
    CHAR_SEQUENCE((Class)CharSequence.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return str;
        }
    }
    ,
    STRING_BUFFER((Class)StringBuffer.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new StringBuffer(str);
        }
    }
    ,
    STRING_BUILDER((Class)StringBuilder.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new StringBuilder(str);
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Long.valueOf(str);
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Integer.valueOf(str);
        }
    }
    ,
    SHORT((Class)Short.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Short.valueOf(str);
        }
    }
    ,
    BYTE((Class)Byte.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Byte.valueOf(str);
        }
    }
    ,
    BYTE_ARRAY((Class)byte[].class){

        @Override
        public String convertToString(Object object) {
            return JDKStringConverter.printBase64Binary((byte[])object);
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return JDKStringConverter.parseBase64Binary(str);
        }
    }
    ,
    CHARACTER((Class)Character.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if (str.length() != 1) {
                throw new IllegalArgumentException("Character value must be a string length 1");
            }
            return Character.valueOf(str.charAt(0));
        }
    }
    ,
    CHAR_ARRAY((Class)char[].class){

        @Override
        public String convertToString(Object object) {
            return new String((char[])object);
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return str.toCharArray();
        }
    }
    ,
    BOOLEAN((Class)Boolean.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if ("true".equalsIgnoreCase(str)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Double.valueOf(str);
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Float.valueOf(str);
        }
    }
    ,
    BIG_INTEGER((Class)BigInteger.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new BigInteger(str);
        }
    }
    ,
    BIG_DECIMAL((Class)BigDecimal.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new BigDecimal(str);
        }
    }
    ,
    ATOMIC_LONG((Class)AtomicLong.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            long val = Long.parseLong(str);
            return new AtomicLong(val);
        }
    }
    ,
    ATOMIC_INTEGER((Class)AtomicInteger.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            int val = Integer.parseInt(str);
            return new AtomicInteger(val);
        }
    }
    ,
    ATOMIC_BOOLEAN((Class)AtomicBoolean.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if ("true".equalsIgnoreCase(str)) {
                return new AtomicBoolean(true);
            }
            if ("false".equalsIgnoreCase(str)) {
                return new AtomicBoolean(false);
            }
            throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
        }
    }
    ,
    LOCALE((Class)Locale.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            String[] split = str.split("_", 3);
            switch (split.length) {
                case 1: {
                    return new Locale(split[0]);
                }
                case 2: {
                    return new Locale(split[0], split[1]);
                }
                case 3: {
                    return new Locale(split[0], split[1], split[2]);
                }
            }
            throw new IllegalArgumentException("Unable to parse Locale: " + str);
        }
    }
    ,
    CLASS((Class)Class.class){

        @Override
        public String convertToString(Object object) {
            return ((Class)object).getName();
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            try {
                return RenameHandler.INSTANCE.lookupType(str);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Unable to create type: " + str, ex);
            }
        }
    }
    ,
    PACKAGE((Class)Package.class){

        @Override
        public String convertToString(Object object) {
            return ((Package)object).getName();
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Package.getPackage(str);
        }
    }
    ,
    CURRENCY((Class)Currency.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Currency.getInstance(str);
        }
    }
    ,
    TIME_ZONE((Class)TimeZone.class){

        @Override
        public String convertToString(Object object) {
            return ((TimeZone)object).getID();
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return TimeZone.getTimeZone(str);
        }
    }
    ,
    UUID((Class)UUID.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return java.util.UUID.fromString(str);
        }
    }
    ,
    URL((Class)URL.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            try {
                return new URL(str);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }
    ,
    URI((Class)URI.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return java.net.URI.create(str);
        }
    }
    ,
    INET_ADDRESS((Class)InetAddress.class){

        @Override
        public String convertToString(Object object) {
            return ((InetAddress)object).getHostAddress();
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            try {
                return InetAddress.getByName(str);
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
    ,
    FILE((Class)File.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new File(str);
        }
    }
    ,
    DATE((Class)Date.class){

        @Override
        public String convertToString(Object object) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String str = f.format(object);
            return str.substring(0, 26) + ":" + str.substring(26);
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if (str.length() != 29) {
                throw new IllegalArgumentException("Unable to parse date: " + str);
            }
            String str2 = str.substring(0, 26) + str.substring(27);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            try {
                return f.parseObject(str2);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
    ,
    CALENDAR((Class)Calendar.class){

        @Override
        public String convertToString(Object object) {
            if (!(object instanceof GregorianCalendar)) {
                throw new RuntimeException("Unable to convert calendar as it is not a GregorianCalendar");
            }
            GregorianCalendar cal = (GregorianCalendar)object;
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            f.setCalendar(cal);
            String str = f.format(cal.getTime());
            return str.substring(0, 26) + ":" + str.substring(26) + "[" + cal.getTimeZone().getID() + "]";
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if (str.length() < 31 || str.charAt(26) != ':' || str.charAt(29) != '[' || str.charAt(str.length() - 1) != ']') {
                throw new IllegalArgumentException("Unable to parse date: " + str);
            }
            TimeZone zone = TimeZone.getTimeZone(str.substring(30, str.length() - 1));
            String str2 = str.substring(0, 26) + str.substring(27, 29);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            GregorianCalendar cal = new GregorianCalendar(zone);
            cal.setTimeInMillis(0L);
            f.setCalendar(cal);
            try {
                f.parseObject(str2);
                return f.getCalendar();
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
    };

    private Class<?> type;
    private static String base64Str;
    private static char[] base64Array;
    private static final int MASK_8BIT = 255;
    private static final int MASK_6BIT = 63;

    private JDKStringConverter(Class<?> type) {
        this.type = type;
    }

    Class<?> getType() {
        return this.type;
    }

    @Override
    public Class<?> getEffectiveType() {
        return this.type;
    }

    @Override
    public String convertToString(Object object) {
        return object.toString();
    }

    private static String printBase64Binary(byte[] array) {
        int len = array.length;
        char[] buf = new char[(len + 2) / 3 * 4];
        int pos = 0;
        for (int i = 0; i < len; i += 3) {
            int bits;
            int remaining = len - i;
            if (remaining >= 3) {
                bits = (array[i] & 0xFF) << 16 | (array[i + 1] & 0xFF) << 8 | array[i + 2] & 0xFF;
                buf[pos++] = base64Array[bits >>> 18 & 0x3F];
                buf[pos++] = base64Array[bits >>> 12 & 0x3F];
                buf[pos++] = base64Array[bits >>> 6 & 0x3F];
                buf[pos++] = base64Array[bits & 0x3F];
                continue;
            }
            if (remaining == 2) {
                bits = (array[i] & 0xFF) << 16 | (array[i + 1] & 0xFF) << 8;
                buf[pos++] = base64Array[bits >>> 18 & 0x3F];
                buf[pos++] = base64Array[bits >>> 12 & 0x3F];
                buf[pos++] = base64Array[bits >>> 6 & 0x3F];
                buf[pos++] = 61;
                continue;
            }
            bits = (array[i] & 0xFF) << 16;
            buf[pos++] = base64Array[bits >>> 18 & 0x3F];
            buf[pos++] = base64Array[bits >>> 12 & 0x3F];
            buf[pos++] = 61;
            buf[pos++] = 61;
        }
        return new String(buf);
    }

    private static byte[] parseBase64Binary(String str) {
        if (str.length() % 4 != 0) {
            throw new IllegalArgumentException("Invalid Base64 string");
        }
        int parsedLen = str.length() * 3 / 4;
        byte[] decoded = new byte[parsedLen];
        char[] inChars = str.toCharArray();
        int pos = 0;
        int i = 0;
        while (i < inChars.length) {
            int bits = (base64Str.indexOf(inChars[i++]) & 0x3F) << 18 | (base64Str.indexOf(inChars[i++]) & 0x3F) << 12 | (base64Str.indexOf(inChars[i++]) & 0x3F) << 6 | base64Str.indexOf(inChars[i++]) & 0x3F;
            decoded[pos++] = (byte)(bits >>> 16 & 0xFF);
            decoded[pos++] = (byte)(bits >>> 8 & 0xFF);
            decoded[pos++] = (byte)(bits & 0xFF);
        }
        if (str.endsWith("==")) {
            byte[] result2 = new byte[parsedLen - 2];
            System.arraycopy(decoded, 0, result2, 0, parsedLen - 2);
            return result2;
        }
        if (str.endsWith("=")) {
            byte[] result3 = new byte[parsedLen - 1];
            System.arraycopy(decoded, 0, result3, 0, parsedLen - 1);
            return result3;
        }
        return decoded;
    }

    static {
        base64Str = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        base64Array = base64Str.toCharArray();
    }
}

