#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hslua
version:              1.3.0.1
visibility:           public
id:                   hslua-1.3.0.1-KD3ebwQ5HMbCfq1Rgfo8gC
key:                  hslua-1.3.0.1-KD3ebwQ5HMbCfq1Rgfo8gC
license:              MIT
copyright:
    © 2007–2012 Gracjan Polak
    © 2012–2016 Ömer Sinan Ağacan
    © 2016–2020 Albert Krewinkel

maintainer:           albert+hslua@zeitkraut.de
author:               Gracjan Polak, Ömer Sinan Ağacan
homepage:             https://hslua.github.io/
synopsis:             Bindings to Lua, an embeddable scripting language
description:
    HsLua provides bindings, wrappers, types, and helper
    functions to bridge Haskell and <https://www.lua.org/ Lua>.

    This package contains a full Lua interpreter version 5.3.6.
    If you want to link it with a system-wide Lua installation,
    use the @system-lua@ flag.

    <https://github.com/hslua/hslua-examples Example programs>
    are available in a separate repository.

category:             Foreign
abi:                  b42d0354c90d0d2c9a93ca947f825ad5
exposed:              True
exposed-modules:
    Foreign.Lua Foreign.Lua.Call Foreign.Lua.Core
    Foreign.Lua.Core.Constants Foreign.Lua.Core.Error
    Foreign.Lua.Core.RawBindings Foreign.Lua.Core.Types
    Foreign.Lua.FunctionCalling Foreign.Lua.Module Foreign.Lua.Peek
    Foreign.Lua.Push Foreign.Lua.Raw.Auxiliary Foreign.Lua.Raw.Call
    Foreign.Lua.Raw.Constants Foreign.Lua.Raw.Error
    Foreign.Lua.Raw.Functions Foreign.Lua.Raw.Types
    Foreign.Lua.Raw.Userdata Foreign.Lua.Types
    Foreign.Lua.Types.Peekable Foreign.Lua.Types.Pushable
    Foreign.Lua.Userdata Foreign.Lua.Utf8 Foreign.Lua.Util

hidden-modules:       Foreign.Lua.Core.Auxiliary Foreign.Lua.Core.Functions
import-dirs:          /usr/lib/ghc-8.10.5/site-local/hslua-1.3.0.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hslua-1.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/hslua-1.3.0.1
hs-libraries:         HShslua-1.3.0.1-KD3ebwQ5HMbCfq1Rgfo8gC
extra-libraries:      lua5.3 m
include-dirs:         /usr/include/lua5.3
depends:
    base-4.14.2.0 bytestring-0.10.12.0 containers-0.6.4.1
    exceptions-0.10.4 mtl-2.2.2 text-1.2.4.1

ld-options:           "-Wl,-E"
haddock-interfaces:   /usr/share/doc/haskell-hslua/html/hslua.haddock
haddock-html:         /usr/share/doc/haskell-hslua/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

