"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getYamlValidation = exports.doValidate = void 0;
const interval_tree_1 = __importDefault(require("@flatten-js/interval-tree"));
const _ = __importStar(require("lodash"));
const vscode_languageserver_1 = require("vscode-languageserver");
const yaml_1 = require("../utils/yaml");
const commandRunner_1 = require("../utils/commandRunner");
/**
 * Validates the given document.
 * @param textDocument - the document to validate
 * @param linter - uses linter
 * @param quick - only re-evaluates YAML validation and uses lint cache
 * @returns Map of diagnostics per file.
 */
function doValidate(textDocument, validationManager, quick = true, context, connection) {
    return __awaiter(this, void 0, void 0, function* () {
        let diagnosticsByFile;
        if (quick || !context) {
            // get validation from cache
            diagnosticsByFile =
                validationManager.getValidationFromCache(textDocument.uri) ||
                    new Map();
        }
        else {
            // full validation with ansible-lint or ansible syntax-check (if ansible-lint is not installed or disabled)
            const settings = yield context.documentSettings.get(textDocument.uri);
            if (!settings.validation.enabled) {
                console.log("Validation disabled");
                // this is done to remove the cache as well
                const blankDiagnostics = new Map();
                blankDiagnostics.set(textDocument.uri, []);
                validationManager.processDiagnostics(textDocument.uri, blankDiagnostics);
                validationManager.cacheDiagnostics(textDocument.uri, blankDiagnostics);
                return blankDiagnostics;
            }
            // validation using ansible-lint
            if (settings.validation.lint.enabled) {
                const commandRunner = new commandRunner_1.CommandRunner(connection, context, settings);
                const lintExecutable = settings.executionEnvironment.enabled
                    ? "ansible-lint"
                    : settings.validation.lint.path;
                const lintAvailability = yield commandRunner.getExecutablePath(lintExecutable);
                console.debug("Path for lint: ", lintAvailability);
                if (lintAvailability) {
                    console.debug("Validating using ansible-lint");
                    diagnosticsByFile = yield context.ansibleLint.doValidate(textDocument);
                }
                else {
                    connection === null || connection === void 0 ? void 0 : connection.window.showErrorMessage("Ansible-lint is not available. Kindly check the path or disable validation using ansible-lint");
                }
            }
            // validate using ansible-playbook --syntax-check
            else {
                console.debug("Validating using ansible syntax-check");
                if ((0, yaml_1.isPlaybook)(textDocument)) {
                    console.debug("playbook file");
                    diagnosticsByFile = yield context.ansiblePlaybook.doValidate(textDocument);
                }
                else {
                    console.debug("non-playbook file");
                    diagnosticsByFile = new Map();
                }
            }
            if (!diagnosticsByFile.has(textDocument.uri)) {
                // In case there are no diagnostics for the file that triggered the
                // validation, set an empty array in order to clear the validation.
                diagnosticsByFile.set(textDocument.uri, []);
            }
            validationManager.cacheDiagnostics(textDocument.uri, diagnosticsByFile);
        }
        // attach quick validation for the inspected file
        for (const [fileUri, fileDiagnostics] of diagnosticsByFile) {
            if (textDocument.uri === fileUri) {
                fileDiagnostics.push(...getYamlValidation(textDocument));
            }
        }
        validationManager.processDiagnostics(textDocument.uri, diagnosticsByFile);
        return diagnosticsByFile;
    });
}
exports.doValidate = doValidate;
function getYamlValidation(textDocument) {
    const diagnostics = [];
    const yDocuments = (0, yaml_1.parseAllDocuments)(textDocument.getText(), {
        prettyErrors: false,
    });
    const rangeTree = new interval_tree_1.default();
    yDocuments.forEach((yDoc) => {
        yDoc.errors.forEach((error) => {
            var _a;
            const errorRange = error.range || ((_a = error.source) === null || _a === void 0 ? void 0 : _a.range);
            let range;
            if (errorRange) {
                const start = textDocument.positionAt(errorRange.origStart !== undefined
                    ? errorRange.origStart
                    : errorRange.start);
                const end = textDocument.positionAt(errorRange.origEnd !== undefined
                    ? errorRange.origEnd
                    : errorRange.end);
                range = vscode_languageserver_1.Range.create(start, end);
                let severity;
                switch (error.name) {
                    case "YAMLReferenceError":
                    case "YAMLSemanticError":
                    case "YAMLSyntaxError":
                        severity = vscode_languageserver_1.DiagnosticSeverity.Error;
                        break;
                    case "YAMLWarning":
                        severity = vscode_languageserver_1.DiagnosticSeverity.Warning;
                        break;
                    default:
                        severity = vscode_languageserver_1.DiagnosticSeverity.Information;
                        break;
                }
                rangeTree.insert([errorRange.start, errorRange.end], {
                    message: error.message,
                    range: range || vscode_languageserver_1.Range.create(0, 0, 0, 0),
                    severity: severity,
                    source: "Ansible [YAML]",
                });
            }
        });
    });
    rangeTree.forEach((range, diag) => {
        const searchResult = rangeTree.search(range);
        if (searchResult) {
            const allRangesAreEqual = searchResult.every((foundDiag) => {
                // (range start == range end) in case it has already been collapsed
                return (foundDiag.range.start === foundDiag.range.end ||
                    _.isEqual(foundDiag.range, diag.range));
            });
            if (!allRangesAreEqual) {
                // Prevent large error scopes hiding/obscuring other error scopes
                // In YAML this is very common in case of syntax errors
                const range = diag.range;
                diag.relatedInformation = [
                    vscode_languageserver_1.DiagnosticRelatedInformation.create(vscode_languageserver_1.Location.create(textDocument.uri, {
                        start: range.end,
                        end: range.end,
                    }), "the scope of this error ends here"),
                ];
                // collapse the range
                diag.range = {
                    start: range.start,
                    end: range.start,
                };
            }
        }
        diagnostics.push(diag);
    });
    return diagnostics;
}
exports.getYamlValidation = getYamlValidation;
//# sourceMappingURL=validationProvider.js.map