/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.endpointdiscovery;

import java.io.File;
import org.opensearch.notifications.core.repackage.com.amazonaws.annotation.SdkTestInternalApi;
import org.opensearch.notifications.core.repackage.com.amazonaws.auth.profile.internal.AllProfiles;
import org.opensearch.notifications.core.repackage.com.amazonaws.auth.profile.internal.AwsProfileNameLoader;
import org.opensearch.notifications.core.repackage.com.amazonaws.auth.profile.internal.BasicProfile;
import org.opensearch.notifications.core.repackage.com.amazonaws.auth.profile.internal.BasicProfileConfigLoader;
import org.opensearch.notifications.core.repackage.com.amazonaws.endpointdiscovery.EndpointDiscoveryProvider;
import org.opensearch.notifications.core.repackage.com.amazonaws.profile.path.AwsProfileFileLocationProvider;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.StringUtils;

public class AwsProfileEndpointDiscoveryProvider
implements EndpointDiscoveryProvider {
    private final String profileName;
    private final AwsProfileFileLocationProvider locationProvider;
    private final BasicProfileConfigLoader profileConfigLoader;

    public AwsProfileEndpointDiscoveryProvider() {
        this(AwsProfileNameLoader.INSTANCE.loadProfileName());
    }

    public AwsProfileEndpointDiscoveryProvider(String profileName) {
        this(profileName, AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER, BasicProfileConfigLoader.INSTANCE);
    }

    @SdkTestInternalApi
    AwsProfileEndpointDiscoveryProvider(String profileName, AwsProfileFileLocationProvider locationProvider, BasicProfileConfigLoader configLoader) {
        this.profileName = profileName;
        this.locationProvider = locationProvider;
        this.profileConfigLoader = configLoader;
    }

    @Override
    public Boolean endpointDiscoveryEnabled() {
        BasicProfile profile;
        Boolean endpointDiscoveryEnabled = null;
        File configFile = this.locationProvider.getLocation();
        if (configFile != null && configFile.exists() && (profile = this.loadProfile(configFile)) != null && !StringUtils.isNullOrEmpty(profile.getEndpointDiscovery())) {
            try {
                endpointDiscoveryEnabled = Boolean.parseBoolean(profile.getEndpointDiscovery());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to parse value for aws_enable_endpoint_discovery");
            }
        }
        return endpointDiscoveryEnabled;
    }

    private BasicProfile loadProfile(File configFile) {
        AllProfiles allProfiles = this.profileConfigLoader.loadProfiles(configFile);
        return allProfiles.getProfile(this.profileName);
    }
}

