/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationMappingImpl;
import org.apache.catalina.mapper.MappingData;

public class ApplicationMapping {
    private final MappingData mappingData;
    private volatile ApplicationMappingImpl mapping = null;

    public ApplicationMapping(MappingData mappingData) {
        this.mappingData = mappingData;
    }

    public ApplicationMappingImpl getHttpServletMapping() {
        if (this.mapping == null) {
            if (this.mappingData == null) {
                this.mapping = new ApplicationMappingImpl("", "", null, "");
            } else {
                String string = this.mappingData.wrapper == null ? "" : this.mappingData.wrapper.getName();
                if (this.mappingData.matchType == null) {
                    this.mapping = new ApplicationMappingImpl("", "", null, string);
                } else {
                    switch (this.mappingData.matchType) {
                        case CONTEXT_ROOT: {
                            this.mapping = new ApplicationMappingImpl("", "", this.mappingData.matchType, string);
                            break;
                        }
                        case DEFAULT: {
                            this.mapping = new ApplicationMappingImpl("", "/", this.mappingData.matchType, string);
                            break;
                        }
                        case EXACT: {
                            this.mapping = new ApplicationMappingImpl(this.mappingData.wrapperPath.toString().substring(1), this.mappingData.wrapperPath.toString(), this.mappingData.matchType, string);
                            break;
                        }
                        case EXTENSION: {
                            String string2 = this.mappingData.wrapperPath.toString();
                            int n = string2.lastIndexOf(46);
                            this.mapping = new ApplicationMappingImpl(string2.substring(1, n), "*" + string2.substring(n), this.mappingData.matchType, string);
                            break;
                        }
                        case PATH: {
                            String string3 = this.mappingData.pathInfo.isNull() ? null : this.mappingData.pathInfo.toString().substring(1);
                            this.mapping = new ApplicationMappingImpl(string3, this.mappingData.wrapperPath.toString() + "/*", this.mappingData.matchType, string);
                        }
                    }
                }
            }
        }
        return this.mapping;
    }

    public void recycle() {
        this.mapping = null;
    }

    public static ApplicationMappingImpl getHttpServletMapping(HttpServletRequest httpServletRequest) {
        if (httpServletRequest instanceof RequestFacade) {
            return ((RequestFacade)httpServletRequest).getHttpServletMapping();
        }
        if (httpServletRequest instanceof Request) {
            return ((Request)httpServletRequest).getHttpServletMapping();
        }
        if (httpServletRequest instanceof ApplicationHttpRequest) {
            return ((ApplicationHttpRequest)httpServletRequest).getHttpServletMapping();
        }
        return new ApplicationMapping(null).getHttpServletMapping();
    }

    public static ApplicationMappingImpl getHttpServletMapping(HttpServletRequestWrapper httpServletRequestWrapper) {
        if (httpServletRequestWrapper instanceof ApplicationHttpRequest) {
            return ((ApplicationHttpRequest)httpServletRequestWrapper).getHttpServletMapping();
        }
        return new ApplicationMapping(null).getHttpServletMapping();
    }
}

