﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/payment-cryptography/PaymentCryptography_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/payment-cryptography/model/KeyAttributes.h>
#include <aws/payment-cryptography/model/KeyState.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace PaymentCryptography
{
namespace Model
{

  /**
   * <p>Metadata about an Amazon Web Services Payment Cryptography key.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/KeySummary">AWS
   * API Reference</a></p>
   */
  class KeySummary
  {
  public:
    AWS_PAYMENTCRYPTOGRAPHY_API KeySummary();
    AWS_PAYMENTCRYPTOGRAPHY_API KeySummary(Aws::Utils::Json::JsonView jsonValue);
    AWS_PAYMENTCRYPTOGRAPHY_API KeySummary& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_PAYMENTCRYPTOGRAPHY_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Specifies whether the key is enabled. </p>
     */
    inline bool GetEnabled() const{ return m_enabled; }

    /**
     * <p>Specifies whether the key is enabled. </p>
     */
    inline bool EnabledHasBeenSet() const { return m_enabledHasBeenSet; }

    /**
     * <p>Specifies whether the key is enabled. </p>
     */
    inline void SetEnabled(bool value) { m_enabledHasBeenSet = true; m_enabled = value; }

    /**
     * <p>Specifies whether the key is enabled. </p>
     */
    inline KeySummary& WithEnabled(bool value) { SetEnabled(value); return *this;}


    /**
     * <p>Specifies whether the key is exportable. This data is immutable after the key
     * is created.</p>
     */
    inline bool GetExportable() const{ return m_exportable; }

    /**
     * <p>Specifies whether the key is exportable. This data is immutable after the key
     * is created.</p>
     */
    inline bool ExportableHasBeenSet() const { return m_exportableHasBeenSet; }

    /**
     * <p>Specifies whether the key is exportable. This data is immutable after the key
     * is created.</p>
     */
    inline void SetExportable(bool value) { m_exportableHasBeenSet = true; m_exportable = value; }

    /**
     * <p>Specifies whether the key is exportable. This data is immutable after the key
     * is created.</p>
     */
    inline KeySummary& WithExportable(bool value) { SetExportable(value); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the key.</p>
     */
    inline const Aws::String& GetKeyArn() const{ return m_keyArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the key.</p>
     */
    inline bool KeyArnHasBeenSet() const { return m_keyArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the key.</p>
     */
    inline void SetKeyArn(const Aws::String& value) { m_keyArnHasBeenSet = true; m_keyArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the key.</p>
     */
    inline void SetKeyArn(Aws::String&& value) { m_keyArnHasBeenSet = true; m_keyArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the key.</p>
     */
    inline void SetKeyArn(const char* value) { m_keyArnHasBeenSet = true; m_keyArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the key.</p>
     */
    inline KeySummary& WithKeyArn(const Aws::String& value) { SetKeyArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the key.</p>
     */
    inline KeySummary& WithKeyArn(Aws::String&& value) { SetKeyArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the key.</p>
     */
    inline KeySummary& WithKeyArn(const char* value) { SetKeyArn(value); return *this;}


    /**
     * <p>The role of the key, the algorithm it supports, and the cryptographic
     * operations allowed with the key. This data is immutable after the key is
     * created.</p>
     */
    inline const KeyAttributes& GetKeyAttributes() const{ return m_keyAttributes; }

    /**
     * <p>The role of the key, the algorithm it supports, and the cryptographic
     * operations allowed with the key. This data is immutable after the key is
     * created.</p>
     */
    inline bool KeyAttributesHasBeenSet() const { return m_keyAttributesHasBeenSet; }

    /**
     * <p>The role of the key, the algorithm it supports, and the cryptographic
     * operations allowed with the key. This data is immutable after the key is
     * created.</p>
     */
    inline void SetKeyAttributes(const KeyAttributes& value) { m_keyAttributesHasBeenSet = true; m_keyAttributes = value; }

    /**
     * <p>The role of the key, the algorithm it supports, and the cryptographic
     * operations allowed with the key. This data is immutable after the key is
     * created.</p>
     */
    inline void SetKeyAttributes(KeyAttributes&& value) { m_keyAttributesHasBeenSet = true; m_keyAttributes = std::move(value); }

    /**
     * <p>The role of the key, the algorithm it supports, and the cryptographic
     * operations allowed with the key. This data is immutable after the key is
     * created.</p>
     */
    inline KeySummary& WithKeyAttributes(const KeyAttributes& value) { SetKeyAttributes(value); return *this;}

    /**
     * <p>The role of the key, the algorithm it supports, and the cryptographic
     * operations allowed with the key. This data is immutable after the key is
     * created.</p>
     */
    inline KeySummary& WithKeyAttributes(KeyAttributes&& value) { SetKeyAttributes(std::move(value)); return *this;}


    /**
     * <p>The key check value (KCV) is used to check if all parties holding a given key
     * have the same key or to detect that a key has changed. Amazon Web Services
     * Payment Cryptography calculates the KCV by using standard algorithms, typically
     * by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result to
     * the first 3 bytes, or 6 hex digits, of the resulting cryptogram.</p>
     */
    inline const Aws::String& GetKeyCheckValue() const{ return m_keyCheckValue; }

    /**
     * <p>The key check value (KCV) is used to check if all parties holding a given key
     * have the same key or to detect that a key has changed. Amazon Web Services
     * Payment Cryptography calculates the KCV by using standard algorithms, typically
     * by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result to
     * the first 3 bytes, or 6 hex digits, of the resulting cryptogram.</p>
     */
    inline bool KeyCheckValueHasBeenSet() const { return m_keyCheckValueHasBeenSet; }

    /**
     * <p>The key check value (KCV) is used to check if all parties holding a given key
     * have the same key or to detect that a key has changed. Amazon Web Services
     * Payment Cryptography calculates the KCV by using standard algorithms, typically
     * by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result to
     * the first 3 bytes, or 6 hex digits, of the resulting cryptogram.</p>
     */
    inline void SetKeyCheckValue(const Aws::String& value) { m_keyCheckValueHasBeenSet = true; m_keyCheckValue = value; }

    /**
     * <p>The key check value (KCV) is used to check if all parties holding a given key
     * have the same key or to detect that a key has changed. Amazon Web Services
     * Payment Cryptography calculates the KCV by using standard algorithms, typically
     * by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result to
     * the first 3 bytes, or 6 hex digits, of the resulting cryptogram.</p>
     */
    inline void SetKeyCheckValue(Aws::String&& value) { m_keyCheckValueHasBeenSet = true; m_keyCheckValue = std::move(value); }

    /**
     * <p>The key check value (KCV) is used to check if all parties holding a given key
     * have the same key or to detect that a key has changed. Amazon Web Services
     * Payment Cryptography calculates the KCV by using standard algorithms, typically
     * by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result to
     * the first 3 bytes, or 6 hex digits, of the resulting cryptogram.</p>
     */
    inline void SetKeyCheckValue(const char* value) { m_keyCheckValueHasBeenSet = true; m_keyCheckValue.assign(value); }

    /**
     * <p>The key check value (KCV) is used to check if all parties holding a given key
     * have the same key or to detect that a key has changed. Amazon Web Services
     * Payment Cryptography calculates the KCV by using standard algorithms, typically
     * by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result to
     * the first 3 bytes, or 6 hex digits, of the resulting cryptogram.</p>
     */
    inline KeySummary& WithKeyCheckValue(const Aws::String& value) { SetKeyCheckValue(value); return *this;}

    /**
     * <p>The key check value (KCV) is used to check if all parties holding a given key
     * have the same key or to detect that a key has changed. Amazon Web Services
     * Payment Cryptography calculates the KCV by using standard algorithms, typically
     * by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result to
     * the first 3 bytes, or 6 hex digits, of the resulting cryptogram.</p>
     */
    inline KeySummary& WithKeyCheckValue(Aws::String&& value) { SetKeyCheckValue(std::move(value)); return *this;}

    /**
     * <p>The key check value (KCV) is used to check if all parties holding a given key
     * have the same key or to detect that a key has changed. Amazon Web Services
     * Payment Cryptography calculates the KCV by using standard algorithms, typically
     * by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result to
     * the first 3 bytes, or 6 hex digits, of the resulting cryptogram.</p>
     */
    inline KeySummary& WithKeyCheckValue(const char* value) { SetKeyCheckValue(value); return *this;}


    /**
     * <p>The state of an Amazon Web Services Payment Cryptography that is being
     * created or deleted.</p>
     */
    inline const KeyState& GetKeyState() const{ return m_keyState; }

    /**
     * <p>The state of an Amazon Web Services Payment Cryptography that is being
     * created or deleted.</p>
     */
    inline bool KeyStateHasBeenSet() const { return m_keyStateHasBeenSet; }

    /**
     * <p>The state of an Amazon Web Services Payment Cryptography that is being
     * created or deleted.</p>
     */
    inline void SetKeyState(const KeyState& value) { m_keyStateHasBeenSet = true; m_keyState = value; }

    /**
     * <p>The state of an Amazon Web Services Payment Cryptography that is being
     * created or deleted.</p>
     */
    inline void SetKeyState(KeyState&& value) { m_keyStateHasBeenSet = true; m_keyState = std::move(value); }

    /**
     * <p>The state of an Amazon Web Services Payment Cryptography that is being
     * created or deleted.</p>
     */
    inline KeySummary& WithKeyState(const KeyState& value) { SetKeyState(value); return *this;}

    /**
     * <p>The state of an Amazon Web Services Payment Cryptography that is being
     * created or deleted.</p>
     */
    inline KeySummary& WithKeyState(KeyState&& value) { SetKeyState(std::move(value)); return *this;}

  private:

    bool m_enabled;
    bool m_enabledHasBeenSet = false;

    bool m_exportable;
    bool m_exportableHasBeenSet = false;

    Aws::String m_keyArn;
    bool m_keyArnHasBeenSet = false;

    KeyAttributes m_keyAttributes;
    bool m_keyAttributesHasBeenSet = false;

    Aws::String m_keyCheckValue;
    bool m_keyCheckValueHasBeenSet = false;

    KeyState m_keyState;
    bool m_keyStateHasBeenSet = false;
  };

} // namespace Model
} // namespace PaymentCryptography
} // namespace Aws
