/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.configuration;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.components.JBList;
import com.intellij.util.TimeoutUtil;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.IpnbUtils;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.IpnbParser;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.protocol.IpnbConnection;
import org.jetbrains.plugins.ipnb.protocol.IpnbConnectionListenerBase;
import org.jetbrains.plugins.ipnb.protocol.IpnbConnectionV3;
import org.jetbrains.plugins.ipnb.run.IpnbRunConfiguration;
import org.jetbrains.plugins.ipnb.run.IpnbRunConfigurationType;

public final class IpnbConnectionManager
implements ProjectComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance(IpnbConnectionManager.class);
    private final Project myProject;
    private final Map<String, IpnbConnection> myKernels = new HashMap<String, IpnbConnection>();
    private final Map<String, IpnbCodePanel> myUpdateMap = new HashMap<String, IpnbCodePanel>();
    @Nullable
    private String myToken;
    @Nullable
    private String myUrl;
    private static final String CONNECTION_REFUSED = "Connection refused";
    private static final int MAX_ATTEMPTS = 10;

    public IpnbConnectionManager(Project project) {
        this.myProject = project;
    }

    public static IpnbConnectionManager getInstance(Project project) {
        return (IpnbConnectionManager)project.getComponent(IpnbConnectionManager.class);
    }

    public void executeCell(@NotNull IpnbCodePanel codePanel) {
        IpnbFileEditor fileEditor;
        VirtualFile virtualFile;
        String path;
        if (codePanel == null) {
            IpnbConnectionManager.$$$reportNull$$$0(0);
        }
        if (!this.hasConnection(path = (virtualFile = (fileEditor = codePanel.getFileEditor()).getVirtualFile()).getPath())) {
            this.startConnection(codePanel, path);
        } else {
            IpnbConnection connection = this.myKernels.get(path);
            if (!connection.isAlive()) {
                this.myKernels.remove(path);
                this.startConnection(codePanel, path);
            } else {
                String messageId = connection.execute(((IpnbCodeCell)codePanel.getCell()).getSourceAsString());
                this.myUpdateMap.put(messageId, codePanel);
            }
        }
    }

    public boolean hasConnection(String path) {
        return this.myKernels.containsKey(path);
    }

    private void startConnection(@NotNull IpnbCodePanel codePanel, @NotNull String filePath) {
        List descriptors;
        if (codePanel == null) {
            IpnbConnectionManager.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            IpnbConnectionManager.$$$reportNull$$$0(2);
        }
        if ((descriptors = ExecutionManagerImpl.getInstance((Project)this.myProject).getRunningDescriptors(settings -> settings.getConfiguration() instanceof IpnbRunConfiguration)).isEmpty()) {
            if (!this.connectToExternal(codePanel, filePath)) {
                IpnbConnectionManager.showMessage(codePanel.getFileEditor(), "Cannot connect to Jupyter Notebook. <a href=\"\">Run Jupyter Notebook</a>", new IpnbRunAdapter(), MessageType.WARNING);
            }
        } else if (descriptors.size() == 1) {
            RunContentDescriptor descriptor = (RunContentDescriptor)descriptors.get(0);
            Pair<String, String> urlToken = this.getUrlTokenByDescriptor(descriptor);
            this.startConnection(codePanel, filePath, (String)urlToken.getFirst(), (String)urlToken.getSecond());
        } else {
            this.selectRunningInstance(codePanel, filePath, descriptors);
        }
    }

    private void selectRunningInstance(@NotNull IpnbCodePanel codePanel, @NotNull String filePath, List<RunContentDescriptor> descriptors) {
        if (codePanel == null) {
            IpnbConnectionManager.$$$reportNull$$$0(3);
        }
        if (filePath == null) {
            IpnbConnectionManager.$$$reportNull$$$0(4);
        }
        JBList list = new JBList(descriptors);
        list.setCellRenderer(new ColoredListCellRenderer<RunContentDescriptor>(){

            protected void customizeCellRenderer(@NotNull JList<? extends RunContentDescriptor> list, RunContentDescriptor value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append(value.getDisplayName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager$1", "customizeCellRenderer"));
            }
        });
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        builder.setTitle("Choose Jupyter Notebook Server");
        builder.setItemChoosenCallback(() -> this.lambda$selectRunningInstance$1((JList)list, codePanel, filePath));
        JBPopup popup = builder.createPopup();
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point point = pointerInfo.getLocation();
        popup.showInScreenCoordinates((Component)WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow(), point);
    }

    private boolean connectToExternal(@NotNull IpnbCodePanel codePanel, @NotNull String filePath) {
        if (codePanel == null) {
            IpnbConnectionManager.$$$reportNull$$$0(5);
        }
        if (filePath == null) {
            IpnbConnectionManager.$$$reportNull$$$0(6);
        }
        if (this.myToken == null || this.myUrl == null) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                Pair<String, String> pair = IpnbConnectionManager.askForUrlAndToken();
                if (pair != null) {
                    this.myUrl = StringUtil.trimTrailing((String)((String)pair.getFirst()), (char)'/');
                    this.myToken = (String)pair.getSecond();
                }
            });
        }
        if (this.myUrl != null) {
            this.startConnection(codePanel, filePath, this.myUrl, this.myToken);
            return true;
        }
        return false;
    }

    @NotNull
    private Pair<String, String> getUrlTokenByDescriptor(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            IpnbConnectionManager.$$$reportNull$$$0(7);
        }
        Set configurations = ExecutionManagerImpl.getInstance((Project)this.myProject).getConfigurations(descriptor);
        for (RunnerAndConfigurationSettings configuration : configurations) {
            String token;
            RunConfiguration runConfiguration = configuration.getConfiguration();
            if (!(runConfiguration instanceof IpnbRunConfiguration) || (token = ((IpnbRunConfiguration)runConfiguration).getToken()) == null) continue;
            Pair pair = Pair.create((Object)((IpnbRunConfiguration)runConfiguration).getUrl(), (Object)token);
            if (pair == null) {
                IpnbConnectionManager.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            IpnbConnectionManager.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static Pair<String, String> askForUrlAndToken() {
        String urlToken = Messages.showInputDialog((String)"Please, enter your Jupyter Notebook URL and authentication token", (String)"Jupyter Notebook", null, (String)"http://localhost:8888/?token=", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return !inputString.endsWith("?token=");
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        if (!StringUtil.isEmptyOrSpaces((String)urlToken)) {
            String trimmed = urlToken.trim();
            List strings = StringUtil.split((String)trimmed, (String)"?token=", (boolean)true);
            String token = strings.size() > 1 ? (String)strings.get(1) : null;
            return Pair.create(strings.get(0), (Object)token);
        }
        return null;
    }

    public void startConnection(@Nullable IpnbCodePanel codePanel, @NotNull String path, @NotNull String urlString, @Nullable String token) {
        if (path == null) {
            IpnbConnectionManager.$$$reportNull$$$0(10);
        }
        if (urlString == null) {
            IpnbConnectionManager.$$$reportNull$$$0(11);
        }
        if (codePanel == null) {
            return;
        }
        VirtualFile file = codePanel.getFileEditor().getVirtualFile();
        String pathToFile = this.getRelativePathToFile(file);
        if (pathToFile == null) {
            return;
        }
        boolean format = IpnbParser.isIpythonNewFormat(file);
        IpnbUtils.runCancellableProcessUnderProgress(this.myProject, () -> this.setupConnection(codePanel, path, urlString, token, format), "Connecting to Jupyter Notebook Server");
    }

    @NotNull
    private IpnbConnectionListenerBase createConnectionListener(final @Nullable IpnbCodePanel codePanel, final Ref<Boolean> connectionOpened) {
        IpnbConnectionListenerBase ipnbConnectionListenerBase = new IpnbConnectionListenerBase(){

            @Override
            public void onOpen(@NotNull IpnbConnection connection) {
                if (connection == null) {
                    3.$$$reportNull$$$0(0);
                }
                connectionOpened.set((Object)true);
                if (codePanel == null) {
                    return;
                }
                String messageId = connection.execute(((IpnbCodeCell)codePanel.getCell()).getSourceAsString());
                IpnbConnectionManager.this.myUpdateMap.put(messageId, codePanel);
            }

            @Override
            public void onOutput(@NotNull IpnbConnection connection, @NotNull String parentMessageId) {
                if (connection == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (parentMessageId == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!IpnbConnectionManager.this.myUpdateMap.containsKey(parentMessageId)) {
                    return;
                }
                IpnbCodePanel cell = (IpnbCodePanel)IpnbConnectionManager.this.myUpdateMap.get(parentMessageId);
                ((IpnbCodeCell)cell.getCell()).setPromptNumber(connection.getExecCount());
                cell.updatePanel(null, connection.getOutput());
            }

            @Override
            public void onPayload(@Nullable String payload, @NotNull String parentMessageId) {
                if (parentMessageId == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (!IpnbConnectionManager.this.myUpdateMap.containsKey(parentMessageId)) {
                    return;
                }
                IpnbCodePanel cell = (IpnbCodePanel)IpnbConnectionManager.this.myUpdateMap.remove(parentMessageId);
                if (payload != null) {
                    cell.updatePanel(payload, null);
                }
            }

            @Override
            public void onFinished(@NotNull IpnbConnection connection, @NotNull String parentMessageId) {
                if (connection == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (parentMessageId == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (!IpnbConnectionManager.this.myUpdateMap.containsKey(parentMessageId)) {
                    return;
                }
                IpnbCodePanel cell = (IpnbCodePanel)IpnbConnectionManager.this.myUpdateMap.remove(parentMessageId);
                ((IpnbCodeCell)cell.getCell()).setPromptNumber(connection.getExecCount());
                cell.finishExecution();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "connection";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parentMessageId";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onOpen";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onOutput";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onPayload";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (ipnbConnectionListenerBase == null) {
            IpnbConnectionManager.$$$reportNull$$$0(12);
        }
        return ipnbConnectionListenerBase;
    }

    private boolean setupConnection(@NotNull IpnbCodePanel codePanel, @NotNull String path, @NotNull String urlString, String token, boolean isNewFormat) {
        if (codePanel == null) {
            IpnbConnectionManager.$$$reportNull$$$0(13);
        }
        if (path == null) {
            IpnbConnectionManager.$$$reportNull$$$0(14);
        }
        if (urlString == null) {
            IpnbConnectionManager.$$$reportNull$$$0(15);
        }
        try {
            Ref connectionOpened = new Ref((Object)false);
            IpnbConnectionListenerBase listener = this.createConnectionListener(codePanel, (Ref<Boolean>)connectionOpened);
            VirtualFile file = codePanel.getFileEditor().getVirtualFile();
            String pathToFile = this.getRelativePathToFile(file);
            if (pathToFile == null) {
                return false;
            }
            IpnbConnection connection = this.getConnection(urlString, listener, pathToFile, token, isNewFormat);
            for (int countAttempt = 0; !((Boolean)connectionOpened.get()).booleanValue() && countAttempt < 10; ++countAttempt) {
                TimeoutUtil.sleep((long)1000L);
            }
            this.myKernels.put(path, connection);
        }
        catch (URISyntaxException e) {
            IpnbConnectionManager.showMessage(codePanel.getFileEditor(), "Cannot connect to Jupyter Notebook. <a href=\"\">Run Jupyter Notebook</a>", new IpnbRunAdapter(), MessageType.WARNING);
            LOG.warn("Jupyter Notebook connection refused: " + e.getMessage());
            return false;
        }
        catch (UnsupportedOperationException e) {
            IpnbConnectionManager.showMessage(codePanel.getFileEditor(), e.getMessage(), null, MessageType.WARNING);
        }
        catch (UnknownHostException e) {
            IpnbConnectionManager.showMessage(codePanel.getFileEditor(), "Cannot connect to Jupyter Notebook. <a href=\"\">Run Jupyter Notebook</a>", new IpnbRunAdapter(), MessageType.WARNING);
        }
        catch (IOException e) {
            String message;
            if ("Authentication needed".equals(e.getMessage())) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    Pair<String, String> pair = IpnbConnectionManager.askForUrlAndToken();
                    if (pair != null) {
                        this.myToken = (String)pair.getFirst();
                        this.myUrl = (String)pair.getSecond();
                    }
                });
                if (this.myToken != null) {
                    return this.setupConnection(codePanel, path, urlString, token, isNewFormat);
                }
            }
            if ((message = e.getMessage()).startsWith("Unable to login: ")) {
                IpnbConnectionManager.showMessage(codePanel.getFileEditor(), "Cannot connect to Jupyter Notebook: login failed", new IpnbSettingsAdapter(), MessageType.WARNING);
            } else if (message.startsWith(CONNECTION_REFUSED) || message.startsWith("Cannot start Jupyter Notebook")) {
                IpnbConnectionManager.showMessage(codePanel.getFileEditor(), "Cannot connect to Jupyter Notebook. <a href=\"\">Run Jupyter Notebook</a>", new IpnbRunAdapter(), MessageType.WARNING);
            }
            LOG.warn("Jupyter Notebook connection refused: " + message);
            return false;
        }
        return true;
    }

    @NotNull
    private IpnbConnection getConnection(@NotNull String urlString, @NotNull IpnbConnectionListenerBase listener, @NotNull String pathToFile, String token, boolean isNewFormat) throws IOException, URISyntaxException {
        if (urlString == null) {
            IpnbConnectionManager.$$$reportNull$$$0(16);
        }
        if (listener == null) {
            IpnbConnectionManager.$$$reportNull$$$0(17);
        }
        if (pathToFile == null) {
            IpnbConnectionManager.$$$reportNull$$$0(18);
        }
        if (!isNewFormat) {
            IpnbConnection ipnbConnection = new IpnbConnection(urlString, listener, token, this.myProject, pathToFile);
            if (ipnbConnection == null) {
                IpnbConnectionManager.$$$reportNull$$$0(19);
            }
            return ipnbConnection;
        }
        IpnbConnectionV3 ipnbConnectionV3 = new IpnbConnectionV3(urlString, listener, token, this.myProject, pathToFile);
        if (ipnbConnectionV3 == null) {
            IpnbConnectionManager.$$$reportNull$$$0(20);
        }
        return ipnbConnectionV3;
    }

    @Nullable
    private String getRelativePathToFile(VirtualFile file) {
        String workingDir = this.myProject.getBasePath();
        if (workingDir != null) {
            Path basePath = Paths.get(workingDir, new String[0]);
            Path filePath = Paths.get(file.getPath(), new String[0]);
            return basePath.relativize(filePath).toString();
        }
        return null;
    }

    public void interruptKernel(@NotNull String filePath) {
        if (filePath == null) {
            IpnbConnectionManager.$$$reportNull$$$0(21);
        }
        if (!this.hasConnection(filePath)) {
            return;
        }
        IpnbConnection connection = this.myKernels.get(filePath);
        try {
            connection.interrupt();
        }
        catch (IOException e) {
            LOG.warn("Failed to interrupt kernel " + filePath);
            LOG.warn(e.getMessage());
        }
    }

    public void reloadKernel(@NotNull String filePath) {
        if (filePath == null) {
            IpnbConnectionManager.$$$reportNull$$$0(22);
        }
        if (!this.hasConnection(filePath)) {
            return;
        }
        IpnbConnection connection = this.myKernels.get(filePath);
        try {
            connection.reload();
        }
        catch (IOException e) {
            LOG.warn("Failed to reload kernel " + filePath);
            LOG.warn(e.getMessage());
        }
    }

    private static void showMessage(@NotNull IpnbFileEditor fileEditor, @NotNull String message, @Nullable HyperlinkAdapter listener, MessageType messageType) {
        if (fileEditor == null) {
            IpnbConnectionManager.$$$reportNull$$$0(23);
        }
        if (message == null) {
            IpnbConnectionManager.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, null, messageType.getPopupBackground(), (HyperlinkListener)listener);
            Balloon balloon = balloonBuilder.setHideOnLinkClick(true).createBalloon();
            ApplicationManager.getApplication().invokeLater(() -> balloon.show(fileEditor.getRunButtonPlace(), Balloon.Position.above));
        });
    }

    public void projectClosed() {
        this.shutdownKernels();
    }

    public void shutdownKernels() {
        for (IpnbConnection connection : this.myKernels.values()) {
            if (!connection.isAlive()) continue;
            connection.shutdown();
            try {
                connection.close();
            }
            catch (IOException | InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myKernels.clear();
    }

    @NotNull
    public String getComponentName() {
        if ("IpnbConnectionManager" == null) {
            IpnbConnectionManager.$$$reportNull$$$0(25);
        }
        return "IpnbConnectionManager";
    }

    public void dispose() {
        this.shutdownKernels();
    }

    private /* synthetic */ void lambda$selectRunningInstance$1(JList list, IpnbCodePanel codePanel, String filePath) {
        Pair<String, String> urlToken = this.getUrlTokenByDescriptor((RunContentDescriptor)list.getSelectedValue());
        this.startConnection(codePanel, filePath, (String)urlToken.getFirst(), (String)urlToken.getSecond());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 19: 
            case 20: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 19: 
            case 20: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codePanel";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 19: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlTokenByDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnectionListener";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeCell";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startConnection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectRunningInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "connectToExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUrlTokenByDescriptor";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 19: 
            case 20: 
            case 25: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupConnection";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "interruptKernel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reloadKernel";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 19: 
            case 20: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class IpnbRunAdapter
    extends HyperlinkAdapter {
        IpnbRunAdapter() {
        }

        protected void hyperlinkActivated(HyperlinkEvent e) {
            List configurationsList = RunManager.getInstance((Project)IpnbConnectionManager.this.myProject).getConfigurationSettingsList((ConfigurationType)IpnbRunConfigurationType.getInstance());
            if (configurationsList.isEmpty()) {
                RunnerAndConfigurationSettings configurationSettings = PyRunConfigurationFactory.getInstance().createRunConfiguration(ModuleManager.getInstance((Project)IpnbConnectionManager.this.myProject).getModules()[0], IpnbRunConfigurationType.getInstance().getConfigurationFactories()[0]);
                IpnbRunConfiguration configuration = (IpnbRunConfiguration)configurationSettings.getConfiguration();
                configuration.setHost("127.0.0.1");
                configuration.setPort("8888");
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configurationSettings, (Executor)DefaultRunExecutor.getRunExecutorInstance());
            } else if (configurationsList.size() == 1) {
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)((RunnerAndConfigurationSettings)configurationsList.get(0)), (Executor)DefaultRunExecutor.getRunExecutorInstance());
            } else {
                JBList list = new JBList((Collection)configurationsList);
                list.setCellRenderer(new ColoredListCellRenderer<RunnerAndConfigurationSettings>(){

                    protected void customizeCellRenderer(@NotNull JList<? extends RunnerAndConfigurationSettings> list, RunnerAndConfigurationSettings value, int index, boolean selected, boolean hasFocus) {
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.append(value.getName());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager$IpnbRunAdapter$1", "customizeCellRenderer"));
                    }
                });
                PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
                builder.setTitle("Choose Jupyter Notebook Server");
                builder.setItemChoosenCallback(() -> IpnbRunAdapter.lambda$hyperlinkActivated$0((JList)list));
                JBPopup popup = builder.createPopup();
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (pointerInfo == null) {
                    return;
                }
                Point point = pointerInfo.getLocation();
                popup.showInScreenCoordinates((Component)WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow(), point);
            }
        }

        private static /* synthetic */ void lambda$hyperlinkActivated$0(JList list) {
            RunnerAndConfigurationSettings configuration = (RunnerAndConfigurationSettings)list.getSelectedValue();
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        }
    }

    class IpnbSettingsAdapter
    extends HyperlinkAdapter {
        IpnbSettingsAdapter() {
        }

        protected void hyperlinkActivated(HyperlinkEvent e) {
            ShowSettingsUtil.getInstance().showSettingsDialog(IpnbConnectionManager.this.myProject, "Jupyter Notebook");
        }
    }
}

