/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVcsSettings;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchIncomingOutgoingManager
implements GitRepositoryChangeListener,
GitAuthenticationListener {
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Hash>> myLocalBranchesToPull;
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Hash>> myLocalBranchesToPush;
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myAuthErrorMap;
    @NotNull
    private final Project myProject;
    @Nullable
    private ScheduledFuture<?> myPeriodicalUpdater;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @Nullable
    private MessageBusConnection myConnection;

    GitBranchIncomingOutgoingManager(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager) {
        if (project == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(0);
        }
        if (repositoryManager == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(1);
        }
        this.myLocalBranchesToPull = ContainerUtil.newConcurrentMap();
        this.myLocalBranchesToPush = ContainerUtil.newConcurrentMap();
        this.myAuthErrorMap = MultiMap.createConcurrentSet();
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
    }

    public boolean hasIncomingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        if (localBranchName == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(2);
        }
        return this.getBranchesToPull(repository).contains(new GitLocalBranch(localBranchName));
    }

    public boolean hasOutgoingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        if (localBranchName == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(3);
        }
        return this.getBranchesToPush(repository).contains(new GitLocalBranch(localBranchName));
    }

    @NotNull
    public static GitBranchIncomingOutgoingManager getInstance(@NotNull Project project) {
        if (project == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(4);
        }
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = (GitBranchIncomingOutgoingManager)ServiceManager.getService((Project)project, GitBranchIncomingOutgoingManager.class);
        if (gitBranchIncomingOutgoingManager == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(5);
        }
        return gitBranchIncomingOutgoingManager;
    }

    public boolean hasAuthenticationProblems() {
        return !this.myAuthErrorMap.isEmpty();
    }

    public void startScheduling() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myConnection == null) {
                this.myConnection = this.myProject.getMessageBus().connect();
                this.myConnection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this);
                this.myConnection.subscribe(GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS, (Object)this);
            }
            this.forceUpdateBranches(false);
            if (this.myPeriodicalUpdater == null) {
                int updateTime = GitVcsSettings.getInstance(this.myProject).getBranchInfoUpdateTime();
                this.myPeriodicalUpdater = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.updateBranchesToPull(), updateTime, updateTime, TimeUnit.MINUTES);
                Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

                    public void dispose() {
                        GitBranchIncomingOutgoingManager.this.stopScheduling();
                    }
                });
            }
        });
    }

    public void stopScheduling() {
        if (this.myPeriodicalUpdater != null) {
            this.myPeriodicalUpdater.cancel(true);
            this.myPeriodicalUpdater = null;
        }
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    public void forceUpdateBranches(final boolean useForceAuthentication) {
        new Task.Backgroundable(this.myProject, "Update Branches Info..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitBranchIncomingOutgoingManager.this.myRepositoryManager.getRepositories().forEach(r -> {
                    GitBranchIncomingOutgoingManager.this.myLocalBranchesToPush.put(r, GitBranchIncomingOutgoingManager.calculateBranchesToPush(r));
                    GitBranchIncomingOutgoingManager.this.myLocalBranchesToPull.put(r, GitBranchIncomingOutgoingManager.this.calculateBranchesToPull(r, useForceAuthentication));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBranchIncomingOutgoingManager$2", "run"));
            }
        }.queue();
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesToPull(@Nullable GitRepository repository) {
        Collection<GitLocalBranch> collection = GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesToPull);
        if (collection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesToPush(@Nullable GitRepository repository) {
        Collection<GitLocalBranch> collection = GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesToPush);
        if (collection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private void updateBranchesToPull() {
        this.myRepositoryManager.getRepositories().forEach(r -> this.myLocalBranchesToPull.put((GitRepository)r, this.calculateBranchesToPull((GitRepository)r, false)));
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calculateBranchesToPull(@NotNull GitRepository repository, boolean useForceAuthentication) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(8);
        }
        HashMap result2 = ContainerUtil.newHashMap();
        GitBranchIncomingOutgoingManager.groupTrackInfoByRemotes(repository).entrySet().forEach(entry -> result2.putAll(this.calcBranchesToPullForRemote(repository, (GitRemote)entry.getKey(), (Collection)entry.getValue(), useForceAuthentication)));
        HashMap hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calcBranchesToPullForRemote(@NotNull GitRepository repository, @NotNull GitRemote gitRemote, @NotNull Collection<GitBranchTrackInfo> trackInfoList, boolean useForceAuthentication) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(10);
        }
        if (gitRemote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(11);
        }
        if (trackInfoList == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(12);
        }
        HashMap result2 = ContainerUtil.newHashMap();
        GitBranchesCollection branchesCollection = repository.getBranches();
        Map<String, Hash> remoteNameWithHash = this.lsRemote(repository, gitRemote, ContainerUtil.map(trackInfoList, info -> info.getRemoteBranch().getNameForRemoteOperations()), useForceAuthentication);
        for (Map.Entry<String, Hash> hashEntry : remoteNameWithHash.entrySet()) {
            String remoteBranchName = hashEntry.getKey();
            Hash remoteHash = hashEntry.getValue();
            trackInfoList.forEach(info -> {
                Hash localHashForRemoteBranch;
                GitRemoteBranch remoteBranch = info.getRemoteBranch();
                if (StringUtil.equals((CharSequence)remoteBranchName, (CharSequence)GitRefUtil.addRefsHeadsPrefixIfNeeded(remoteBranch.getNameForRemoteOperations())) && (localHashForRemoteBranch = branchesCollection.getHash(remoteBranch)) != null && !localHashForRemoteBranch.equals(remoteHash)) {
                    result2.put(info.getLocalBranch(), localHashForRemoteBranch);
                }
            });
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, Hash> lsRemote(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> branchRefNames, boolean useForceAuthentication) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(14);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(15);
        }
        if (branchRefNames == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(16);
        }
        HashMap result2 = ContainerUtil.newHashMap();
        VcsFileUtil.chunkArguments(branchRefNames).forEach(refs -> {
            ArrayList params = ContainerUtil.newArrayList((Object[])new String[]{"--heads", remote.getName()});
            params.addAll(refs);
            GitCommandResult lsRemoteResult = Git.getInstance().runCommand((Computable<GitLineHandler>)((Computable)() -> this.createLsRemoteHandler(repository, remote, params, useForceAuthentication)));
            if (lsRemoteResult.success()) {
                Map hashWithNameMap = ContainerUtil.map2MapNotNull(lsRemoteResult.getOutput(), GitRefUtil::parseRefsLine);
                result2.putAll(GitRefUtil.getResolvedHashes(hashWithNameMap));
                this.myAuthErrorMap.remove((Object)repository, (Object)remote);
            } else if (lsRemoteResult.isAuthenticationFailed()) {
                this.myAuthErrorMap.putValue((Object)repository, (Object)remote);
            }
        });
        HashMap hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @NotNull
    private GitLineHandler createLsRemoteHandler(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> params, boolean useForceAuthentication) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(18);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(19);
        }
        if (params == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(20);
        }
        GitLineHandler h = new GitLineHandler(this.myProject, repository.getRoot(), GitCommand.LS_REMOTE, !useForceAuthentication ? Collections.singletonList("credential.helper=") : ContainerUtil.emptyList());
        h.setIgnoreAuthenticationRequest(!useForceAuthentication);
        h.addParameters(params);
        h.setUrls(remote.getUrls());
        GitLineHandler gitLineHandler = h;
        if (gitLineHandler == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(21);
        }
        return gitLineHandler;
    }

    private boolean shouldUpdateBranchesToPull(@NotNull GitRepository repository) {
        Map<GitLocalBranch, Hash> cachedBranchesToPull;
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(22);
        }
        return (cachedBranchesToPull = this.myLocalBranchesToPull.get(repository)) == null || StreamEx.of(repository.getBranchTrackInfos()).anyMatch(info -> !Objects.equals(repository.getBranches().getHash(info.getRemoteBranch()), cachedBranchesToPull.get(info.getLocalBranch())));
    }

    @NotNull
    private static Map<GitLocalBranch, Hash> calculateBranchesToPush(@NotNull GitRepository gitRepository) {
        if (gitRepository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(23);
        }
        HashMap branchesToPush = ContainerUtil.newHashMap();
        GitBranchesCollection branchesCollection = gitRepository.getBranches();
        for (GitLocalBranch branch : branchesCollection.getLocalBranches()) {
            GitPushTarget pushTarget = GitPushSupport.getPushTargetIfExist(gitRepository, branch);
            Hash remoteHash = pushTarget != null ? branchesCollection.getHash(pushTarget.getBranch()) : null;
            if (remoteHash == null || Objects.equals(branchesCollection.getHash(branch), remoteHash)) continue;
            branchesToPush.put(branch, remoteHash);
        }
        HashMap hashMap = branchesToPush;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    @NotNull
    private static Collection<GitLocalBranch> getBranches(@Nullable GitRepository repository, @NotNull Map<GitRepository, Map<GitLocalBranch, Hash>> branchCollection) {
        if (branchCollection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(25);
        }
        if (repository != null) {
            Map<GitLocalBranch, Hash> branchHashMap = branchCollection.get(repository);
            Set<GitLocalBranch> set = branchHashMap != null ? branchHashMap.keySet() : Collections.emptySet();
            if (set == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(26);
            }
            return set;
        }
        Collection collection = (Collection)StreamEx.of(branchCollection.values()).flatMap(StreamEx::ofKeys).collect(Collectors.toSet());
        if (collection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @Override
    public void repositoryChanged(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(28);
        }
        this.myLocalBranchesToPush.put(repository, GitBranchIncomingOutgoingManager.calculateBranchesToPush(repository));
        if (this.shouldUpdateBranchesToPull(repository)) {
            this.myLocalBranchesToPull.put(repository, this.calculateBranchesToPull(repository, false));
        }
    }

    @Override
    public void authenticationSucceeded(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        MultiMap<GitRemote, GitBranchTrackInfo> trackInfoByRemotes;
        Collection remotes;
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(29);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(30);
        }
        if ((remotes = this.myAuthErrorMap.get((Object)repository)).contains(remote) && (trackInfoByRemotes = GitBranchIncomingOutgoingManager.groupTrackInfoByRemotes(repository)).containsKey((Object)remote)) {
            Map<GitLocalBranch, Hash> newBranchMap = this.calcBranchesToPullForRemote(repository, remote, trackInfoByRemotes.get((Object)remote), false);
            this.myLocalBranchesToPull.compute(repository, (r, branchHashMap) -> {
                if (branchHashMap == null) {
                    return ContainerUtil.newHashMap((Map)newBranchMap);
                }
                branchHashMap.putAll(newBranchMap);
                return branchHashMap;
            });
        }
    }

    @NotNull
    private static MultiMap<GitRemote, GitBranchTrackInfo> groupTrackInfoByRemotes(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(31);
        }
        MultiMap multiMap = ContainerUtil.groupBy(repository.getBranchTrackInfos(), GitBranchTrackInfo::getRemote);
        if (multiMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(32);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchIncomingOutgoingManager";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRemote";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackInfoList";
                break;
            }
            case 15: 
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchRefNames";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchIncomingOutgoingManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesToPull";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesToPush";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBranchesToPull";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBranchesToPullForRemote";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "lsRemote";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createLsRemoteHandler";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBranchesToPush";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "groupTrackInfoByRemotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasIncomingFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasOutgoingFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 32: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateBranchesToPull";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcBranchesToPullForRemote";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lsRemote";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createLsRemoteHandler";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldUpdateBranchesToPull";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "calculateBranchesToPush";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBranches";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "repositoryChanged";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "authenticationSucceeded";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "groupTrackInfoByRemotes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

