/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.inspections.InspectedPropertyProblems;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundlePropertyStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private static final TextAttributesKey GROUP_KEY;
    public static final String PROPERTY_GROUP_KEY_TEXT = "<property>";
    @NotNull
    private final IProperty myProperty;
    private String myPresentableName;
    private volatile InspectedPropertyProblems myInspectedPropertyProblems;

    public ResourceBundlePropertyStructureViewElement(@NotNull IProperty property) {
        if (property == null) {
            ResourceBundlePropertyStructureViewElement.$$$reportNull$$$0(0);
        }
        this.myProperty = property;
    }

    @Nullable
    public IProperty getProperty() {
        return this.getPsiElement() != null ? this.myProperty : null;
    }

    @Nullable
    public PsiElement getPsiElement() {
        PsiElement element = this.myProperty.getPsiElement();
        return element.isValid() ? element : null;
    }

    @Override
    @NotNull
    public IProperty[] getProperties() {
        IProperty[] iPropertyArray = new IProperty[]{this.myProperty};
        if (iPropertyArray == null) {
            ResourceBundlePropertyStructureViewElement.$$$reportNull$$$0(1);
        }
        return iPropertyArray;
    }

    @Override
    @Nullable
    public PsiFile[] getFiles() {
        return null;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    public IProperty getValue() {
        return this.getProperty();
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        if (EMPTY_ARRAY == null) {
            ResourceBundlePropertyStructureViewElement.$$$reportNull$$$0(2);
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] getProblemDescriptors() {
        Object[] objectArray = this.myInspectedPropertyProblems == null ? new Pair[]{} : this.myInspectedPropertyProblems.getDescriptors();
        if (objectArray == null) {
            ResourceBundlePropertyStructureViewElement.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    public void setInspectedPropertyProblems(InspectedPropertyProblems inspectedPropertyProblems) {
        this.myInspectedPropertyProblems = inspectedPropertyProblems;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ResourceBundleEditorRenderer.TextAttributesPresentation textAttributesPresentation = new ResourceBundleEditorRenderer.TextAttributesPresentation(){

            public String getPresentableText() {
                IProperty property = ResourceBundlePropertyStructureViewElement.this.getProperty();
                if (property == null) {
                    return null;
                }
                return ResourceBundlePropertyStructureViewElement.this.myPresentableName == null ? property.getName() : (ResourceBundlePropertyStructureViewElement.this.myPresentableName.isEmpty() ? ResourceBundlePropertyStructureViewElement.PROPERTY_GROUP_KEY_TEXT : ResourceBundlePropertyStructureViewElement.this.myPresentableName);
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return PlatformIcons.PROPERTY_ICON;
            }

            @Override
            public TextAttributes getTextAttributes(EditorColorsScheme colorsScheme) {
                TextAttributes highlightingAttributes;
                TextAttributesKey baseAttrKey = ResourceBundlePropertyStructureViewElement.this.myPresentableName != null && ResourceBundlePropertyStructureViewElement.this.myPresentableName.isEmpty() ? GROUP_KEY : PropertiesHighlighter.PROPERTY_KEY;
                TextAttributes baseAttrs = colorsScheme.getAttributes(baseAttrKey);
                if (ResourceBundlePropertyStructureViewElement.this.getPsiElement() != null && ResourceBundlePropertyStructureViewElement.this.myInspectedPropertyProblems != null && (highlightingAttributes = ResourceBundlePropertyStructureViewElement.this.myInspectedPropertyProblems.getTextAttributes(colorsScheme)) != null) {
                    return TextAttributes.merge((TextAttributes)baseAttrs, (TextAttributes)highlightingAttributes);
                }
                return baseAttrs;
            }
        };
        if (textAttributesPresentation == null) {
            ResourceBundlePropertyStructureViewElement.$$$reportNull$$$0(4);
        }
        return textAttributesPresentation;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    static {
        TextAttributes groupKeyTextAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_KEY).clone();
        groupKeyTextAttributes.setFontType(2);
        GROUP_KEY = TextAttributesKey.createTextAttributesKey((String)"GROUP_KEY", (TextAttributes)groupKeyTextAttributes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

