/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.jira.CachedIconLoader;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.ObjectUtils;
import icons.TasksCoreIcons;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JiraTask
extends Task {
    protected final TaskRepository myRepository;
    private volatile Icon myIcon;

    protected JiraTask(@NotNull TaskRepository repository) {
        if (repository == null) {
            JiraTask.$$$reportNull$$$0(0);
        }
        this.myRepository = repository;
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getSummary();

    public abstract String getDescription();

    @NotNull
    public abstract Comment[] getComments();

    @Nullable
    protected abstract String getIconUrl();

    @NotNull
    public abstract TaskType getType();

    public abstract TaskState getState();

    @Nullable
    public abstract Date getUpdated();

    public abstract Date getCreated();

    public final String getIssueUrl() {
        return this.myRepository.getUrl() + "/browse/" + this.getId();
    }

    @NotNull
    public final Icon getIcon() {
        if (this.myIcon == null) {
            String iconUrl = this.getIconUrl();
            this.myIcon = StringUtil.isEmpty((String)iconUrl) ? TasksCoreIcons.Jira : new DeferredIconImpl(TasksCoreIcons.Jira, (Object)iconUrl, false, JiraTask::getIconByUrl);
        }
        Icon icon = this.myIcon;
        if (icon == null) {
            JiraTask.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @Nullable
    public final TaskRepository getRepository() {
        return this.myRepository;
    }

    public final boolean isClosed() {
        return this.getState() == TaskState.RESOLVED;
    }

    public final boolean isIssue() {
        return true;
    }

    @NotNull
    protected static Icon getIconByUrl(@Nullable String iconUrl) {
        Icon icon = (Icon)ObjectUtils.notNull((Object)CachedIconLoader.getIcon(iconUrl), (Object)TasksIcons.Other);
        if (icon == null) {
            JiraTask.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Nullable
    protected final TaskState getStateById(int id) {
        switch (id) {
            case 1: {
                return TaskState.OPEN;
            }
            case 3: {
                return TaskState.IN_PROGRESS;
            }
            case 4: {
                return TaskState.REOPENED;
            }
            case 5: 
            case 6: {
                return TaskState.RESOLVED;
            }
        }
        return null;
    }

    protected final TaskType getTypeByName(@Nullable String type) {
        if (type == null) {
            return TaskType.OTHER;
        }
        if ("Bug".equals(type)) {
            return TaskType.BUG;
        }
        if ("Exception".equals(type)) {
            return TaskType.EXCEPTION;
        }
        if ("New Feature".equals(type)) {
            return TaskType.FEATURE;
        }
        return TaskType.OTHER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/jira/JiraTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/jira/JiraTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconByUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

