/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout.config.psi.impl;

import com.google.common.collect.Lists;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.buildout.config.BuildoutCfgFileType;
import com.jetbrains.python.buildout.config.BuildoutCfgLanguage;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgOption;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildoutCfgFile
extends PsiFileBase {
    public BuildoutCfgFile(FileViewProvider viewProvider) {
        super(viewProvider, (Language)BuildoutCfgLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        BuildoutCfgFileType buildoutCfgFileType = BuildoutCfgFileType.INSTANCE;
        if (buildoutCfgFileType == null) {
            BuildoutCfgFile.$$$reportNull$$$0(0);
        }
        return buildoutCfgFileType;
    }

    public String toString() {
        return "buildout.cfg file";
    }

    public Collection<BuildoutCfgSection> getSections() {
        return PsiTreeUtil.collectElementsOfType((PsiElement)this, (Class[])new Class[]{BuildoutCfgSection.class});
    }

    @Nullable
    public BuildoutCfgSection findSectionByName(String name) {
        Collection<BuildoutCfgSection> sections = this.getSections();
        for (BuildoutCfgSection section : sections) {
            if (!name.equals(section.getHeaderName())) continue;
            return section;
        }
        return null;
    }

    public List<String> getParts() {
        BuildoutCfgSection buildoutSection = this.findSectionByName("buildout");
        if (buildoutSection == null) {
            return Collections.emptyList();
        }
        BuildoutCfgOption option = buildoutSection.findOptionByName("parts");
        if (option == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (String value : option.getValues()) {
            result.addAll(StringUtil.split((String)value, (String)" "));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/config/psi/impl/BuildoutCfgFile", "getFileType"));
    }
}

