/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TObjectLongHashMap;
import gnu.trove.TObjectLongProcedure;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexingStamp {
    private static final long INDEX_DATA_OUTDATED_STAMP = -2L;
    private static final int VERSION = 15 + (SharedIndicesData.ourFileSharedIndicesEnabled ? 15 : 0) + (SharedIndicesData.DO_CHECKS ? 15 : 0);
    private static final ConcurrentMap<ID<?, ?>, IndexVersion> ourIndexIdToCreationStamp = ContainerUtil.newConcurrentMap();
    static final int INVALID_FILE_ID = 0;
    private static final int MIN_FS_MODIFIED_TIMESTAMP_RESOLUTION = 2000;
    private static final int OUR_INDICES_TIMESTAMP_INCREMENT = SystemProperties.getIntProperty((String)"idea.indices.timestamp.resolution", (int)1);
    private static final int ANY_CURRENT_INDEX_VERSION = Integer.MIN_VALUE;
    private static final long NO_VERSION = 0L;
    private static final IntObjectMap<Timestamps> myTimestampsCache = ContainerUtil.createConcurrentIntObjectMap();
    private static final BlockingQueue<Integer> ourFinishedFiles = new ArrayBlockingQueue<Integer>(100);
    private static final ReadWriteLock[] ourLocks = new ReadWriteLock[16];

    private IndexingStamp() {
    }

    public static void initPersistentIndexStamp(DataInput in) throws IOException {
        IndexVersion.advanceIndexStamp(DataInputOutputUtil.readTIME((DataInput)in));
    }

    public static void savePersistentIndexStamp(DataOutput out) throws IOException {
        DataInputOutputUtil.writeTIME((DataOutput)out, (long)IndexVersion.ourLastStamp);
    }

    public static synchronized void rewriteVersion(@NotNull ID<?, ?> indexId, int version) throws IOException {
        IndexVersion newIndexVersion;
        if (indexId == null) {
            IndexingStamp.$$$reportNull$$$0(0);
        }
        final File file2 = IndexInfrastructure.getVersionFile(indexId);
        if (FileBasedIndexImpl.LOG.isDebugEnabled()) {
            FileBasedIndexImpl.LOG.debug("Rewriting " + file2 + "," + version);
        }
        SharedIndicesData.beforeSomeIndexVersionInvalidation();
        IndexVersion previousIndexVersion = IndexingStamp.getIndexVersion(indexId, version);
        IndexVersion indexVersion = newIndexVersion = previousIndexVersion != null ? previousIndexVersion.nextVersion() : new IndexVersion();
        if (file2.exists()) {
            FileUtil.deleteWithRenaming((File)file2);
        }
        file2.getParentFile().mkdirs();
        try (DataOutputStream os = (DataOutputStream)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)new FileUtilRt.RepeatableIOOperation<DataOutputStream, FileNotFoundException>(){

            @Nullable
            public DataOutputStream execute(boolean lastAttempt) throws FileNotFoundException {
                try {
                    return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                }
                catch (FileNotFoundException ex) {
                    if (lastAttempt) {
                        throw ex;
                    }
                    return null;
                }
            }
        });){
            assert (os != null);
            DataInputOutputUtil.writeINT((DataOutput)os, (int)version);
            DataInputOutputUtil.writeINT((DataOutput)os, (int)VERSION);
            DataInputOutputUtil.writeTIME((DataOutput)os, (long)FSRecords.getCreationTimestamp());
            newIndexVersion.write(os);
            ourIndexIdToCreationStamp.put(indexId, newIndexVersion);
        }
    }

    public static boolean versionDiffers(@NotNull ID<?, ?> indexId, int currentIndexVersion) {
        if (indexId == null) {
            IndexingStamp.$$$reportNull$$$0(1);
        }
        return IndexingStamp.getIndexVersion(indexId, currentIndexVersion) == null;
    }

    public static long getIndexCreationStamp(@NotNull ID<?, ?> indexName) {
        IndexVersion version;
        if (indexName == null) {
            IndexingStamp.$$$reportNull$$$0(2);
        }
        return (version = IndexingStamp.getIndexVersion(indexName, Integer.MIN_VALUE)) != null ? version.myModificationCount : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static IndexVersion getIndexVersion(@NotNull ID<?, ?> indexName, int currentIndexVersion) {
        IndexVersion version;
        if (indexName == null) {
            IndexingStamp.$$$reportNull$$$0(3);
        }
        if ((version = (IndexVersion)ourIndexIdToCreationStamp.get(indexName)) != null) {
            return version;
        }
        Class<IndexingStamp> clazz = IndexingStamp.class;
        synchronized (IndexingStamp.class) {
            version = (IndexVersion)ourIndexIdToCreationStamp.get(indexName);
            if (version != null) {
                // ** MonitorExit[clazz] (shouldn't be in output)
                return version;
            }
            File versionFile = IndexInfrastructure.getVersionFile(indexName);
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(versionFile)));){
                if (DataInputOutputUtil.readINT((DataInput)in) != currentIndexVersion) {
                    if (currentIndexVersion != Integer.MIN_VALUE) return null;
                }
                if (DataInputOutputUtil.readINT((DataInput)in) != VERSION) return null;
                if (DataInputOutputUtil.readTIME((DataInput)in) != FSRecords.getCreationTimestamp()) return null;
                version = new IndexVersion(in);
                ourIndexIdToCreationStamp.put(indexName, version);
                IndexVersion indexVersion = version;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return indexVersion;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    public static boolean isFileIndexedStateCurrent(int fileId, ID<?, ?> indexName) {
        try {
            return IndexingStamp.getIndexStamp(fileId, indexName) == IndexingStamp.getIndexCreationStamp(indexName);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof IOException)) {
                throw e;
            }
            return false;
        }
    }

    public static void setFileIndexedStateCurrent(int fileId, ID<?, ?> id) {
        IndexingStamp.update(fileId, id, IndexingStamp.getIndexCreationStamp(id));
    }

    public static void setFileIndexedStateOutdated(int fileId, ID<?, ?> id) {
        IndexingStamp.update(fileId, id, -2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getIndexStamp(int fileId, ID<?, ?> indexName) {
        Lock readLock = IndexingStamp.getStripedLock(fileId).readLock();
        readLock.lock();
        try {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            if (stamp != null) {
                long l = stamp.get(indexName);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            readLock.unlock();
        }
    }

    private static Timestamps createOrGetTimeStamp(int id) {
        Timestamps timestamps;
        boolean isValid;
        boolean bl = isValid = id > 0;
        if (!isValid) {
            id = -id;
        }
        if ((timestamps = (Timestamps)myTimestampsCache.get(id)) == null) {
            try (DataInputStream stream = FSRecords.readAttributeWithLock(id, Timestamps.PERSISTENCE);){
                timestamps = new Timestamps(stream);
            }
            catch (IOException e) {
                FSRecords.handleError(e);
                throw new RuntimeException(e);
            }
            if (isValid) {
                myTimestampsCache.put(id, (Object)timestamps);
            }
        }
        return timestamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(int fileId, @NotNull ID<?, ?> indexName, long indexCreationStamp) {
        if (indexName == null) {
            IndexingStamp.$$$reportNull$$$0(4);
        }
        if (fileId < 0 || fileId == 0) {
            return;
        }
        Lock writeLock = IndexingStamp.getStripedLock(fileId).writeLock();
        writeLock.lock();
        try {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            if (stamp != null) {
                stamp.set(indexName, indexCreationStamp);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ID<?, ?>> getNontrivialFileIndexedStates(int fileId) {
        block7: {
            if (fileId != 0) {
                SmartList smartList;
                Lock readLock = IndexingStamp.getStripedLock(fileId).readLock();
                readLock.lock();
                try {
                    Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
                    if (stamp == null || stamp.myIndexStamps == null || stamp.myIndexStamps.isEmpty()) break block7;
                    SmartList retained = new SmartList();
                    stamp.myIndexStamps.forEach(object -> {
                        retained.add(object);
                        return true;
                    });
                    SmartList smartList2 = retained;
                    smartList = smartList2;
                }
                catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
                    break block7;
                }
                finally {
                    readLock.unlock();
                }
                if (smartList == null) {
                    IndexingStamp.$$$reportNull$$$0(5);
                }
                return smartList;
            }
        }
        List<ID<?, ?>> list2 = Collections.emptyList();
        if (list2 == null) {
            IndexingStamp.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public static void flushCaches() {
        IndexingStamp.flushCache(null);
    }

    public static void flushCache(@Nullable Integer finishedFile) {
        if (finishedFile != null && finishedFile == 0) {
            finishedFile = 0;
        }
        while (finishedFile == null || !ourFinishedFiles.offer(finishedFile)) {
            ArrayList files2 = new ArrayList(ourFinishedFiles.size());
            ourFinishedFiles.drainTo(files2);
            if (!files2.isEmpty()) {
                for (Integer file2 : files2) {
                    Lock writeLock = IndexingStamp.getStripedLock(file2).writeLock();
                    writeLock.lock();
                    try {
                        Timestamps timestamp = (Timestamps)myTimestampsCache.remove(file2.intValue());
                        if (timestamp == null || !timestamp.isDirty()) continue;
                        com.intellij.util.io.DataOutputStream sink = FSRecords.writeAttribute(file2, Timestamps.PERSISTENCE);
                        Throwable throwable = null;
                        try {
                            timestamp.writeToStream((DataOutputStream)sink);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (sink == null) continue;
                            if (throwable != null) {
                                try {
                                    sink.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            sink.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
            }
            if (finishedFile != null) continue;
            break;
        }
    }

    private static ReadWriteLock getStripedLock(int fileId) {
        if (fileId < 0) {
            fileId = -fileId;
        }
        return ourLocks[(fileId & 0xFF) % ourLocks.length];
    }

    static {
        for (int i = 0; i < ourLocks.length; ++i) {
            IndexingStamp.ourLocks[i] = new ReentrantReadWriteLock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexingStamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexingStamp";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNontrivialFileIndexedStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rewriteVersion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "versionDiffers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndexCreationStamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Timestamps {
        private static final FileAttribute PERSISTENCE = new FileAttribute("__index_stamps__", 2, false);
        private TObjectLongHashMap<ID<?, ?>> myIndexStamps;
        private boolean myIsDirty = false;

        private Timestamps(@Nullable DataInputStream stream) throws IOException {
            if (stream != null) {
                int[] outdatedIndices = null;
                long dominatingIndexStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                long diff = dominatingIndexStamp - 1040688000000L;
                if (diff > 0L && diff < 32767L) {
                    int numberOfOutdatedIndices = (int)diff;
                    outdatedIndices = new int[numberOfOutdatedIndices];
                    while (numberOfOutdatedIndices > 0) {
                        outdatedIndices[--numberOfOutdatedIndices] = DataInputOutputUtil.readINT((DataInput)stream);
                    }
                    dominatingIndexStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                }
                while (stream.available() > 0) {
                    long stamp;
                    ID id = ID.findById((int)DataInputOutputUtil.readINT((DataInput)stream));
                    if (id == null || id instanceof StubIndexKey || (stamp = IndexingStamp.getIndexCreationStamp(id)) == 0L) continue;
                    if (this.myIndexStamps == null) {
                        this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                    }
                    if (stamp > dominatingIndexStamp) continue;
                    this.myIndexStamps.put((Object)id, stamp);
                }
                if (outdatedIndices != null) {
                    for (int outdatedIndexId : outdatedIndices) {
                        ID id = ID.findById((int)outdatedIndexId);
                        if (id == null || id instanceof StubIndexKey || IndexingStamp.getIndexCreationStamp(id) == 0L) continue;
                        long stamp = -2L;
                        if (this.myIndexStamps == null) {
                            this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                        }
                        if (stamp > dominatingIndexStamp) continue;
                        this.myIndexStamps.put((Object)id, stamp);
                    }
                }
            }
        }

        private void writeToStream(final DataOutputStream stream) throws IOException {
            if (this.myIndexStamps != null && !this.myIndexStamps.isEmpty()) {
                final long[] data = new long[2];
                boolean dominatingStampIndex = false;
                boolean numberOfOutdatedIndex = true;
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    public boolean execute(ID<?, ?> a, long b) {
                        if (b == -2L) {
                            data[1] = data[1] + 1L;
                            b = IndexingStamp.getIndexCreationStamp(a);
                        }
                        data[0] = Math.max(data[0], b);
                        return true;
                    }
                });
                if (data[1] > 0L) {
                    assert (data[1] < 32767L);
                    DataInputOutputUtil.writeTIME((DataOutput)stream, (long)(1040688000000L + data[1]));
                    this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                        public boolean execute(ID<?, ?> id, long timestamp) {
                            try {
                                if (timestamp == -2L) {
                                    DataInputOutputUtil.writeINT((DataOutput)stream, (int)id.getUniqueId());
                                }
                                return true;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)data[0]);
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    public boolean execute(ID<?, ?> id, long timestamp) {
                        try {
                            if (timestamp == -2L) {
                                return true;
                            }
                            DataInputOutputUtil.writeINT((DataOutput)stream, (int)id.getUniqueId());
                            return true;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)1040688000000L);
            }
        }

        private long get(ID<?, ?> id) {
            return this.myIndexStamps != null ? this.myIndexStamps.get(id) : 0L;
        }

        private void set(ID<?, ?> id, long tmst) {
            if (this.myIndexStamps == null) {
                this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
            }
            if (tmst == -2L && !this.myIndexStamps.contains(id)) {
                return;
            }
            long previous = this.myIndexStamps.put(id, tmst);
            if (previous != tmst) {
                this.myIsDirty = true;
            }
        }

        public boolean isDirty() {
            return this.myIsDirty;
        }
    }

    static class IndexVersion {
        private static volatile long ourLastStamp;
        final long myModificationCount;

        IndexVersion() {
            this(IndexVersion.calcNextVersion(ourLastStamp));
        }

        private IndexVersion(long modificationCount) {
            this.myModificationCount = modificationCount;
            IndexVersion.advanceIndexStamp(modificationCount);
        }

        private static void advanceIndexStamp(long modificationCount) {
            ourLastStamp = Math.max(modificationCount, ourLastStamp);
        }

        IndexVersion(DataInput in) throws IOException {
            this.myModificationCount = DataInputOutputUtil.readTIME((DataInput)in);
            IndexVersion.advanceIndexStamp(this.myModificationCount);
        }

        public void write(DataOutput os) throws IOException {
            DataInputOutputUtil.writeTIME((DataOutput)os, (long)this.myModificationCount);
        }

        IndexVersion nextVersion() {
            return new IndexVersion(IndexVersion.calcNextVersion(this.myModificationCount));
        }

        private static long calcNextVersion(long modificationCount) {
            return Math.max(System.currentTimeMillis(), Math.max(modificationCount + 2000L, ourLastStamp + (long)OUR_INDICES_TIMESTAMP_INCREMENT));
        }
    }
}

