/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexState;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IdIterator;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileBasedIndex", storages={@Storage(value="stubIndex.xml", roamingType=RoamingType.DISABLED)})
public class StubIndexImpl
extends StubIndex
implements PersistentStateComponent<StubIndexState>,
BaseComponent {
    private static final AtomicReference<Boolean> ourForcedClean = new AtomicReference<Object>(null);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubIndexImpl");
    private final StubProcessingHelper myStubProcessingHelper;
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private volatile Future<AsyncState> myStateFuture;
    private volatile AsyncState myState;
    private volatile boolean myInitialized;
    private StubIndexState myPreviouslyRegistered;

    public StubIndexImpl(FileBasedIndex fileBasedIndex) {
        this.myStubProcessingHelper = new StubProcessingHelper(fileBasedIndex);
    }

    @Nullable
    static StubIndexImpl getInstanceOrInvalidate() {
        if (ourForcedClean.compareAndSet(null, Boolean.TRUE)) {
            return null;
        }
        return (StubIndexImpl)StubIndexImpl.getInstance();
    }

    private AsyncState getAsyncState() {
        AsyncState state = this.myState;
        if (state == null) {
            try {
                this.myState = state = this.myStateFuture.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K> boolean registerIndexer(final @NotNull StubIndexExtension<K, ?> extension, boolean forceClean, @NotNull AsyncState state) throws IOException {
        if (extension == null) {
            StubIndexImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            StubIndexImpl.$$$reportNull$$$0(1);
        }
        final StubIndexKey indexKey = extension.getKey();
        int version = extension.getVersion();
        AsyncState asyncState = state;
        synchronized (asyncState) {
            state.myIndexIdToVersionMap.put((Object)indexKey, version);
        }
        File indexRootDir = IndexInfrastructure.getIndexRootDir(indexKey);
        boolean needRebuild = false;
        if (forceClean || IndexingStamp.versionDiffers(indexKey, version)) {
            File versionFile = IndexInfrastructure.getVersionFile(indexKey);
            boolean versionFileExisted = versionFile.exists();
            String[] children2 = indexRootDir.list();
            boolean indexRootHasChildren = children2 != null && children2.length > 0;
            boolean bl = needRebuild = !forceClean && (versionFileExisted || indexRootHasChildren);
            if (needRebuild) {
                LOG.info("Version has changed for stub index " + extension.getKey() + ". The index will be rebuilt.");
            }
            if (indexRootHasChildren) {
                FileUtil.deleteWithRenaming((File)indexRootDir);
            }
            IndexingStamp.rewriteVersion(indexKey, version);
        }
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                VfsAwareMapIndexStorage storage2 = new VfsAwareMapIndexStorage(IndexInfrastructure.getStorageFile(indexKey), extension.getKeyDescriptor(), StubIdExternalizer.INSTANCE, extension.getCacheSize(), false, extension instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension).traceKeyHashToVirtualFileMapping());
                MemoryIndexStorage memStorage = new MemoryIndexStorage(storage2, (ID<?, ?>)indexKey);
                MyIndex index = new MyIndex(new IndexExtension<K, StubIdList, Void>(){

                    @NotNull
                    public ID<K, StubIdList> getName() {
                        StubIndexKey stubIndexKey = indexKey;
                        if (stubIndexKey == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return stubIndexKey;
                    }

                    @NotNull
                    public DataIndexer<K, StubIdList, Void> getIndexer() {
                        DataIndexer dataIndexer = inputData -> Collections.emptyMap();
                        if (dataIndexer == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return dataIndexer;
                    }

                    @NotNull
                    public KeyDescriptor<K> getKeyDescriptor() {
                        KeyDescriptor keyDescriptor = extension.getKeyDescriptor();
                        if (keyDescriptor == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return keyDescriptor;
                    }

                    @NotNull
                    public DataExternalizer<StubIdList> getValueExternalizer() {
                        StubIdExternalizer stubIdExternalizer = StubIdExternalizer.INSTANCE;
                        if (stubIdExternalizer == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return stubIdExternalizer;
                    }

                    public int getVersion() {
                        return extension.getVersion();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/psi/stubs/StubIndexImpl$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getName";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getIndexer";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getKeyDescriptor";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getValueExternalizer";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                }, memStorage);
                AsyncState asyncState2 = state;
                synchronized (asyncState2) {
                    state.myIndices.put(indexKey, index);
                    break;
                }
            }
            catch (IOException e) {
                needRebuild = true;
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version, indexRootDir, e);
                continue;
            }
            catch (RuntimeException e) {
                Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                if (cause == null) {
                    throw e;
                }
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version, indexRootDir, e);
            }
        }
        return needRebuild;
    }

    private static <K> void onExceptionInstantiatingIndex(@NotNull StubIndexKey<K, ?> indexKey, int version, @NotNull File indexRootDir, @NotNull Exception e) throws IOException {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(2);
        }
        if (indexRootDir == null) {
            StubIndexImpl.$$$reportNull$$$0(3);
        }
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(4);
        }
        LOG.info((Throwable)e);
        FileUtil.deleteWithRenaming((File)indexRootDir);
        IndexingStamp.rewriteVersion(indexKey, version);
    }

    public long getIndexModificationStamp(@NotNull StubIndexKey<?, ?> indexId, @NotNull Project project) {
        MyIndex index;
        if (indexId == null) {
            StubIndexImpl.$$$reportNull$$$0(5);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(6);
        }
        if ((index = (MyIndex)this.getAsyncState().myIndices.get(indexId)) != null) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, GlobalSearchScope.allScope((Project)project));
            return index.getModificationStamp();
        }
        return -1L;
    }

    public void flush() throws StorageException {
        if (!this.myInitialized) {
            return;
        }
        for (MyIndex index : this.getAsyncState().myIndices.values()) {
            index.flush();
        }
    }

    <K> void serializeIndexValue(@NotNull DataOutput out, @NotNull StubIndexKey<K, ?> stubIndexKey, @NotNull Map<K, StubIdList> map) throws IOException {
        MyIndex index;
        if (out == null) {
            StubIndexImpl.$$$reportNull$$$0(7);
        }
        if (stubIndexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(8);
        }
        if (map == null) {
            StubIndexImpl.$$$reportNull$$$0(9);
        }
        if ((index = (MyIndex)this.getAsyncState().myIndices.get(stubIndexKey)) == null) {
            return;
        }
        KeyDescriptor keyDescriptor = index.getExtension().getKeyDescriptor();
        DataInputOutputUtil.writeINT((DataOutput)out, (int)map.size());
        for (K key : map.keySet()) {
            keyDescriptor.save(out, key);
            StubIdExternalizer.INSTANCE.save(out, map.get(key));
        }
    }

    @NotNull
    <K> Map<K, StubIdList> deserializeIndexValue(@NotNull DataInput in, @NotNull StubIndexKey<K, ?> stubIndexKey) throws IOException {
        if (in == null) {
            StubIndexImpl.$$$reportNull$$$0(10);
        }
        if (stubIndexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(11);
        }
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(stubIndexKey);
        KeyDescriptor keyDescriptor = index.getExtension().getKeyDescriptor();
        int mapSize = DataInputOutputUtil.readINT((DataInput)in);
        THashMap result2 = new THashMap(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            Object key = keyDescriptor.read(in);
            StubIdList read2 = StubIdExternalizer.INSTANCE.read(in);
            result2.put(key, read2);
        }
        THashMap tHashMap = result2;
        if (tHashMap == null) {
            StubIndexImpl.$$$reportNull$$$0(12);
        }
        return tHashMap;
    }

    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, final @NotNull Project project, final @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, final @NotNull Class<Psi> requiredClass, final @NotNull Processor<? super Psi> processor2) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(13);
        }
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(14);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(15);
        }
        if (requiredClass == null) {
            StubIndexImpl.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            StubIndexImpl.$$$reportNull$$$0(17);
        }
        return this.doProcessStubs(indexKey, key, project, scope, new StubIdListContainerAction(idFilter, project){
            final PersistentFS fs;
            {
                super(idFilter, project3);
                this.fs = (PersistentFS)ManagingFS.getInstance();
            }

            @Override
            protected boolean process(int id, @NotNull StubIdList value) {
                VirtualFile file2;
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((file2 = IndexInfrastructure.findFileByIdIfCached(this.fs, id)) == null || scope != null && !scope.contains(file2)) {
                    return true;
                }
                return StubIndexImpl.this.myStubProcessingHelper.processStubsInFile(project, file2, value, processor2, scope, requiredClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/stubs/StubIndexImpl$2", "process"));
            }
        });
    }

    private <Key> boolean doProcessStubs(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @NotNull StubIdListContainerAction action) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(18);
        }
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(19);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(20);
        }
        if (action == null) {
            StubIndexImpl.$$$reportNull$$$0(21);
        }
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        ID<Integer, SerializedStubTree> stubUpdatingIndexId = StubUpdatingIndex.INDEX_ID;
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(indexKey);
        if (index == null) {
            return true;
        }
        fileBasedIndex.ensureUpToDate(stubUpdatingIndexId, project, scope);
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = fileBasedIndex.getIndex(stubUpdatingIndexId);
        try {
            return (Boolean)this.myAccessValidator.validate(stubUpdatingIndexId, () -> {
                try {
                    Boolean bl = (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> (Boolean)ConcurrencyUtil.withLock((Lock)stubUpdatingIndex.getReadLock(), () -> index.getData(key).forEach((ValueContainer.ContainerAction)action)));
                    return bl;
                }
                finally {
                    this.wipeProblematicFileIdsForParticularKeyAndStubIndex(indexKey, key, stubUpdatingIndex);
                }
            });
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.forceRebuild(cause);
            }
            throw e;
        }
        return true;
    }

    private <Key> void wipeProblematicFileIdsForParticularKeyAndStubIndex(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key, @NotNull UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex) {
        Set<VirtualFile> filesWithProblems;
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(22);
        }
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(23);
        }
        if (stubUpdatingIndex == null) {
            StubIndexImpl.$$$reportNull$$$0(24);
        }
        if ((filesWithProblems = this.myStubProcessingHelper.takeAccumulatedFilesWithIndexProblems()) != null) {
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).runCleanupAction(() -> {
                boolean locked = stubUpdatingIndex.getWriteLock().tryLock();
                if (!locked) {
                    return;
                }
                try {
                    THashMap artificialOldValues = new THashMap();
                    artificialOldValues.put(key, new StubIdList());
                    for (VirtualFile file2 : filesWithProblems) {
                        this.updateIndex(indexKey, FileBasedIndex.getFileId((VirtualFile)file2), (Map)artificialOldValues, Collections.emptyMap());
                    }
                }
                finally {
                    stubUpdatingIndex.getWriteLock().unlock();
                }
            });
        }
    }

    public void forceRebuild(@NotNull Throwable e) {
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(25);
        }
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    private static void requestRebuild() {
        FileBasedIndex.getInstance().requestRebuild(StubUpdatingIndex.INDEX_ID);
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(26);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(27);
        }
        THashSet allKeys = ContainerUtil.newTroveSet();
        this.processAllKeys(indexKey, project, Processors.cancelableCollectProcessor((Collection)allKeys));
        THashSet tHashSet = allKeys;
        if (tHashSet == null) {
            StubIndexImpl.$$$reportNull$$$0(28);
        }
        return tHashSet;
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        MyIndex index;
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(29);
        }
        if (processor2 == null) {
            StubIndexImpl.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            StubIndexImpl.$$$reportNull$$$0(31);
        }
        if ((index = (MyIndex)this.getAsyncState().myIndices.get(indexKey)) == null) {
            return true;
        }
        FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope.getProject(), scope);
        try {
            return (Boolean)this.myAccessValidator.validate(StubUpdatingIndex.INDEX_ID, () -> (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> index.processAllKeys(processor2, scope, idFilter)));
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                this.forceRebuild(e);
            }
            throw e;
        }
        return true;
    }

    @NotNull
    public <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(32);
        }
        if (dataKey == null) {
            StubIndexImpl.$$$reportNull$$$0(33);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            StubIndexImpl.$$$reportNull$$$0(35);
        }
        final TIntArrayList result2 = new TIntArrayList();
        this.doProcessStubs(indexKey, dataKey, project, scope, new StubIdListContainerAction(null, project){

            @Override
            protected boolean process(int id, @NotNull StubIdList value) {
                if (value == null) {
                    3.$$$reportNull$$$0(0);
                }
                result2.add(id);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/stubs/StubIndexImpl$3", "process"));
            }
        });
        IdIterator idIterator = new IdIterator(){
            int cursor;

            public boolean hasNext() {
                return this.cursor < result2.size();
            }

            public int next() {
                return result2.get(this.cursor++);
            }

            public int size() {
                return result2.size();
            }
        };
        if (idIterator == null) {
            StubIndexImpl.$$$reportNull$$$0(36);
        }
        return idIterator;
    }

    public void initComponent() {
        long started = System.nanoTime();
        List<Object> extensions = IndexInfrastructure.hasIndices() ? StubIndexImpl.initExtensions() : Collections.emptyList();
        LOG.info("All stub exts enumerated:" + (System.nanoTime() - started) / 1000000L + ", number of extensions:" + extensions.size());
        started = System.nanoTime();
        this.myStateFuture = IndexInfrastructure.submitGenesisTask(new StubIndexInitialization(extensions));
        LOG.info("stub exts update scheduled:" + (System.nanoTime() - started) / 1000000L);
        if (!IndexInfrastructure.ourDoAsyncIndicesInitialization) {
            try {
                this.myStateFuture.get();
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    @NotNull
    static List<StubIndexExtension<?, ?>> initExtensions() {
        List extensions = StubIndexExtension.EP_NAME.getExtensionList();
        for (StubIndexExtension extension : extensions) {
            extension.getKey();
        }
        List list2 = extensions;
        if (list2 == null) {
            StubIndexImpl.$$$reportNull$$$0(37);
        }
        return list2;
    }

    public void dispose() {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            index.dispose();
        }
    }

    void setDataBufferingEnabled(boolean enabled) {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            IndexStorage indexStorage = ((MapReduceIndex)index).getStorage();
            ((MemoryIndexStorage)indexStorage).setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupMemoryStorage() {
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID);
        stubUpdatingIndex.getWriteLock().lock();
        try {
            for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
                IndexStorage indexStorage = ((MapReduceIndex)index).getStorage();
                ((MemoryIndexStorage)indexStorage).clearMemoryMap();
            }
        }
        finally {
            stubUpdatingIndex.getWriteLock().unlock();
        }
    }

    void clearAllIndices() {
        if (!this.myInitialized) {
            return;
        }
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            try {
                index.clear();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    <K> void removeTransientDataForFile(@NotNull StubIndexKey<K, ?> key, int inputId, @NotNull Collection<? extends K> keys) {
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(38);
        }
        if (keys == null) {
            StubIndexImpl.$$$reportNull$$$0(39);
        }
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(key);
        index.removeTransientDataForKeys(inputId, keys);
    }

    private boolean dropUnregisteredIndices(@NotNull AsyncState state) {
        if (state == null) {
            StubIndexImpl.$$$reportNull$$$0(40);
        }
        if (ApplicationManager.getApplication().isDisposed() || !IndexInfrastructure.hasIndices()) {
            return false;
        }
        HashSet indicesToDrop = new HashSet(this.myPreviouslyRegistered != null ? this.myPreviouslyRegistered.registeredIndices : Collections.emptyList());
        for (ID key : state.myIndices.keySet()) {
            indicesToDrop.remove(key.getName());
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + StringUtil.join(indicesToDrop, (String)","));
            for (String s : indicesToDrop) {
                FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(StubIndexKey.createIndexKey((String)s)));
            }
            return true;
        }
        return false;
    }

    public StubIndexState getState() {
        if (!this.myInitialized) {
            return null;
        }
        return new StubIndexState(this.getAsyncState().myIndices.keySet());
    }

    public void loadState(@NotNull StubIndexState state) {
        if (state == null) {
            StubIndexImpl.$$$reportNull$$$0(41);
        }
        this.myPreviouslyRegistered = state;
    }

    public <K> void updateIndex(@NotNull StubIndexKey key, int fileId, @NotNull Map<K, StubIdList> oldValues, @NotNull Map<K, StubIdList> newValues) {
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(42);
        }
        if (oldValues == null) {
            StubIndexImpl.$$$reportNull$$$0(43);
        }
        if (newValues == null) {
            StubIndexImpl.$$$reportNull$$$0(44);
        }
        try {
            MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(key);
            if (index == null) {
                return;
            }
            ThrowableComputable oldMapGetter = () -> new MapInputDataDiffBuilder(fileId, oldValues);
            index.updateWithMap(fileId, new UpdateData(newValues, oldMapGetter, (IndexId)key, null));
        }
        catch (StorageException e) {
            LOG.info((Throwable)e);
            StubIndexImpl.requestRebuild();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 28: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 28: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 13: 
            case 18: 
            case 22: 
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexRootDir";
                break;
            }
            case 4: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 6: 
            case 15: 
            case 20: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexKey";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 12: 
            case 28: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
            case 14: 
            case 19: 
            case 23: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubUpdatingIndex";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValues";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeIndexValue";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingIds";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "initExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onExceptionInstantiatingIndex";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serializeIndexValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserializeIndexValue";
                break;
            }
            case 12: 
            case 28: 
            case 36: 
            case 37: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doProcessStubs";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "wipeProblematicFileIdsForParticularKeyAndStubIndex";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "forceRebuild";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getContainingIds";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "dropUnregisteredIndices";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 28: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StubIndexInitialization
    extends IndexInfrastructure.DataInitialization<AsyncState> {
        private final AsyncState state;
        private final StringBuilder updated;
        private final List<? extends StubIndexExtension<?, ?>> myExtensions;

        StubIndexInitialization(List<? extends StubIndexExtension<?, ?>> extensions) {
            if (extensions == null) {
                StubIndexInitialization.$$$reportNull$$$0(0);
            }
            this.state = new AsyncState();
            this.updated = new StringBuilder();
            this.myExtensions = extensions;
        }

        @Override
        protected void prepare() {
            boolean forceClean = Boolean.TRUE == ourForcedClean.getAndSet(Boolean.FALSE);
            for (StubIndexExtension<?, ?> extension : this.myExtensions) {
                this.addNestedInitializationTask(() -> {
                    boolean rebuildRequested = StubIndexImpl.registerIndexer(extension, forceClean, this.state);
                    if (rebuildRequested) {
                        StringBuilder stringBuilder = this.updated;
                        synchronized (stringBuilder) {
                            this.updated.append(extension).append(' ');
                        }
                    }
                });
            }
        }

        @Override
        protected void onThrowable(@NotNull Throwable t) {
            if (t == null) {
                StubIndexInitialization.$$$reportNull$$$0(1);
            }
            LOG.error(t);
        }

        @Override
        protected AsyncState finish() {
            boolean someIndicesWereDropped = StubIndexImpl.this.dropUnregisteredIndices(this.state);
            if (someIndicesWereDropped) {
                this.updated.append(" and some indices were dropped");
            }
            if (this.updated.length() > 0) {
                Throwable e = new Throwable(this.updated.toString());
                ApplicationManager.getApplication().invokeLater(() -> StubIndexImpl.this.forceRebuild(e), ModalityState.NON_MODAL);
            }
            StubIndexImpl.this.myInitialized = true;
            return this.state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl$StubIndexInitialization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onThrowable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class StubIdListContainerAction
    implements ValueContainer.ContainerAction<StubIdList> {
        private final IdFilter myIdFilter;

        StubIdListContainerAction(@Nullable IdFilter idFilter, @NotNull Project project) {
            if (project == null) {
                StubIdListContainerAction.$$$reportNull$$$0(0);
            }
            this.myIdFilter = idFilter != null ? idFilter : ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project);
        }

        public boolean perform(int id, @NotNull StubIdList value) {
            if (value == null) {
                StubIdListContainerAction.$$$reportNull$$$0(1);
            }
            ProgressManager.checkCanceled();
            if (this.myIdFilter != null && !this.myIdFilter.containsFileId(id)) {
                return true;
            }
            return this.process(id, value);
        }

        protected abstract boolean process(int var1, @NotNull StubIdList var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl$StubIdListContainerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyIndex<K>
    extends VfsAwareMapReduceIndex<K, StubIdList, Void> {
        @NotNull
        protected ReentrantReadWriteLock createLock() {
            UpdatableIndex<Integer, SerializedStubTree, FileContent> index = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID);
            ReentrantReadWriteLock reentrantReadWriteLock = ((MapReduceIndex)index).getLock();
            if (reentrantReadWriteLock == null) {
                MyIndex.$$$reportNull$$$0(0);
            }
            return reentrantReadWriteLock;
        }

        MyIndex(@NotNull IndexExtension<K, StubIdList, Void> extension, @NotNull IndexStorage<K, StubIdList> storage2) throws IOException {
            if (extension == null) {
                MyIndex.$$$reportNull$$$0(1);
            }
            if (storage2 == null) {
                MyIndex.$$$reportNull$$$0(2);
            }
            super(extension, storage2, null);
        }

        public void updateWithMap(int inputId, @NotNull UpdateData<K, StubIdList> updateData) throws StorageException {
            if (updateData == null) {
                MyIndex.$$$reportNull$$$0(3);
            }
            super.updateWithMap(inputId, updateData);
        }

        @NotNull
        public IndexExtension<K, StubIdList, Void> getExtension() {
            IndexExtension indexExtension = this.myExtension;
            if (indexExtension == null) {
                MyIndex.$$$reportNull$$$0(4);
            }
            return indexExtension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubIndexImpl$MyIndex";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLock";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl$MyIndex";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateWithMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StubIdExternalizer
    implements DataExternalizer<StubIdList> {
        private static final StubIdExternalizer INSTANCE = new StubIdExternalizer();

        private StubIdExternalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull StubIdList value) throws IOException {
            int size;
            if (out == null) {
                StubIdExternalizer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                StubIdExternalizer.$$$reportNull$$$0(1);
            }
            if ((size = value.size()) == 0) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)Integer.MAX_VALUE);
            } else if (size == 1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(0));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-size));
                for (int i = 0; i < size; ++i) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(i));
                }
            }
        }

        @NotNull
        public StubIdList read(@NotNull DataInput in) throws IOException {
            int size;
            if (in == null) {
                StubIdExternalizer.$$$reportNull$$$0(2);
            }
            if ((size = DataInputOutputUtil.readINT((DataInput)in)) == Integer.MAX_VALUE) {
                StubIdList stubIdList = new StubIdList();
                if (stubIdList == null) {
                    StubIdExternalizer.$$$reportNull$$$0(3);
                }
                return stubIdList;
            }
            if (size >= 0) {
                StubIdList stubIdList = new StubIdList(size);
                if (stubIdList == null) {
                    StubIdExternalizer.$$$reportNull$$$0(4);
                }
                return stubIdList;
            }
            size = -size;
            int[] result2 = new int[size];
            for (int i = 0; i < size; ++i) {
                result2[i] = DataInputOutputUtil.readINT((DataInput)in);
            }
            StubIdList stubIdList = new StubIdList(result2, size);
            if (stubIdList == null) {
                StubIdExternalizer.$$$reportNull$$$0(5);
            }
            return stubIdList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubIndexImpl$StubIdExternalizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl$StubIdExternalizer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AsyncState {
        private final Map<StubIndexKey<?, ?>, MyIndex<?>> myIndices = new THashMap();
        private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();

        private AsyncState() {
        }
    }
}

