/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsAnnotationLocalChangesListenerImpl
implements Disposable,
VcsAnnotationLocalChangesListener {
    private static final Logger LOG = Logger.getInstance(VcsAnnotationLocalChangesListenerImpl.class);
    private final ZipperUpdater myUpdater;
    private final MessageBusConnection myConnection;
    private final Runnable myUpdateStuff;
    private final Set<String> myDirtyPaths;
    private final Set<VirtualFile> myDirtyFiles;
    private final Map<String, VcsRevisionNumber> myDirtyChanges;
    private final LocalFileSystem myLocalFileSystem;
    private final ProjectLevelVcsManager myVcsManager;
    private final Set<VcsKey> myVcsKeySet;
    private final Object myLock;
    private final MultiMap<VirtualFile, FileAnnotation> myFileAnnotationMap;

    public VcsAnnotationLocalChangesListenerImpl(@NotNull Project project, ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myUpdateStuff = this.createUpdateStuff();
        this.myUpdater = new ZipperUpdater(ApplicationManager.getApplication().isUnitTestMode() ? 10 : 300, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        this.myConnection = project.getMessageBus().connect();
        this.myLocalFileSystem = LocalFileSystem.getInstance();
        VcsAnnotationRefresher handler2 = this.createHandler();
        this.myDirtyPaths = new HashSet<String>();
        this.myDirtyChanges = new HashMap<String, VcsRevisionNumber>();
        this.myDirtyFiles = new HashSet<VirtualFile>();
        this.myFileAnnotationMap = MultiMap.createSet();
        this.myVcsManager = vcsManager;
        this.myVcsKeySet = new HashSet<VcsKey>();
        this.myConnection.subscribe(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED, (Object)handler2);
    }

    public void calmDown() {
        while (!this.myUpdater.isEmpty()) {
            TimeoutUtil.sleep((long)1L);
        }
    }

    private Runnable createUpdateStuff() {
        return () -> {
            HashSet<VirtualFile> files2;
            HashMap<String, VcsRevisionNumber> changes2;
            HashSet<String> paths;
            HashSet<VcsKey> vcsToRefresh;
            Object object = this.myLock;
            synchronized (object) {
                vcsToRefresh = new HashSet<VcsKey>(this.myVcsKeySet);
                paths = new HashSet<String>(this.myDirtyPaths);
                changes2 = new HashMap<String, VcsRevisionNumber>(this.myDirtyChanges);
                files2 = new HashSet<VirtualFile>(this.myDirtyFiles);
                this.myDirtyPaths.clear();
                this.myDirtyChanges.clear();
                this.myVcsKeySet.clear();
                this.myDirtyFiles.clear();
            }
            this.closeForVcs(vcsToRefresh);
            this.checkByDirtyScope(paths, changes2, files2);
        };
    }

    private void checkByDirtyScope(Set<String> removed, Map<String, VcsRevisionNumber> refresh2, Set<VirtualFile> files2) {
        for (String string : removed) {
            this.refreshForPath(string, null);
        }
        for (Map.Entry entry : refresh2.entrySet()) {
            this.refreshForPath((String)entry.getKey(), (VcsRevisionNumber)entry.getValue());
        }
        for (VirtualFile virtualFile : files2) {
            this.processUnderFile(virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnderFile(VirtualFile file2) {
        MultiMap annotations = new MultiMap();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            for (VirtualFile virtualFile : this.myFileAnnotationMap.keySet()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)virtualFile, (boolean)true)) continue;
                Collection values = this.myFileAnnotationMap.get((Object)virtualFile);
                for (FileAnnotation value : values) {
                    annotations.putValue((Object)virtualFile, (Object)value);
                }
            }
        }
        if (!annotations.isEmpty()) {
            for (Map.Entry entry : annotations.entrySet()) {
                VirtualFile key = (VirtualFile)entry.getKey();
                VcsRevisionNumber number = this.fromDiffProvider(key);
                if (number == null) continue;
                Collection fileAnnotations = (Collection)entry.getValue();
                List copy = ContainerUtil.filter((Collection)fileAnnotations, it -> it.isBaseRevisionChanged(number));
                VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, false);
            }
        }
    }

    private void refreshForPath(String path, VcsRevisionNumber number) {
        File file2 = new File(path);
        VirtualFile vf = this.myLocalFileSystem.findFileByIoFile(file2);
        if (vf == null) {
            vf = this.myLocalFileSystem.refreshAndFindFileByIoFile(file2);
        }
        if (vf == null) {
            return;
        }
        this.processFile(number, vf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(VcsRevisionNumber number, VirtualFile vf) {
        ArrayList annotations;
        Object object = this.myLock;
        synchronized (object) {
            annotations = ContainerUtil.newArrayList((Iterable)this.myFileAnnotationMap.get((Object)vf));
        }
        if (!annotations.isEmpty()) {
            if (number == null) {
                number = this.fromDiffProvider(vf);
            }
            if (number == null) {
                return;
            }
            VcsRevisionNumber finalNumber = number;
            List copy = ContainerUtil.filter((Collection)annotations, it -> it.isBaseRevisionChanged(finalNumber));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, false);
        }
    }

    private VcsRevisionNumber fromDiffProvider(VirtualFile vf) {
        DiffProvider diffProvider;
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(vf);
        if (vcsRoot != null && vcsRoot.getVcs() != null && (diffProvider = vcsRoot.getVcs().getDiffProvider()) != null) {
            return diffProvider.getCurrentRevision(vf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeForVcs(Set<VcsKey> refresh2) {
        if (refresh2.isEmpty()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            List copy = ContainerUtil.filter((Collection)this.myFileAnnotationMap.values(), it -> it.getVcsKey() != null && refresh2.contains(it.getVcsKey()));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, false);
        }
    }

    private static void invalidateAnnotations(@NotNull Collection<FileAnnotation> annotations, boolean reload2) {
        if (annotations == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (FileAnnotation annotation : annotations) {
                try {
                    if (reload2) {
                        annotation.reload(null);
                        continue;
                    }
                    annotation.close();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAnnotation(VirtualFile file2, FileAnnotation annotation) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFileAnnotationMap.putValue((Object)file2, (Object)annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAnnotation(VirtualFile file2, FileAnnotation annotation) {
        Object object = this.myLock;
        synchronized (object) {
            Collection annotations = this.myFileAnnotationMap.get((Object)file2);
            if (!annotations.isEmpty()) {
                annotations.remove(annotation);
            }
            if (annotations.isEmpty()) {
                this.myFileAnnotationMap.remove((Object)file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAnnotationsForVcs(@NotNull VcsKey key) {
        if (key == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            List copy = ContainerUtil.filter((Collection)this.myFileAnnotationMap.values(), it -> key.equals((Object)it.getVcsKey()));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, true);
        }
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.myUpdater.stop();
    }

    private VcsAnnotationRefresher createHandler() {
        return new VcsAnnotationRefresher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dirtyUnder(VirtualFile file2) {
                if (file2 == null) {
                    return;
                }
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyFiles.add(file2);
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dirty(BaseRevision currentRevision) {
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyChanges.put(currentRevision.getPath(), currentRevision.getRevision());
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dirty(String path) {
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyPaths.add(path);
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void configurationChanged(VcsKey vcsKey) {
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myVcsKeySet.add(vcsKey);
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsAnnotationLocalChangesListenerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadAnnotationsForVcs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

