/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.diff.impl.DiffToolbarComponent;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDiffViewer
implements DiffViewer {
    @NotNull
    private final DiffRequest myRequest;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final DiffToolbarComponent myToolbar;

    protected ErrorDiffViewer(Window window, @NotNull DiffRequest request) {
        if (request == null) {
            ErrorDiffViewer.$$$reportNull$$$0(0);
        }
        this.myRequest = request;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setFocusable(true);
        final ActionManager actionManager = ActionManager.getInstance();
        this.myToolbar = new DiffToolbarComponent(this.myPanel);
        DiffRequest.ToolbarAddons addons = new DiffRequest.ToolbarAddons(){

            public void customize(DiffToolbar toolbar) {
                toolbar.addAction(actionManager.getAction("DiffPanel.Toolbar"));
                toolbar.addAction(actionManager.getAction("ContextHelp"));
                toolbar.addSeparator();
            }
        };
        this.myToolbar.resetToolbar(addons);
        this.myPanel.add((Component)this.myToolbar, "North");
        DiffContent content1 = this.myRequest.getContents()[0];
        DiffContent content2 = this.myRequest.getContents()[1];
        String message = DiffUtil.oneIsUnknown(content1, content2) ? DiffBundle.message((String)"diff.can.not.show.unknown", (Object[])new Object[0]) : DiffBundle.message((String)"diff.can.not.show", (Object[])new Object[0]);
        JPanel messagePanel = ErrorDiffViewer.createMessagePanel(message);
        this.myPanel.add((Component)messagePanel, "Center");
        ErrorDiffViewer.setWindowTitle(window, request.getWindowTitle());
    }

    private static void setWindowTitle(Window window, String title) {
        if (title == null || title.isEmpty()) {
            title = "Diff";
        }
        if (window instanceof JDialog) {
            ((JDialog)window).setTitle(title);
        } else if (window instanceof JFrame) {
            ((JFrame)window).setTitle(title);
        }
    }

    public boolean canShowRequest(DiffRequest request) {
        return false;
    }

    public void setDiffRequest(DiffRequest request) {
        throw new IllegalStateException();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    private static JPanel createMessagePanel(@NotNull String message) {
        if (message == null) {
            ErrorDiffViewer.$$$reportNull$$$0(1);
        }
        JLabel label2 = new JLabel(message);
        label2.setForeground(UIUtil.getInactiveTextColor());
        JPanel wrapper2 = new JPanel(new GridBagLayout());
        wrapper2.add((Component)label2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insets((int)1), 0, 0));
        JPanel jPanel = wrapper2;
        if (jPanel == null) {
            ErrorDiffViewer.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    public boolean acceptsType(DiffViewerType type) {
        return DiffViewerType.empty.equals((Object)type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/ErrorDiffViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/ErrorDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessagePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMessagePanel";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

