/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.LightweightHint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUtil {
    private static final Key<Direction> KEY = Key.create((String)"FindUtil.KEY");

    private FindUtil() {
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Editor myEditor) {
        Project project;
        if (myEditor == null) {
            FindUtil.$$$reportNull$$$0(0);
        }
        PsiFile file2 = (project = myEditor.getProject()) != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(myEditor.getDocument()) : null;
        return file2 != null ? file2.getVirtualFile() : null;
    }

    public static void initStringToFindWithSelection(FindModel findModel, @Nullable Editor editor) {
        String s;
        if (editor != null && (s = editor.getSelectionModel().getSelectedText()) != null && s.length() < 10000) {
            FindModel.initStringToFind((FindModel)findModel, (String)s);
        }
    }

    public static void configureFindModel(boolean replace, @Nullable Editor editor, FindModel model, boolean firstSearch) {
        String selectedText;
        boolean isGlobal = true;
        String stringToFind = firstSearch ? "" : model.getStringToFind();
        SelectionModel selectionModel = editor != null ? editor.getSelectionModel() : null;
        String string = selectedText = selectionModel != null ? selectionModel.getSelectedText() : null;
        if (!StringUtil.isEmpty((String)selectedText)) {
            stringToFind = selectedText;
        }
        model.setReplaceState(replace);
        boolean multiline = stringToFind.contains("\n");
        if (replace && multiline) {
            isGlobal = false;
            stringToFind = "";
            multiline = false;
        }
        model.setStringToFind(stringToFind);
        model.setMultiline(multiline);
        model.setGlobal(isGlobal);
        model.setPromptOnReplace(false);
    }

    public static void updateFindInFileModel(@Nullable Project project, @NotNull FindModel with2, boolean saveFindString) {
        if (with2 == null) {
            FindUtil.$$$reportNull$$$0(1);
        }
        FindModel model = FindManager.getInstance((Project)project).getFindInFileModel();
        model.setCaseSensitive(with2.isCaseSensitive());
        model.setWholeWordsOnly(with2.isWholeWordsOnly());
        model.setRegularExpressions(with2.isRegularExpressions());
        model.setSearchContext(with2.getSearchContext());
        if (saveFindString && !with2.getStringToFind().isEmpty()) {
            model.setStringToFind(with2.getStringToFind());
        }
        if (with2.isReplaceState()) {
            model.setPreserveCase(with2.isPreserveCase());
            if (saveFindString) {
                model.setStringToReplace(with2.getStringToReplace());
            }
        }
    }

    public static void useFindStringFromFindInFileModel(FindModel findModel, Editor editor) {
        EditorSearchSession editorSearchSession;
        if (editor != null && (editorSearchSession = EditorSearchSession.get(editor)) != null) {
            FindModel currentFindModel = editorSearchSession.getFindModel();
            findModel.setStringToFind(currentFindModel.getStringToFind());
            if (findModel.isReplaceState()) {
                findModel.setStringToReplace(currentFindModel.getStringToReplace());
            }
        }
    }

    public static void findWordAtCaret(Project project, Editor editor) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int start2 = 0;
        int end = document.getTextLength();
        if (!editor.getSelectionModel().hasSelection()) {
            char c;
            int i;
            for (i = caretOffset - 1; i >= 0; --i) {
                c = text.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                start2 = i + 1;
                break;
            }
            for (i = caretOffset; i < document.getTextLength(); ++i) {
                c = text.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                end = i;
                break;
            }
        } else {
            start2 = editor.getSelectionModel().getSelectionStart();
            end = editor.getSelectionModel().getSelectionEnd();
        }
        if (start2 >= end) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)project);
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(project);
        String s = text.subSequence(start2, end).toString();
        findInProjectSettings.addStringToFind(s);
        findManager.getFindInFileModel().setStringToFind(s);
        findManager.setFindWasPerformed();
        findManager.clearFindingNextUsageInFile();
        FindModel model = new FindModel();
        model.setStringToFind(s);
        model.setCaseSensitive(true);
        model.setWholeWordsOnly(!editor.getSelectionModel().hasSelection());
        EditorSearchSession searchSession = EditorSearchSession.get(editor);
        if (searchSession != null) {
            searchSession.setTextInField(model.getStringToFind());
        }
        findManager.setFindNextModel(model);
        FindUtil.doSearch(project, editor, caretOffset, true, model, true);
    }

    public static void find(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            FindUtil.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FindManager findManager = FindManager.getInstance((Project)project);
        String s = editor.getSelectionModel().getSelectedText();
        FindModel model = findManager.getFindInFileModel().clone();
        if (StringUtil.isEmpty((String)s)) {
            model.setGlobal(true);
        } else if (s.indexOf(10) >= 0) {
            model.setGlobal(false);
        } else {
            model.setStringToFind(s);
            model.setGlobal(true);
        }
        model.setReplaceState(false);
        model.setFindAllEnabled(PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) != null);
        findManager.showFindDialog(model, () -> {
            int offset;
            if (model.isFindAll()) {
                findManager.setFindNextModel(model);
                FindUtil.findAllAndShow(project, editor, model);
                return;
            }
            if (!model.isGlobal() && editor.getSelectionModel().hasSelection()) {
                offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                ScrollType scrollType = model.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                FindUtil.moveCaretAndDontChangeSelection(editor, offset, scrollType);
            }
            if (model.isGlobal()) {
                offset = model.isFromCursor() ? editor.getCaretModel().getOffset() : (model.isForward() ? 0 : editor.getDocument().getTextLength());
            } else {
                if (!editor.getSelectionModel().hasSelection()) {
                    findManager.setFindNextModel(null);
                    return;
                }
                offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
            }
            findManager.setFindNextModel(null);
            findManager.getFindInFileModel().copyFrom(model);
            FindUtil.doSearch(project, editor, offset, true, model, true);
        });
    }

    @Nullable
    public static List<Usage> findAll(@NotNull Project project, @NotNull Editor editor, @NotNull FindModel findModel) {
        if (project == null) {
            FindUtil.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(5);
        }
        if (findModel == null) {
            FindUtil.$$$reportNull$$$0(6);
        }
        return FindUtil.findAll(project, PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()), findModel);
    }

    @Nullable
    private static List<Usage> findAll(@NotNull Project project, @Nullable PsiFile psiFile, @NotNull FindModel findModel) {
        FindResult result2;
        if (project == null) {
            FindUtil.$$$reportNull$$$0(7);
        }
        if (findModel == null) {
            FindUtil.$$$reportNull$$$0(8);
        }
        if (psiFile == null || project.isDisposed()) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        CharSequence text = document.getCharsSequence();
        int textLength = document.getTextLength();
        FindManager findManager = FindManager.getInstance((Project)project);
        findModel.setForward(true);
        int offset = 0;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        ArrayList<Usage> usages = new ArrayList<Usage>();
        while (offset < textLength && (result2 = findManager.findString(text, offset, findModel, virtualFile)).isStringFound()) {
            usages.add((Usage)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiFile, result2.getStartOffset(), result2.getEndOffset())));
            int prevOffset = offset;
            if (prevOffset != (offset = result2.getEndOffset())) continue;
            ++offset;
        }
        return usages;
    }

    public static void findAllAndShow(@NotNull Project project, @NotNull Editor editor, @NotNull FindModel findModel) {
        if (project == null) {
            FindUtil.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(10);
        }
        if (findModel == null) {
            FindUtil.$$$reportNull$$$0(11);
        }
        FindUtil.findAllAndShow(project, PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()), findModel);
    }

    private static void findAllAndShow(final @NotNull Project project, final @Nullable PsiFile psiFile, final @NotNull FindModel findModel) {
        List<Usage> usages;
        if (project == null) {
            FindUtil.$$$reportNull$$$0(12);
        }
        if (findModel == null) {
            FindUtil.$$$reportNull$$$0(13);
        }
        if ((usages = FindUtil.findAll(project, psiFile, findModel)) == null) {
            return;
        }
        UsageTarget[] usageTargets = new UsageTarget[]{new FindInProjectUtil.StringUsageTarget(project, findModel)};
        UsageViewPresentation usageViewPresentation = FindInProjectUtil.setupViewPresentation(false, findModel);
        UsageView view = UsageViewManager.getInstance((Project)project).showUsages(usageTargets, usages.toArray(Usage.EMPTY_ARRAY), usageViewPresentation);
        view.setRerunAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindUtil.findAllAndShow(project, psiFile, findModel);
            }

            @Override
            public boolean isEnabled() {
                return !project.isDisposed() && psiFile.isValid();
            }
        });
    }

    public static void searchBack(Project project, FileEditor fileEditor, @Nullable DataContext dataContext) {
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        FindUtil.searchBack(project, editor, dataContext);
    }

    public static void searchBack(Project project, Editor editor, @Nullable DataContext context) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project);
        if (!findManager.findWasPerformed() && !findManager.selectNextOccurrenceWasPerformed()) {
            new IncrementalFindAction().getHandler().execute(editor, context);
            return;
        }
        FindModel model = findManager.getFindNextModel(editor);
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model.setForward(!(model = model.clone()).isForward());
        if (!model.isGlobal() && !editor.getSelectionModel().hasSelection()) {
            model.setGlobal(true);
        }
        if (Direction.UP.equals(editor.getUserData(KEY)) && !model.isForward()) {
            offset = editor.getDocument().getTextLength();
        } else if (Direction.DOWN.equals(editor.getUserData(KEY)) && model.isForward()) {
            offset = 0;
        } else {
            editor.putUserData(KEY, null);
            offset = editor.getCaretModel().getOffset();
            if (!model.isForward() && offset > 0) {
                --offset;
            }
        }
        FindUtil.searchAgain(project, editor, offset, model);
    }

    public static boolean searchAgain(Project project, FileEditor fileEditor, @Nullable DataContext context) {
        if (!(fileEditor instanceof TextEditor)) {
            return false;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        return FindUtil.searchAgain(project, editor, context);
    }

    private static boolean searchAgain(Project project, Editor editor, @Nullable DataContext context) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project);
        if (!findManager.findWasPerformed() && !findManager.selectNextOccurrenceWasPerformed()) {
            new IncrementalFindAction().getHandler().execute(editor, context);
            return false;
        }
        FindModel model = findManager.getFindNextModel(editor);
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model = model.clone();
        if (Direction.DOWN.equals(editor.getUserData(KEY)) && model.isForward()) {
            offset = 0;
        } else if (Direction.UP.equals(editor.getUserData(KEY)) && !model.isForward()) {
            offset = editor.getDocument().getTextLength();
        } else {
            editor.putUserData(KEY, null);
            int n = offset = model.isGlobal() && model.isForward() ? editor.getSelectionModel().getSelectionEnd() : editor.getCaretModel().getOffset();
            if (!model.isForward() && offset > 0) {
                --offset;
            }
        }
        return FindUtil.searchAgain(project, editor, offset, model);
    }

    private static boolean searchAgain(Project project, Editor editor, int offset, FindModel model) {
        if (!model.isGlobal() && !editor.getSelectionModel().hasSelection()) {
            model.setGlobal(true);
        }
        model.setFromCursor(false);
        if (model.isReplaceState()) {
            model.setPromptOnReplace(true);
            model.setReplaceAll(false);
            FindUtil.replace(project, editor, offset, model);
            return true;
        }
        FindUtil.doSearch(project, editor, offset, true, model, true);
        return false;
    }

    public static void replace(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            FindUtil.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(15);
        }
        FindManager findManager = FindManager.getInstance((Project)project);
        FindModel model = findManager.getFindInFileModel().clone();
        String s = editor.getSelectionModel().getSelectedText();
        if (!StringUtil.isEmpty((String)s)) {
            if (s.indexOf(10) >= 0) {
                model.setGlobal(false);
            } else {
                model.setStringToFind(s);
                model.setGlobal(true);
            }
        } else {
            model.setGlobal(true);
        }
        model.setReplaceState(true);
        findManager.showFindDialog(model, () -> {
            int offset;
            if (!model.isGlobal() && editor.getSelectionModel().hasSelection()) {
                offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                ScrollType scrollType = model.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                FindUtil.moveCaretAndDontChangeSelection(editor, offset, scrollType);
            }
            if (model.isGlobal()) {
                if (model.isFromCursor()) {
                    offset = editor.getCaretModel().getOffset();
                    if (!model.isForward()) {
                        ++offset;
                    }
                } else {
                    offset = model.isForward() ? 0 : editor.getDocument().getTextLength();
                }
            } else {
                if (!editor.getSelectionModel().hasSelection()) {
                    findManager.setFindNextModel(null);
                    return;
                }
                int n = offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
            }
            if (s != null && editor.getSelectionModel().hasSelection() && s.equals(model.getStringToFind())) {
                if (model.isFromCursor() && model.isForward()) {
                    offset = Math.min(editor.getSelectionModel().getSelectionStart(), offset);
                } else if (model.isFromCursor() && !model.isForward()) {
                    offset = Math.max(editor.getSelectionModel().getSelectionEnd(), offset);
                }
            }
            findManager.setFindNextModel(null);
            findManager.getFindInFileModel().copyFrom(model);
            FindUtil.replace(project, editor, offset, model);
        });
    }

    public static boolean replace(@NotNull Project project, @NotNull Editor editor, int offset, @NotNull FindModel model) {
        if (project == null) {
            FindUtil.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(17);
        }
        if (model == null) {
            FindUtil.$$$reportNull$$$0(18);
        }
        return FindUtil.replace(project, editor, offset, model, (range2, replace) -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(@NotNull Project project, @NotNull Editor editor, int offset, @NotNull FindModel model, ReplaceDelegate delegate) {
        if (project == null) {
            FindUtil.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(20);
        }
        if (model == null) {
            FindUtil.$$$reportNull$$$0(21);
        }
        Document document = editor.getDocument();
        if (!FileDocumentManager.getInstance().requestWriting(document, project)) {
            return false;
        }
        document.startGuardedBlockChecking();
        boolean toPrompt = model.isPromptOnReplace();
        try {
            FindUtil.doReplace(project, editor, model, offset, toPrompt, delegate);
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
        }
        finally {
            document.stopGuardedBlockChecking();
        }
        return true;
    }

    private static void doReplace(@NotNull Project project, @NotNull Editor editor, @NotNull FindModel aModel, int caretOffset, boolean toPrompt, ReplaceDelegate delegate) {
        if (project == null) {
            FindUtil.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(23);
        }
        if (aModel == null) {
            FindUtil.$$$reportNull$$$0(24);
        }
        FindManager findManager = FindManager.getInstance((Project)project);
        FindModel model = aModel.clone();
        int occurrences = 0;
        ArrayList rangesToChange = new ArrayList();
        boolean replaced = false;
        boolean reallyReplaced = false;
        int offset = caretOffset;
        Document document = editor.getDocument();
        while (offset >= 0 && offset < document.getTextLength()) {
            int newOffset;
            String toReplace;
            caretOffset = offset;
            FindResult result2 = FindUtil.doSearch(project, editor, offset, !replaced, model, toPrompt);
            if (result2 == null) break;
            int startResultOffset = result2.getStartOffset();
            model.setFromCursor(true);
            int startOffset = result2.getStartOffset();
            int endOffset = result2.getEndOffset();
            String foundString = document.getCharsSequence().subSequence(startOffset, endOffset).toString();
            try {
                toReplace = findManager.getStringToReplace(foundString, model, startOffset, document.getCharsSequence());
            }
            catch (FindManager.MalformedReplacementStringException e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) break;
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
                break;
            }
            if (toPrompt) {
                int promptResult = findManager.showPromptDialog(model, FindBundle.message("find.replace.dialog.title", new Object[0]));
                if (promptResult == 2) {
                    offset = model.isForward() ? result2.getEndOffset() : startResultOffset;
                    continue;
                }
                if (promptResult == 1) break;
                if (promptResult == 3) {
                    toPrompt = false;
                }
            }
            if (delegate == null || delegate.shouldReplace((TextRange)result2, toReplace)) {
                if (toPrompt && !reallyReplaced) {
                    editor.getCaretModel().moveToOffset(0);
                    reallyReplaced = true;
                }
                TextRange textRange = FindUtil.doReplace(project, document, model, result2, toReplace, toPrompt, rangesToChange);
                replaced = true;
                int n = newOffset = model.isForward() ? textRange.getEndOffset() : textRange.getStartOffset();
                if (textRange.isEmpty()) {
                    ++newOffset;
                }
                ++occurrences;
            } else {
                int n = newOffset = model.isForward() ? result2.getEndOffset() : result2.getStartOffset();
            }
            if (newOffset == offset) {
                newOffset += model.isForward() ? 1 : -1;
            }
            offset = newOffset;
        }
        if (replaced) {
            if (toPrompt) {
                if (caretOffset > document.getTextLength()) {
                    caretOffset = document.getTextLength();
                }
                editor.getCaretModel().moveToOffset(caretOffset);
            } else {
                CharSequence text = document.getCharsSequence();
                StringBuilder newText = new StringBuilder(document.getTextLength());
                Collections.sort(rangesToChange, Comparator.comparingInt(o -> ((TextRange)o.getFirst()).getStartOffset()));
                int offsetBefore = 0;
                for (Pair pair : rangesToChange) {
                    TextRange range2 = (TextRange)pair.getFirst();
                    String replace = (String)pair.getSecond();
                    newText.append(text, offsetBefore, range2.getStartOffset());
                    if (delegate == null || delegate.shouldReplace(range2, replace)) {
                        newText.append(replace);
                    } else {
                        newText.append(text.subSequence(range2.getStartOffset(), range2.getEndOffset()));
                    }
                    if ((offsetBefore = range2.getEndOffset()) >= caretOffset) continue;
                    caretOffset += replace.length() - range2.getLength();
                }
                newText.append(text, offsetBefore, text.length());
                if (caretOffset > newText.length()) {
                    caretOffset = newText.length();
                }
                int finalCaretOffset = caretOffset;
                CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    document.setText((CharSequence)newText);
                    editor.getCaretModel().moveToOffset(finalCaretOffset);
                    if (model.isGlobal()) {
                        editor.getSelectionModel().removeSelection();
                    }
                }), null, (Object)document);
            }
        }
        ReplaceInProjectManager.reportNumberReplacedOccurrences(project, occurrences);
    }

    private static boolean selectionMayContainRange(SelectionModel selection, TextRange range2) {
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        return starts.length != 0 && new TextRange(starts[0], ends[starts.length - 1]).contains(range2);
    }

    private static boolean selectionStrictlyContainsRange(SelectionModel selection, TextRange range2) {
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        for (int i = 0; i < starts.length; ++i) {
            if (!new TextRange(starts[i], ends[i]).contains(range2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static FindResult doSearch(@NotNull Project project, @NotNull Editor editor, int offset, boolean toWarn, @NotNull FindModel model, boolean adjustEditor) {
        if (project == null) {
            FindUtil.$$$reportNull$$$0(25);
        }
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(26);
        }
        if (model == null) {
            FindUtil.$$$reportNull$$$0(27);
        }
        FindManager findManager = FindManager.getInstance((Project)project);
        Document document = editor.getDocument();
        FindResult result2 = findManager.findString(document.getCharsSequence(), offset, model, FindUtil.getVirtualFile(editor));
        boolean isFound = result2.isStringFound();
        SelectionModel selection = editor.getSelectionModel();
        if (isFound && !model.isGlobal()) {
            if (!FindUtil.selectionMayContainRange(selection, (TextRange)result2)) {
                isFound = false;
            } else if (!FindUtil.selectionStrictlyContainsRange(selection, (TextRange)result2)) {
                int[] starts;
                for (int newOffset : starts = selection.getBlockSelectionStarts()) {
                    if (newOffset <= result2.getStartOffset()) continue;
                    return FindUtil.doSearch(project, editor, newOffset, toWarn, model, adjustEditor);
                }
            }
        }
        if (!isFound) {
            if (toWarn) {
                FindUtil.processNotFound(editor, model.getStringToFind(), model, project);
            }
            return null;
        }
        if (adjustEditor) {
            ScrollType scrollType;
            CaretModel caretModel = editor.getCaretModel();
            ScrollingModel scrollingModel = editor.getScrollingModel();
            int oldCaretOffset = caretModel.getOffset();
            boolean forward = oldCaretOffset < result2.getStartOffset();
            ScrollType scrollType2 = scrollType = forward ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
            if (model.isGlobal()) {
                int targetCaretPosition = result2.getEndOffset();
                if (selection.getSelectionEnd() - selection.getSelectionStart() == result2.getLength()) {
                    targetCaretPosition = caretModel.getOffset() - selection.getSelectionStart() + result2.getStartOffset();
                }
                if (caretModel.getCaretAt(editor.offsetToVisualPosition(targetCaretPosition)) != null) {
                    return result2;
                }
                caretModel.moveToOffset(targetCaretPosition);
                selection.removeSelection();
                scrollingModel.scrollToCaret(scrollType);
                scrollingModel.runActionOnScrollingFinished(() -> {
                    scrollingModel.scrollTo(editor.offsetToLogicalPosition(result2.getStartOffset()), scrollType);
                    scrollingModel.scrollTo(editor.offsetToLogicalPosition(result2.getEndOffset()), scrollType);
                });
            } else {
                FindUtil.moveCaretAndDontChangeSelection(editor, result2.getStartOffset(), scrollType);
                FindUtil.moveCaretAndDontChangeSelection(editor, result2.getEndOffset(), scrollType);
            }
            IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            EditorColorsManager manager = EditorColorsManager.getInstance();
            TextAttributes selectionAttributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            if (!model.isGlobal()) {
                RangeHighlighterEx segmentHighlighter = (RangeHighlighterEx)editor.getMarkupModel().addRangeHighlighter(result2.getStartOffset(), result2.getEndOffset(), 6001, selectionAttributes, HighlighterTargetArea.EXACT_RANGE);
                MyListener listener2 = new MyListener(editor, segmentHighlighter);
                caretModel.addCaretListener((CaretListener)listener2);
            } else {
                selection.setSelection(result2.getStartOffset(), result2.getEndOffset());
            }
        }
        return result2;
    }

    public static void processNotFound(final Editor editor, String stringToFind, FindModel model, Project project) {
        String message = FindBundle.message("find.search.string.not.found.message", stringToFind);
        short position = 2;
        if (model.isGlobal()) {
            FindModel modelForNextSearch;
            Document document;
            FindModel newModel = model.clone();
            FindManager findManager = FindManager.getInstance((Project)project);
            FindResult result2 = findManager.findString((document = editor.getDocument()).getCharsSequence(), newModel.isForward() ? 0 : document.getTextLength(), model, FindUtil.getVirtualFile(editor));
            if (!result2.isStringFound()) {
                result2 = null;
            }
            if ((modelForNextSearch = findManager.getFindNextModel(editor)) == null) {
                modelForNextSearch = findManager.getFindInFileModel();
            }
            if (result2 != null) {
                AnAction action;
                if (newModel.isForward()) {
                    action = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindNext" : "FindPrevious");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
                    message = !shortcutsText.isEmpty() ? FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText) : FindBundle.message("find.search.again.from.top.action.message", message);
                    editor.putUserData(KEY, (Object)Direction.DOWN);
                } else {
                    action = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindPrevious" : "FindNext");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
                    message = !shortcutsText.isEmpty() ? FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText) : FindBundle.message("find.search.again.from.bottom.action.message", message);
                    editor.putUserData(KEY, (Object)Direction.UP);
                    position = 1;
                }
            }
            CaretListener listener2 = new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    editor.putUserData(KEY, null);
                    editor.getCaretModel().removeCaretListener((CaretListener)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/FindUtil$2", "caretPositionChanged"));
                }
            };
            editor.getCaretModel().addCaretListener(listener2);
        }
        JComponent component = HintUtil.createInformationLabel(JDOMUtil.escapeText((String)message, (boolean)false, (boolean)false));
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, position, 42, 0, false);
    }

    public static TextRange doReplace(Project project, Document document, @NotNull FindModel model, FindResult result2, @NotNull String stringToReplace, boolean reallyReplace, List<? super Pair<TextRange, String>> rangesToChange) {
        int start2;
        int end;
        block10: {
            String toFind;
            block11: {
                block12: {
                    int newOffset;
                    if (model == null) {
                        FindUtil.$$$reportNull$$$0(28);
                    }
                    if (stringToReplace == null) {
                        FindUtil.$$$reportNull$$$0(29);
                    }
                    int startOffset = result2.getStartOffset();
                    int endOffset = result2.getEndOffset();
                    if (reallyReplace) {
                        newOffset = FindUtil.doReplace(project, document, startOffset, endOffset, stringToReplace);
                    } else {
                        String converted = StringUtil.convertLineSeparators((String)stringToReplace);
                        TextRange textRange = new TextRange(startOffset, endOffset);
                        rangesToChange.add((Pair<TextRange, String>)Pair.create((Object)textRange, (Object)converted));
                        newOffset = endOffset;
                    }
                    if (!model.isRegularExpressions()) break block10;
                    toFind = model.getStringToFind();
                    if (!model.isForward()) break block11;
                    if (!StringUtil.endsWithChar((CharSequence)toFind, (char)'$')) break block12;
                    int i = 0;
                    int length = toFind.length();
                    while (i + 2 <= length && toFind.charAt(length - i - 2) == '\\') {
                        ++i;
                    }
                    if (i % 2 != 0) break block10;
                    ++end;
                    break block10;
                }
                if (!StringUtil.startsWithChar((CharSequence)toFind, (char)'^')) break block10;
                for (end = newOffset; end < document.getTextLength() && document.getCharsSequence().charAt(end) != '\n'; ++end) {
                }
                break block10;
            }
            if (StringUtil.startsWithChar((CharSequence)toFind, (char)'^')) {
                --start2;
            } else if (StringUtil.endsWithChar((CharSequence)toFind, (char)'$')) {
                for (start2 = startOffset; start2 >= 0 && document.getCharsSequence().charAt(start2) != '\n'; --start2) {
                }
            }
        }
        return new TextRange(start2, end);
    }

    private static int doReplace(Project project, Document document, int startOffset, int endOffset, String stringToReplace) {
        String converted = StringUtil.convertLineSeparators((String)stringToReplace);
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> document.replaceString(startOffset, endOffset, (CharSequence)converted)), null, null);
        return startOffset + converted.length();
    }

    private static void moveCaretAndDontChangeSelection(Editor editor, int offset, ScrollType scrollType) {
        LogicalPosition pos = editor.offsetToLogicalPosition(offset);
        editor.getCaretModel().moveToLogicalPosition(pos);
        editor.getScrollingModel().scrollToCaret(scrollType);
    }

    public static <T> UsageView showInUsageView(@Nullable PsiElement sourceElement, final @NotNull T[] targets, final @NotNull Function<? super T, ? extends Usage> usageConverter, @NotNull String title, @Nullable Consumer<? super UsageViewPresentation> presentationSetup, @NotNull Project project) {
        UsageTarget[] usageTargetArray;
        if (targets == null) {
            FindUtil.$$$reportNull$$$0(30);
        }
        if (usageConverter == null) {
            FindUtil.$$$reportNull$$$0(31);
        }
        if (title == null) {
            FindUtil.$$$reportNull$$$0(32);
        }
        if (project == null) {
            FindUtil.$$$reportNull$$$0(33);
        }
        if (targets.length == 0) {
            return null;
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setCodeUsagesString(title);
        presentation.setTabName(title);
        presentation.setTabText(title);
        if (presentationSetup != null) {
            presentationSetup.consume((Object)presentation);
        }
        if (sourceElement == null) {
            usageTargetArray = UsageTarget.EMPTY_ARRAY;
        } else {
            UsageTarget[] usageTargetArray2 = new UsageTarget[1];
            usageTargetArray = usageTargetArray2;
            usageTargetArray2[0] = new PsiElement2UsageTargetAdapter(sourceElement);
        }
        UsageTarget[] usageTargets = usageTargetArray;
        final UsageView view = UsageViewManager.getInstance((Project)project).showUsages(usageTargets, Usage.EMPTY_ARRAY, presentation);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Updating Usage View ..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (Object pointer : targets) {
                    if (((UsageViewImpl)view).isDisposed()) break;
                    ApplicationManager.getApplication().runReadAction(() -> {
                        Usage usage = (Usage)usageConverter.fun(pointer);
                        if (usage != null) {
                            view.appendUsage(usage);
                        }
                    });
                }
                UIUtil.invokeLaterIfNeeded(() -> ((UsageViewImpl)((UsageViewImpl)view)).expandAll());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/FindUtil$3", "run"));
            }
        });
        return view;
    }

    @Nullable
    public static UsageView showInUsageView(@Nullable PsiElement sourceElement, @NotNull PsiElement[] targets, @NotNull String title, @NotNull Project project) {
        PsiElement[] psiElementArray;
        if (targets == null) {
            FindUtil.$$$reportNull$$$0(34);
        }
        if (title == null) {
            FindUtil.$$$reportNull$$$0(35);
        }
        if (project == null) {
            FindUtil.$$$reportNull$$$0(36);
        }
        if (targets.length == 0) {
            return null;
        }
        if (sourceElement == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = sourceElement;
        }
        PsiElement[] primary = psiElementArray;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        SmartPsiElementPointer[] pointers = (SmartPsiElementPointer[])Stream.of(targets).map(arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0)).toArray(SmartPsiElementPointer[]::new);
        targets = PsiElement.EMPTY_ARRAY;
        return FindUtil.showInUsageView(sourceElement, pointers, p -> {
            PsiElement element = p.getElement();
            return element == null ? null : UsageInfoToUsageConverter.convert((PsiElement[])primary, (UsageInfo)new UsageInfo(element));
        }, title, null, project);
    }

    public static void selectSearchResultsInEditor(@NotNull Editor editor, @NotNull Iterator<? extends FindResult> resultIterator, int caretShiftFromSelectionStart) {
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(37);
        }
        if (resultIterator == null) {
            FindUtil.$$$reportNull$$$0(38);
        }
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            return;
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>();
        while (resultIterator.hasNext()) {
            FindResult findResult = resultIterator.next();
            int caretOffset = FindUtil.getCaretPosition(findResult, caretShiftFromSelectionStart);
            int selectionStartOffset = findResult.getStartOffset();
            int selectionEndOffset = findResult.getEndOffset();
            EditorActionUtil.makePositionVisible(editor, caretOffset);
            EditorActionUtil.makePositionVisible(editor, selectionStartOffset);
            EditorActionUtil.makePositionVisible(editor, selectionEndOffset);
            caretStates.add(new CaretState(editor.offsetToLogicalPosition(caretOffset), editor.offsetToLogicalPosition(selectionStartOffset), editor.offsetToLogicalPosition(selectionEndOffset)));
        }
        if (caretStates.isEmpty()) {
            return;
        }
        editor.getCaretModel().setCaretsAndSelections(caretStates);
    }

    public static boolean selectSearchResultInEditor(@NotNull Editor editor, @NotNull FindResult result2, int caretShiftFromSelectionStart) {
        if (editor == null) {
            FindUtil.$$$reportNull$$$0(39);
        }
        if (result2 == null) {
            FindUtil.$$$reportNull$$$0(40);
        }
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            return false;
        }
        int caretOffset = FindUtil.getCaretPosition(result2, caretShiftFromSelectionStart);
        LogicalPosition caretPosition = editor.offsetToLogicalPosition(caretOffset);
        if (caretShiftFromSelectionStart == 0) {
            caretPosition = caretPosition.leanForward(true);
        }
        EditorActionUtil.makePositionVisible(editor, caretOffset);
        Caret newCaret = editor.getCaretModel().addCaret(editor.logicalToVisualPosition(caretPosition));
        if (newCaret == null) {
            return false;
        }
        int selectionStartOffset = result2.getStartOffset();
        int selectionEndOffset = result2.getEndOffset();
        EditorActionUtil.makePositionVisible(editor, selectionStartOffset);
        EditorActionUtil.makePositionVisible(editor, selectionEndOffset);
        newCaret.setSelection(selectionStartOffset, selectionEndOffset);
        return true;
    }

    private static int getCaretPosition(FindResult findResult, int caretShiftFromSelectionStart) {
        return caretShiftFromSelectionStart < 0 ? findResult.getEndOffset() : Math.min(findResult.getStartOffset() + caretShiftFromSelectionStart, findResult.getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 18: 
            case 21: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModel";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToReplace";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageConverter";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultIterator";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/FindUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVirtualFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFindInFileModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findAll";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "findAllAndShow";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "doReplace";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "doSearch";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "showInUsageView";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "selectSearchResultsInEditor";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "selectSearchResultInEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface ReplaceDelegate {
        public boolean shouldReplace(TextRange var1, String var2);
    }

    private static class MyListener
    implements CaretListener {
        private final Editor myEditor;
        private final RangeHighlighter mySegmentHighlighter;

        private MyListener(@NotNull Editor editor, @NotNull RangeHighlighter segmentHighlighter) {
            if (editor == null) {
                MyListener.$$$reportNull$$$0(0);
            }
            if (segmentHighlighter == null) {
                MyListener.$$$reportNull$$$0(1);
            }
            this.myEditor = editor;
            this.mySegmentHighlighter = segmentHighlighter;
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (e == null) {
                MyListener.$$$reportNull$$$0(2);
            }
            this.removeAll();
        }

        private void removeAll() {
            this.myEditor.getCaretModel().removeCaretListener((CaretListener)this);
            this.mySegmentHighlighter.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segmentHighlighter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/FindUtil$MyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

