/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.EditIntentionSettingsAction;
import com.intellij.codeInsight.intention.impl.EnableDisableIntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionsPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myPassIdToShowIntentionsFor;
    private final IntentionsInfo myIntentionsInfo;
    private volatile CachedIntentions myCachedIntentions;
    private volatile boolean myActionsChanged;

    ShowIntentionsPass(@NotNull Project project, @NotNull Editor editor, int passId) {
        if (project == null) {
            ShowIntentionsPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(1);
        }
        super(project, editor.getDocument(), false);
        this.myIntentionsInfo = new IntentionsInfo();
        this.myPassIdToShowIntentionsFor = passId;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        this.myFile = documentManager.getPsiFile(this.myEditor.getDocument());
        assert (this.myFile != null) : FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
    }

    @NotNull
    public static List<HighlightInfo.IntentionActionDescriptor> getAvailableFixes(@NotNull Editor editor, @NotNull PsiFile file2, int passId) {
        if (editor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(3);
        }
        List<HighlightInfo.IntentionActionDescriptor> list2 = ShowIntentionsPass.getAvailableFixes(editor, file2, passId, ((EditorEx)editor).getExpectedCaretOffset());
        if (list2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static List<HighlightInfo.IntentionActionDescriptor> getAvailableFixes(@NotNull Editor editor, @NotNull PsiFile file2, int passId, int offset) {
        if (editor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(6);
        }
        Project project = file2.getProject();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor.getDocument(), project, HighlightSeverity.INFORMATION, offset, true, (Processor<? super HighlightInfo>)new CommonProcessors.CollectProcessor(infos));
        ArrayList<HighlightInfo.IntentionActionDescriptor> result2 = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        infos.forEach(info -> ShowIntentionsPass.addAvailableFixesForGroups(info, editor, file2, result2, passId, offset));
        ArrayList<HighlightInfo.IntentionActionDescriptor> arrayList = result2;
        if (arrayList == null) {
            ShowIntentionsPass.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static boolean markActionInvoked(@NotNull Project project, @NotNull Editor editor, @NotNull IntentionAction action) {
        if (project == null) {
            ShowIntentionsPass.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(9);
        }
        if (action == null) {
            ShowIntentionsPass.$$$reportNull$$$0(10);
        }
        int offset = ((EditorEx)editor).getExpectedCaretOffset();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor.getDocument(), project, HighlightSeverity.INFORMATION, offset, true, (Processor<? super HighlightInfo>)new CommonProcessors.CollectProcessor(infos));
        boolean removed = false;
        for (HighlightInfo info : infos) {
            if (info.quickFixActionMarkers == null) continue;
            for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
                if (actionInGroup.getAction() != action) continue;
                removed |= info.quickFixActionMarkers.remove(pair);
            }
        }
        return removed;
    }

    private static void addAvailableFixesForGroups(@NotNull HighlightInfo info, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull List<? super HighlightInfo.IntentionActionDescriptor> outList, int group, int offset) {
        if (info == null) {
            ShowIntentionsPass.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(13);
        }
        if (outList == null) {
            ShowIntentionsPass.$$$reportNull$$$0(14);
        }
        if (info.quickFixActionMarkers == null) {
            return;
        }
        if (group != -1 && group != info.getGroup()) {
            return;
        }
        boolean fixRangeIsNotEmpty = !info.getFixTextRange().isEmpty();
        Editor injectedEditor = null;
        PsiFile injectedFile = null;
        for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
            PsiFile fileToUse;
            Editor editorToUse;
            HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
            RangeMarker range2 = (RangeMarker)pair.second;
            if (!range2.isValid() || fixRangeIsNotEmpty && ShowIntentionsPass.isEmpty((Segment)range2) || DumbService.isDumb((Project)file2.getProject()) && !DumbService.isDumbAware((Object)actionInGroup.getAction())) continue;
            int start2 = range2.getStartOffset();
            int end = range2.getEndOffset();
            Project project = file2.getProject();
            if (start2 > offset || offset > end) continue;
            if (info.isFromInjection()) {
                if (injectedEditor == null) {
                    injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
                    injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
                }
                editorToUse = injectedFile == null ? editor : injectedEditor;
                fileToUse = injectedFile == null ? file2 : injectedFile;
            } else {
                editorToUse = editor;
                fileToUse = file2;
            }
            if (!actionInGroup.getAction().isAvailable(project, editorToUse, fileToUse)) continue;
            outList.add(actionInGroup);
        }
    }

    private static boolean isEmpty(@NotNull Segment segment) {
        if (segment == null) {
            ShowIntentionsPass.$$$reportNull$$$0(15);
        }
        return segment.getEndOffset() <= segment.getStartOffset();
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ShowIntentionsPass.$$$reportNull$$$0(16);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (state != null && !state.isFinished()) {
            return;
        }
        ShowIntentionsPass.getActionsToShow(this.myEditor, this.myFile, this.myIntentionsInfo, this.myPassIdToShowIntentionsFor);
        this.myCachedIntentions = IntentionsUI.getInstance(this.myProject).getCachedIntentions(this.myEditor, this.myFile);
        this.myActionsChanged = this.myCachedIntentions.wrapAndUpdateActions(this.myIntentionsInfo, true);
    }

    @Override
    public void doApplyInformationToEditor() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if ((state == null || state.isFinished()) && this.myCachedIntentions != null) {
            IntentionsUI.getInstance(this.myProject).update(this.myCachedIntentions, this.myActionsChanged);
        }
    }

    @NotNull
    public static IntentionsInfo getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile) {
        if (hostEditor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(17);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(18);
        }
        IntentionsInfo intentionsInfo = ShowIntentionsPass.getActionsToShow(hostEditor, hostFile, hostEditor.getCaretModel().getOffset());
        if (intentionsInfo == null) {
            ShowIntentionsPass.$$$reportNull$$$0(19);
        }
        return intentionsInfo;
    }

    @NotNull
    public static IntentionsInfo getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, int offset) {
        if (hostEditor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(20);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(21);
        }
        IntentionsInfo result2 = new IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(hostEditor, hostFile, result2, -1, offset);
        IntentionsInfo intentionsInfo = result2;
        if (intentionsInfo == null) {
            ShowIntentionsPass.$$$reportNull$$$0(22);
        }
        return intentionsInfo;
    }

    public static void getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor) {
        if (hostEditor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(23);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(24);
        }
        if (intentions == null) {
            ShowIntentionsPass.$$$reportNull$$$0(25);
        }
        ShowIntentionsPass.getActionsToShow(hostEditor, hostFile, intentions, passIdToShowIntentionsFor, hostEditor.getCaretModel().getOffset());
    }

    public static void getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset) {
        PsiElement psiElement;
        if (hostEditor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(26);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(27);
        }
        if (intentions == null) {
            ShowIntentionsPass.$$$reportNull$$$0(28);
        }
        if ((psiElement = hostFile.findElementAt(offset)) != null) {
            PsiUtilCore.ensureValid((PsiElement)psiElement);
        }
        intentions.setOffset(offset);
        Project project = hostFile.getProject();
        List<HighlightInfo.IntentionActionDescriptor> fixes = ShowIntentionsPass.getAvailableFixes(hostEditor, hostFile, passIdToShowIntentionsFor, offset);
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        Document hostDocument = hostEditor.getDocument();
        HighlightInfo infoAtCursor = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(hostDocument, offset, true);
        if (infoAtCursor == null) {
            intentions.errorFixesToShow.addAll(fixes);
        } else {
            ShowIntentionsPass.fillIntentionsInfoForHighlightInfo(infoAtCursor, intentions, fixes);
        }
        for (IntentionAction action : IntentionManager.getInstance().getAvailableIntentionActions()) {
            Pair<PsiFile, Editor> place = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(psiFile, editor) -> ShowIntentionActionsHandler.availableFor(psiFile, editor, action)));
            if (place == null) continue;
            ArrayList<IntentionAction> enableDisableIntentionAction = new ArrayList<IntentionAction>();
            enableDisableIntentionAction.add(new EnableDisableIntentionAction(action));
            enableDisableIntentionAction.add(new EditIntentionSettingsAction(action));
            HighlightInfo.IntentionActionDescriptor descriptor = new HighlightInfo.IntentionActionDescriptor(action, enableDisableIntentionAction, null);
            if (fixes.contains(descriptor)) continue;
            intentions.intentionsToShow.add(descriptor);
        }
        for (IntentionMenuContributor extension : IntentionMenuContributor.EP_NAME.getExtensionList()) {
            extension.collectActions(hostEditor, hostFile, intentions, passIdToShowIntentionsFor, offset);
        }
        intentions.filterActions(hostFile);
    }

    public static void fillIntentionsInfoForHighlightInfo(@NotNull HighlightInfo infoAtCursor, @NotNull IntentionsInfo intentions, @NotNull List<? extends HighlightInfo.IntentionActionDescriptor> fixes) {
        if (infoAtCursor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(29);
        }
        if (intentions == null) {
            ShowIntentionsPass.$$$reportNull$$$0(30);
        }
        if (fixes == null) {
            ShowIntentionsPass.$$$reportNull$$$0(31);
        }
        boolean isError = infoAtCursor.getSeverity() == HighlightSeverity.ERROR;
        for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : fixes) {
            if (intentionActionDescriptor.isError() && isError) {
                intentions.errorFixesToShow.add(intentionActionDescriptor);
                continue;
            }
            if (intentionActionDescriptor.isInformation()) {
                intentions.intentionsToShow.add(intentionActionDescriptor);
                continue;
            }
            intentions.inspectionFixesToShow.add(intentionActionDescriptor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outList";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 17: 
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 18: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoAtCursor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFixes";
                break;
            }
            case 19: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionsToShow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableFixes";
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 22: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "markActionInvoked";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAvailableFixesForGroups";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getActionsToShow";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fillIntentionsInfoForHighlightInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntentionsInfo {
        public final List<HighlightInfo.IntentionActionDescriptor> intentionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> errorFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> inspectionFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> guttersToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> notificationActionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        private int myOffset;

        public void filterActions(@Nullable PsiFile psiFile) {
            IntentionActionFilter[] filters = (IntentionActionFilter[])IntentionActionFilter.EXTENSION_POINT_NAME.getExtensions();
            IntentionsInfo.filter(this.intentionsToShow, psiFile, filters);
            IntentionsInfo.filter(this.errorFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.inspectionFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.guttersToShow, psiFile, filters);
            IntentionsInfo.filter(this.notificationActionsToShow, psiFile, filters);
        }

        public void setOffset(int offset) {
            this.myOffset = offset;
        }

        public int getOffset() {
            return this.myOffset;
        }

        private static void filter(@NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @Nullable PsiFile psiFile, @NotNull IntentionActionFilter[] filters) {
            if (descriptors == null) {
                IntentionsInfo.$$$reportNull$$$0(0);
            }
            if (filters == null) {
                IntentionsInfo.$$$reportNull$$$0(1);
            }
            Iterator<HighlightInfo.IntentionActionDescriptor> it = descriptors.iterator();
            block0: while (it.hasNext()) {
                HighlightInfo.IntentionActionDescriptor actionDescriptor = it.next();
                for (IntentionActionFilter filter : filters) {
                    if (filter.accept(actionDescriptor.getAction(), psiFile)) continue;
                    it.remove();
                    continue block0;
                }
            }
        }

        public boolean isEmpty() {
            return this.intentionsToShow.isEmpty() && this.errorFixesToShow.isEmpty() && this.inspectionFixesToShow.isEmpty() && this.guttersToShow.isEmpty() && this.notificationActionsToShow.isEmpty();
        }

        @NonNls
        public String toString() {
            return "Errors: " + this.errorFixesToShow + "; Inspection fixes: " + this.inspectionFixesToShow + "; Intentions: " + this.intentionsToShow + "; Gutters: " + this.guttersToShow + "; Notifications: " + this.notificationActionsToShow;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo";
            objectArray[2] = "filter";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

