/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.importToCvs;

import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionListWithSelection;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;

public class FileExtension {
    private final String myExtension;
    private final KeywordSubstitutionListWithSelection myKeywordSubstitution;

    public FileExtension(String extension) {
        this.myExtension = extension;
        this.myKeywordSubstitution = KeywordSubstitutionListWithSelection.createOnExtension(extension);
    }

    public FileExtension(String extension, String substitution) {
        this(extension);
        this.setKeywordSubstitution(KeywordSubstitutionWrapper.getValue(substitution));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileExtension)) {
            return false;
        }
        FileExtension fileExtension = (FileExtension)o;
        return !(this.myExtension != null ? !this.myExtension.equals(fileExtension.myExtension) : fileExtension.myExtension != null);
    }

    public int hashCode() {
        return this.myExtension != null ? this.myExtension.hashCode() : 0;
    }

    public void setKeywordSubstitution(KeywordSubstitutionWrapper substitution) {
        this.myKeywordSubstitution.select(substitution);
    }

    public KeywordSubstitutionListWithSelection getKeywordSubstitutionsWithSelection() {
        return this.myKeywordSubstitution;
    }

    public String getExtension() {
        return this.myExtension;
    }

    public KeywordSubstitutionWrapper getKeywordSubstitution() {
        return (KeywordSubstitutionWrapper)this.getKeywordSubstitutionsWithSelection().getSelection();
    }
}

