/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.RegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.function.Function;
import java.util.function.IntSupplier;

class ScrollPainter
extends RegionPainter.Alpha {
    private static final Color x0D = ScrollPainter.gray("mac.scroll.thumb.darcula.border", 13);
    private static final Color xA6 = ScrollPainter.gray("mac.scroll.thumb.darcula.fill", 166);
    private final int myOffset;
    private final float myAlphaBase;
    private final float myAlphaDelta;
    private final Color myFillColor;
    private final Color myDrawColor;

    private static Color gray(String key, int defaultValue) {
        return new JBColor(() -> {
            int value = Registry.intValue((String)key, (int)defaultValue);
            return value <= 0 ? Gray._0 : (value >= 255 ? Gray._255 : Gray.get((int)value));
        });
    }

    private static IntSupplier value(String key, int defaultValue) {
        return () -> {
            int value = Registry.intValue((String)key, (int)defaultValue);
            return value <= 0 ? 0 : (value >= 255 ? 255 : value);
        };
    }

    private ScrollPainter(int offset, float base, float delta, Color fill, Color draw) {
        this.myOffset = offset;
        this.myAlphaBase = base;
        this.myAlphaDelta = delta;
        this.myFillColor = fill;
        this.myDrawColor = draw;
    }

    protected float getAlpha(Float value) {
        return value != null ? this.myAlphaBase + this.myAlphaDelta * value.floatValue() : 0.0f;
    }

    protected void paint(Graphics2D g, int x, int y, int width, int height) {
        if (this.myOffset > 0) {
            x += this.myOffset;
            y += this.myOffset;
            width -= this.myOffset + this.myOffset;
            height -= this.myOffset + this.myOffset;
        }
        if (width > 0 && height > 0) {
            if (this.myFillColor != null) {
                g.setColor(this.myFillColor);
                this.fill(g, x, y, width, height, this.myDrawColor != null);
            }
            if (this.myDrawColor != null) {
                g.setColor(this.myDrawColor);
                this.draw(g, x, y, width, height);
            }
        }
    }

    protected void fill(Graphics2D g, int x, int y, int width, int height, boolean border) {
        if (border) {
            g.fillRect(x + 1, y + 1, width - 2, height - 2);
        } else {
            g.fillRect(x, y, width, height);
        }
    }

    protected void draw(Graphics2D g, int x, int y, int width, int height) {
        RectanglePainter.DRAW.paint(g, x, y, width, height, null);
    }

    static /* synthetic */ Color access$1100() {
        return xA6;
    }

    static /* synthetic */ Color access$1200() {
        return x0D;
    }

    private static class TrackPainter
    extends ScrollPainter {
        private final IntSupplier supplier;

        private TrackPainter(String alpha, String fill) {
            super(0, 0.0f, 0.0f, ScrollPainter.gray(fill, 128), null);
            this.supplier = ScrollPainter.value(alpha, 26);
        }

        @Override
        protected float getAlpha(Float value) {
            return value == null ? 0.0f : value.floatValue() * (float)this.supplier.getAsInt() / 255.0f;
        }
    }

    private static final class EditorThumbPainter
    extends RegionPainter.Alpha {
        private final int myOffset;
        private final IntSupplier myAlphaBase;
        private final IntSupplier myAlphaDelta;
        private final Function<? super Float, ? extends Color> myFillFunction;
        private final Color myDrawColor;
        private Color myFillColor;

        private EditorThumbPainter(int offset, IntSupplier base, IntSupplier delta, Function<? super Float, ? extends Color> fill, Color draw) {
            this.myOffset = offset;
            this.myAlphaBase = base;
            this.myAlphaDelta = delta;
            this.myFillFunction = fill;
            this.myDrawColor = draw;
        }

        private float getAlpha(int width, int height) {
            if (width == height) {
                return this.myAlphaBase.getAsInt() + this.myAlphaDelta.getAsInt();
            }
            int size = Math.abs(width - height);
            float threshold = JBUI.scale((float)500.0f);
            if (threshold <= (float)size) {
                return this.myAlphaBase.getAsInt();
            }
            float function = 1.0f - (float)size / threshold;
            return (float)this.myAlphaBase.getAsInt() + (float)this.myAlphaDelta.getAsInt() * function * function;
        }

        public void paint(Graphics2D g, int x, int y, int width, int height, Float value) {
            if (this.myOffset > 0) {
                x += this.myOffset;
                y += this.myOffset;
                width -= this.myOffset + this.myOffset;
                height -= this.myOffset + this.myOffset;
            }
            if (width > 0 && height > 0) {
                this.myFillColor = this.myFillFunction.apply(value);
                super.paint(g, x, y, width, height, Float.valueOf(this.getAlpha(width, height) / 255.0f));
            }
        }

        protected void paint(Graphics2D g, int x, int y, int width, int height) {
            RectanglePainter.paint((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (int)(SystemInfo.isMac ? Math.min(width, height) : 0), (Paint)this.myFillColor, (Paint)this.myDrawColor);
        }
    }

    private static final class ColorFunction
    implements Function<Float, Color> {
        private final IntSupplier myMinSupplier;
        private final IntSupplier myMaxSupplier;

        private ColorFunction(IntSupplier min, IntSupplier max) {
            this.myMinSupplier = min;
            this.myMaxSupplier = max;
        }

        @Override
        public Color apply(Float value) {
            int max;
            int min = this.myMinSupplier.getAsInt();
            if (value != null && (max = this.myMaxSupplier.getAsInt()) != min) {
                min += (int)(0.5 + (double)(value.floatValue() * (float)(max - min)));
            }
            return new Color(min, min, min);
        }
    }

    private static class Round
    extends ScrollPainter {
        private Round(int offset, float base, float delta, Color fill, Color draw) {
            super(offset, base, delta, fill, draw);
        }

        @Override
        protected void fill(Graphics2D g, int x, int y, int width, int height, boolean border) {
            RectanglePainter.FILL.paint(g, x, y, width, height, (Object)Math.min(width, height));
        }

        @Override
        protected void draw(Graphics2D g, int x, int y, int width, int height) {
            RectanglePainter.DRAW.paint(g, x, y, width, height, (Object)Math.min(width, height));
        }
    }

    static final class EditorThumb {
        private static final RegionPainter<Float> DARCULA_OLD = new ScrollPainter(0, 0.33f, 0.12f, (Color)Gray.xA6, (Color)Gray.x1A);
        private static final RegionPainter<Float> DARCULA_NEW = new EditorThumbPainter(0, ScrollPainter.access$300("win.editor.thumb.darcula.alpha.base", 89), ScrollPainter.access$300("win.editor.thumb.darcula.alpha.delta", 166), new ColorFunction(ScrollPainter.access$300("win.editor.thumb.darcula.fill.min", 140), ScrollPainter.access$300("win.editor.thumb.darcula.fill.max", 161)), ScrollPainter.access$500("win.editor.thumb.darcula.border", 31));
        private static final RegionPainter<Float> DEFAULT_OLD = new ScrollPainter(0, 0.25f, 0.15f, (Color)Gray.x80, (Color)Gray.x59);
        private static final RegionPainter<Float> DEFAULT_NEW = new EditorThumbPainter(0, ScrollPainter.access$300("win.editor.thumb.default.alpha.base", 140), ScrollPainter.access$300("win.editor.thumb.default.alpha.delta", 115), new ColorFunction(ScrollPainter.access$300("win.editor.thumb.default.fill.min", 158), ScrollPainter.access$300("win.editor.thumb.default.fill.max", 189)), ScrollPainter.access$500("win.editor.thumb.default.border", 140));
        static final RegionPainter<Float> DARCULA = new RegionPainter<Float>(){

            public void paint(Graphics2D g, int x, int y, int width, int height, Float value) {
                RegionPainter painter = Registry.is((String)"ide.editor.thumb.experimental") ? DARCULA_NEW : DARCULA_OLD;
                painter.paint(g, x, y, width, height, (Object)value);
            }
        };
        static final RegionPainter<Float> DEFAULT = new RegionPainter<Float>(){

            public void paint(Graphics2D g, int x, int y, int width, int height, Float value) {
                RegionPainter painter = Registry.is((String)"ide.editor.thumb.experimental") ? DEFAULT_NEW : DEFAULT_OLD;
                painter.paint(g, x, y, width, height, (Object)value);
            }
        };

        EditorThumb() {
        }

        static final class Mac {
            private static final RegionPainter<Float> DARCULA_OLD = new Round(1, 0.35f, 0.2f, ScrollPainter.access$1100(), ScrollPainter.access$1200());
            private static final RegionPainter<Float> DARCULA_NEW = new EditorThumbPainter(1, ScrollPainter.access$300("mac.editor.thumb.darcula.alpha.base", 102), ScrollPainter.access$300("mac.editor.thumb.darcula.alpha.delta", 153), new ColorFunction(ScrollPainter.access$300("mac.editor.thumb.darcula.fill.min", 140), ScrollPainter.access$300("mac.editor.thumb.darcula.fill.max", 161)), ScrollPainter.access$500("mac.editor.thumb.darcula.border", 31));
            private static final RegionPainter<Float> DEFAULT_OLD = Thumb.Mac.DEFAULT;
            private static final RegionPainter<Float> DEFAULT_NEW = new EditorThumbPainter(2, ScrollPainter.access$300("mac.editor.thumb.default.alpha.base", 102), ScrollPainter.access$300("mac.editor.thumb.default.alpha.delta", 153), new ColorFunction(ScrollPainter.access$300("mac.editor.thumb.default.fill.min", 89), ScrollPainter.access$300("mac.editor.thumb.default.fill.max", 115)), null);
            static final RegionPainter<Float> DARCULA = new RegionPainter<Float>(){

                public void paint(Graphics2D g, int x, int y, int width, int height, Float value) {
                    RegionPainter painter = Registry.is((String)"ide.editor.thumb.experimental") ? DARCULA_NEW : DARCULA_OLD;
                    painter.paint(g, x, y, width, height, (Object)value);
                }
            };
            static final RegionPainter<Float> DEFAULT = new RegionPainter<Float>(){

                public void paint(Graphics2D g, int x, int y, int width, int height, Float value) {
                    RegionPainter painter = Registry.is((String)"ide.editor.thumb.experimental") ? DEFAULT_NEW : DEFAULT_OLD;
                    painter.paint(g, x, y, width, height, (Object)value);
                }
            };

            Mac() {
            }
        }
    }

    static final class Thumb {
        static final RegionPainter<Float> DARCULA = new ScrollPainter(0, 0.28f, 0.07f, (Color)Gray.xA6, (Color)Gray.x38);
        static final RegionPainter<Float> DEFAULT = new ScrollPainter(0, 0.2f, 0.08f, (Color)Gray.x73, (Color)Gray.x59);

        Thumb() {
        }

        static final class Mac {
            static final RegionPainter<Float> DARCULA = new Round(1, 0.35f, 0.2f, (Color)Gray.x80, (Color)Gray.x26);
            static final RegionPainter<Float> DEFAULT = new Round(2, 0.2f, 0.3f, (Color)Gray.x00, null);

            Mac() {
            }

            static final class Overlay {
                static final RegionPainter<Float> DARCULA = new Round(1, 0.0f, 0.55f, (Color)Gray.x80, (Color)Gray.x26);
                static final RegionPainter<Float> DEFAULT = new Round(2, 0.0f, 0.5f, (Color)Gray.x00, null);

                Overlay() {
                }
            }
        }
    }

    static final class Track {
        static final RegionPainter<Float> DARCULA = new TrackPainter("ide.scroll.track.darcula.alpha", "ide.scroll.track.darcula.fill");
        static final RegionPainter<Float> DEFAULT = new TrackPainter("ide.scroll.track.default.alpha", "ide.scroll.track.default.fill");

        Track() {
        }
    }
}

